/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LinkCoordinatorNotEnabledTaskErrorCode$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTaskState$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\r\u001b\u0001\u0005B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011%9\u0004A!A!\u0002\u0013Ad\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\"C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'Z\u0011%Q\u0006A!A!\u0002\u0013Yv\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004m\u0001\u0001\u0007I\u0011B7\t\u000f9\u0004\u0001\u0019!C\u0005_\"1Q\u000f\u0001Q!\naBqA\u001e\u0001C\u0002\u0013\u0005q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0001\r\u0011\"\u0003~\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0015\u0002@\t\u000f\u0005e\u0001\u0001\"\u0015\u0002\u001c!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003\u000f\u0003A\u0011KAE\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a&\u0001\t\u0013\tIJ\u0001\u000fDYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY:D_:4\u0017nZ:\u000b\u0005ma\u0012\u0001\u00027j].T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"aI\u0014\u000f\u0005\u0011*S\"\u0001\u000e\n\u0005\u0019R\u0012\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002)S\ta\u0001+\u001a:j_\u0012L7\rV1tW*\u0011aEG\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0011\u0005\u0011b\u0013BA\u0017\u001b\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fq\"\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0003IAJ!!\r\u000e\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\t\u0003IQJ!!\u000e\u000e\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006QAn\\2bY\u0006#W.\u001b8\u0002\u001dMLhnY%oi\u0016\u0014h/\u00197NgB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t\u0019\u0011J\u001c;\n\u0005}:\u0013!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u00069Q.\u001a;sS\u000e\u001c\bC\u0001\u0013C\u0013\t\u0019%D\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u00037j].$\u0015\r^1\u0011\u0005\u0019KU\"A$\u000b\u0005!s\u0012A\u0001>l\u0013\tQuIA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003\u0011!\u0018.\\3\u0011\u00055;V\"\u0001(\u000b\u0005=\u0003\u0016!B;uS2\u001c(BA)S\u0003\u0019\u0019w.\\7p]*\u0011qd\u0015\u0006\u0003)V\u000ba!\u00199bG\",'\"\u0001,\u0002\u0007=\u0014x-\u0003\u0002Y\u001d\n!A+[7f\u0013\tYu%A\u0003rk>$\u0018\r\u0005\u0002];6\tA$\u0003\u0002_9\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u00035\u001e\na\u0001P5oSRtDC\u00032dI\u00164w\r[5kWB\u0011A\u0005\u0001\u0005\u0006U)\u0001\ra\u000b\u0005\u0006])\u0001\ra\f\u0005\u0006e)\u0001\ra\r\u0005\u0006m)\u0001\ra\r\u0005\u0006o)\u0001\r\u0001\u000f\u0005\u0006\u0001*\u0001\r!\u0011\u0005\u0006\t*\u0001\r!\u0012\u0005\u0006\u0017*\u0001\r\u0001\u0014\u0005\u00065*\u0001\raW\u0001\u0011i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e,\u0012\u0001O\u0001\u0015i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F%Z9\u0015\u0005A\u001c\bCA\u001dr\u0013\t\u0011(H\u0001\u0003V]&$\bb\u0002;\r\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0014!\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8hA\u00059R\r_2fgNLg/\u001a'pO\u001eLgn\u001a%b]\u0012dWM]\u000b\u0002qB\u0011A%_\u0005\u0003uj\u0011q#\u0012=dKN\u001c\u0018N^3M_\u001e<\u0017N\\4IC:$G.\u001a:\u00021\u0015D8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014\b%\u0001\u0005uCN\\G)Z:d+\u0005q\b\u0003B\u001d\u0000\u0003\u0007I1!!\u0001;\u0005\u0019y\u0005\u000f^5p]B\u0019A%!\u0002\n\u0007\u0005\u001d!DA\bUCN\\G)Z:de&\u0004H/[8o\u00031!\u0018m]6EKN\u001cw\fJ3r)\r\u0001\u0018Q\u0002\u0005\biF\t\t\u00111\u0001\u007f\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002\u0013\u0003'\u00012!OA\u000b\u0013\r\t9B\u000f\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005u\u0001\u0003BA\u0010\u0003gq1!!\t&\u001d\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012q\u0006\b\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$C\u0002\u00026%\u0012!\u0002V1tWJ+7/\u001e7u\u0003iA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016$v\u000e]5d\u0007>tg-[4t)\u0019\ti\"a\u000f\u0002F!9\u0011Q\b\u000bA\u0002\u0005}\u0012a\u0003;bg.\u001cuN\u001c;fqR\u0004B!a\b\u0002B%\u0019\u00111I\u0015\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u000f\"\u0002\u0019AA%\u0003\u0019\u0011Xm];miBA\u00111JA)\u0003+\n\t'\u0004\u0002\u0002N)\u0019\u0011q\n\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00055#aA'baB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\A\u000baaY8oM&<\u0017\u0002BA0\u00033\u0012abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0004\u0002d\u0005\u0015\u0014\u0011N\u0007\u0002!&\u0019\u0011q\r)\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0015\tG-\\5o\u0015\r\t\u0019HU\u0001\bG2LWM\u001c;t\u0013\u0011\t9(!\u001c\u0003\r\r{gNZ5h\u0003]A\u0017M\u001c3mK\u0006cG/\u001a:U_BL7mQ8oM&<7\u000f\u0006\u0004\u0002\u001e\u0005u\u0014q\u0010\u0005\b\u0003{)\u0002\u0019AA \u0011\u001d\t9%\u0006a\u0001\u0003\u0003\u0003B!a\u001b\u0002\u0004&!\u0011QQA7\u0005I\tE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\u0007A\fY\tC\u0004\u0002HY\u0001\r!!$\u0011\u0007\r\ny)C\u0002\u0002\u0012&\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0002}\u0006\u0001Bn\\4B]\u0012,U.\u001b;NKR\u0014\u0018n\u0019\u000b\ba\u0006m\u0015\u0011WAc\u0011\u001d\ti\n\u0007a\u0001\u0003?\u000b!!\u001a=\u0011\t\u0005\u0005\u00161\u0016\b\u0005\u0003G\u000b9K\u0004\u0003\u0002(\u0005\u0015\u0016\"A\u001e\n\u0007\u0005%&(A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0016q\u0016\u0002\n)\"\u0014xn^1cY\u0016T1!!+;\u0011\u001d\t\u0019\f\u0007a\u0001\u0003k\u000ba!\u001a:s\u001bN<\u0007\u0003BA\\\u0003\u007fsA!!/\u0002<B\u0019\u0011q\u0005\u001e\n\u0007\u0005u&(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\f\u0019M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{S\u0004bBAd1\u0001\u0007\u0011\u0011Z\u0001\u0007g\u0016t7o\u001c:\u0011\t\u0005-\u0017qZ\u0007\u0003\u0003\u001bT!\u0001\u0011)\n\t\u0005E\u0017Q\u001a\u0002\u0007'\u0016t7o\u001c:")
public class ClusterLinkSyncTopicsConfigs
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkData linkData;
    private int tasksOutstanding;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private volatile Option<TaskDescription> taskDesc;

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    public ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.tasksOutstanding() != 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
            this.tasksOutstanding_$eq(0);
        }
        Set<String> topics = this.clientManager.getTopics();
        scala.collection.immutable.Set resources = ((IterableOnceOps)topics.map((Function1 & Serializable)name -> new ConfigResource(ConfigResource.Type.TOPIC, name))).toSet();
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (resources.nonEmpty()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Attempting to retrieve topic configs from source cluster for following mirror topics: ").append(topics).toString());
            DescribeConfigsResult describeConfigsResult = this.remoteAdmin.describeConfigs(CollectionConverters$.MODULE$.SetHasAsJava((Set)resources).asJava());
            this.scheduleWhenComplete(describeConfigsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeTopicConfigs((ClusterLinkScheduler.TaskContext)tc, (Map<ConfigResource, KafkaFuture<Config>>)CollectionConverters$.MODULE$.MapHasAsScala(describeConfigsResult.values()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleDescribeTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, Map<ConfigResource, KafkaFuture<Config>> result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        HashMap<ConfigResource, Collection<AlterConfigOp>> alterConfigRequestMap = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        scala.collection.mutable.Map updatedConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterable errs = (Iterable)result.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void var9_9;
                String topic;
                ConfigResource resource = (ConfigResource)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                Tuple2 tuple2 = this.liftedTree1$1(future, topic = resource.name());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option newSourceTopicConfigOpt = (Option)tuple2._1();
                Option errOpt = (Option)tuple2._2();
                if (var9_9 instanceof Some) {
                    TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var9_9).value();
                    return new Some((Object)err);
                }
                if (None$.MODULE$.equals(var9_9)) {
                    try {
                        Properties newProps;
                        void var8_8;
                        if (var8_8.isEmpty()) {
                            throw new IllegalStateException(new StringBuilder(59).append(this.logIdent()).append("There should be a source config for ").append(topic).append(" if there was no error.").toString());
                        }
                        Config newSourceTopicConfig = (Config)var8_8.get();
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Topic configuration for source topic ").append(topic).append(" is: ").append(newSourceTopicConfig).toString());
                        MirrorTopicConfigSyncRules topicConfigSyncRules = $this.clientManager.topicConfigSyncRules();
                        Properties curProps = $this.metadataManager.getTopicConfig(topic);
                        Properties resolvedProps = new MirrorTopicConfigsDelegate(curProps, newSourceTopicConfig, topicConfigSyncRules).updateMirrorProps(topic);
                        Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(topic, resolvedProps, $this.clientManager.alterConfigPolicy());
                        if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Updating local configuration for mirror topic '").append(topic).append("' on cluster link '").append($this.clientManager.linkData().linkName()).append("'").toString());
                            scala.collection.mutable.Set newTopicConfigs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(newProps.entrySet()).asScala().diff((Set)CollectionConverters$.MODULE$.SetHasAsScala(curProps.entrySet()).asScala());
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Adding configs ").append(newTopicConfigs).append(" for topic ").append(topic).append(" on target cluster").toString());
                            HashSet newConfigs = new HashSet();
                            CollectionConverters$.MODULE$.PropertiesHasAsScala(newProps).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                            alterConfigRequestMap.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), newConfigs);
                            updatedConfigs.put((Object)topic, (Object)new Some((Object)newSourceTopicConfig));
                        }
                        return None$.MODULE$;
                    }
                    catch (PolicyViolationException e) {
                        String errMsg = new StringBuilder(87).append("Could not update mirror topic '").append(topic).append("' configuration due to policy violation on ").append("cluster link ").append($this.clientManager.linkData().linkName()).toString();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        return new Some((Object)new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, errMsg));
                    }
                    catch (Throwable e) {
                        String errMsg = new StringBuilder(92).append("Error encountered while processing remote configuration for mirror topic '").append(topic).append("' ").append("on cluster link ").append($this.clientManager.linkData().linkName()).toString();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                }
                throw new MatchError((Object)var9_9);
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (!alterConfigRequestMap.isEmpty()) {
            AlterConfigsResult alterConfigResult = this.localAdmin.incrementalAlterConfigs(alterConfigRequestMap);
            this.scheduleWhenComplete(alterConfigResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterTopicConfigs((ClusterLinkScheduler.TaskContext)tc, alterConfigResult), newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleAlterTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, AlterConfigsResult result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.mutable.Set errs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(result.values().entrySet()).asScala().flatMap((Function1 & Serializable)entry -> {
            String topic = ((ConfigResource)entry.getKey()).name();
            try {
                ((KafkaFuture)entry.getValue()).get();
                $this.metrics.topicConfigUpdateSensor().record();
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully updated configuration for mirror topic ").append(topic).toString());
                return None$.MODULE$;
            }
            catch (ExecutionException ex) {
                TaskErrorCodeAndMsg taskErrorCodeAndMsg;
                KafkaException kafkaException;
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = new StringBuilder(64).append("Unable to alter topic configs due to authentication issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
                } else if (throwable instanceof AuthorizationException) {
                    String errMsg = new StringBuilder(63).append("Unable to alter topic configs due to authorization issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
                } else {
                    String errMsg = new StringBuilder(58).append("Unable to alter topic configs due to internal issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
                }
                TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
                this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), $this.metrics.topicConfigUpdateFailedSensor());
                return new Some((Object)taskErrorCodeAndMsg2);
            }
            catch (Throwable e) {
                String errMsg = new StringBuilder(63).append("Error encountered while altering configuration on mirror topic ").append(topic).toString();
                this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        });
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        boolean isLinkCoordinatorEnabled = this.metadataManager.isLinkCoordinatorEnabled();
        boolean isLinkCoordinator = this.metadataManager.isLinkCoordinator(this.linkData.linkName());
        if (isLinkCoordinatorEnabled && isLinkCoordinator) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncTopicConfigsTaskType$.MODULE$, "run the topic configs sync task"));
            bl = false;
        } else if (!isLinkCoordinatorEnabled && isLinkCoordinator) {
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(UnknownTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)new .colon.colon((Object)new TaskErrorCodeAndMsg(LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$, "The cluster linking link coordinator is not enabled."), (List)Nil$.MODULE$))));
            bl = true;
        } else {
            this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
            bl = true;
        }
        if (bl) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private void logAndEmitMetric(Throwable ex, String errMsg, Sensor sensor) {
        this.excessiveLoggingHandler().handle(ex, this, errMsg);
        sensor.record();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture future$1, String topic$1) {
        try {
            return new Tuple2((Object)new Some(future$1.get()), (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = new StringBuilder(67).append("Unable to describe topic configs due to authentication issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = new StringBuilder(66).append("Unable to describe topic configs due to authorization issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof UnknownTopicOrPartitionException) {
                String errMsg = new StringBuilder(83).append("Unable to describe topic configs due to unknown topic partition on the source for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = new StringBuilder(61).append("Unable to describe topic configs due to internal issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
            this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), this.metrics.topicConfigUpdateFailedSensor());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)taskErrorCodeAndMsg2));
        }
        catch (Throwable ex) {
            String errMsg = new StringBuilder(61).append("Unable to describe topic configs due to internal issues for ").append(topic$1).append(".").toString();
            this.logAndEmitMetric(ex, errMsg, this.metrics.topicConfigUpdateFailedSensor());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkSyncTopicsConfigs(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, int syncIntervalMs, ClusterLinkMetrics metrics, ClusterLinkData linkData, Time time, ClusterLinkRequestQuota quota) {
        void apply_now;
        void apply_ttlMs;
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.linkData = linkData;
        super(clientManager.scheduler(), "ClusterLinkSyncTopicsConfigs", syncIntervalMs, time, quota);
        this.tasksOutstanding = 0;
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var14_10 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        function0 = null;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(this.getClass().getSimpleName()).append("-").append(linkData.linkName()).append("] ").toString());
        this.taskDesc = None$.MODULE$;
    }
}

