/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.CachedControllerId;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.K2MetadataCache;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\u0015d\u0001\u0002\u001b6\u0001qB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\u0002eCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003z\u0006\"B2\u0001\t\u0003\"\u0007\"\u00029\u0001\t\u0003\n\b\"CA*\u0001E\u0005I\u0011AA+\u0011%\tY\u0007AI\u0001\n\u0003\t)\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\ty\u000b\u0001C!\u0003cCq!!.\u0001\t\u0003\n9\fC\u0004\u0002X\u0002!\t%!7\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u00111\u001f\u0001\u0005B\u0005U\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AqAa\t\u0001\t\u0003\u0012)\u0003C\u0004\u00036\u0001!\tEa\u000e\t\u000f\tm\u0002\u0001\"\u0011\u0003>!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B#\u0001\u0011\u0005!1\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005+BqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\t=\u0004\u0001\"\u0011\u0003r!9!Q\u0010\u0001\u0005B\t}\u0004b\u0002BA\u0001\u0011\u0005#1\u0011\u0005\b\u0005#\u0003A\u0011\tBJ\u0011\u001d\u0011\t\n\u0001C!\u0005/CqAa'\u0001\t\u0003\u0012i\nC\u0004\u0003*\u0002!\tEa+\t\u000f\t\u0005\u0007\u0001\"\u0011\u0003D\"9!\u0011\u001b\u0001\u0005B\tM\u0007b\u0002Bn\u0001\u0011\u0005#Q\u001c\u0005\b\u0005C\u0004A\u0011\tBr\u0011\u001d\u0011I\u0010\u0001C!\u0005wDaaa\u0004\u0001\t\u0003J\u0006bBB\t\u0001\u0011\u000531\u0003\u0005\b\u0007/\u0001A\u0011IB\r\u0011\u001d\u0019i\u0003\u0001C!\u0007_Aqaa\u0010\u0001\t\u0003\u001a\tE\u0001\u000bLe-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003m]\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003qe\naa]3sm\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!P\"\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g!\t!U)D\u00016\u0013\t1UGA\fL%\u00064G/S7bO\u0016lU\r^1eCR\f7)Y2iK\u0006Q1N]1gi\u000e\u000b7\r[3\u0016\u0003%\u0003\"\u0001\u0012&\n\u0005-+$AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f1b\u001b:bMR\u001c\u0015m\u00195fA\u000591NM\"bG\",W#A(\u0011\u0005\u0011\u0003\u0016BA)6\u0005=Y%'T3uC\u0012\fG/Y\"bG\",\u0017\u0001C63\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\rqJg.\u001b;?)\r)fk\u0016\t\u0003\t\u0002AQaR\u0003A\u0002%CQ!T\u0003A\u0002=\u000bqD^1mS\u0012\fG/Z#yG2,8/\u001b<jif\f5M]8tg\u000e\u000b7\r[3t+\u0005Q\u0006C\u0001 \\\u0013\tavHA\u0004C_>dW-\u00198\u0002AY\fG.\u001b3bi\u0016,\u0005p\u00197vg&4\u0018\u000e^=BGJ|7o]\"bG\",7\u000fI\u0001\tEJ|7.\u001a:JIV\t\u0001\r\u0005\u0002?C&\u0011!m\u0010\u0002\u0004\u0013:$\u0018\u0001D2veJ,g\u000e^%nC\u001e,G#A3\u0011\u0005\u0019tW\"A4\u000b\u0005!L\u0017!B5nC\u001e,'B\u0001\u001ek\u0015\tYG.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0006\u0019qN]4\n\u0005=<'!D'fi\u0006$\u0017\r^1J[\u0006<W-\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRI!/!\t\u0002<\u0005-\u0013q\n\t\u0004gZDX\"\u0001;\u000b\u0005U|\u0014AC2pY2,7\r^5p]&\u0011q\u000f\u001e\u0002\u0004'\u0016\f\bcA=\u0002\u001c9\u0019!0!\u0006\u000f\u0007m\fyAD\u0002}\u0003\u0017q1!`A\u0005\u001d\rq\u0018q\u0001\b\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aO\u0001\u0007yI|w\u000e\u001e \n\u00035L!a\u001b7\n\u0005iR\u0017bAA\u0007S\u000611m\\7n_:LA!!\u0005\u0002\u0014\u00059Q.Z:tC\u001e,'bAA\u0007S&!\u0011qCA\r\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011\u0011CA\n\u0013\u0011\ti\"a\b\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG*!\u0011qCA\r\u0011\u001d\t\u0019C\u0003a\u0001\u0003K\ta\u0001^8qS\u000e\u001c\b#B:\u0002(\u0005-\u0012bAA\u0015i\n\u00191+\u001a;\u0011\t\u00055\u0012Q\u0007\b\u0005\u0003_\t\t\u0004\u0005\u0002\u0000\u007f%\u0019\u00111G \u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019d\u0010\u0005\b\u0003{Q\u0001\u0019AA \u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003'\tqA\\3uo>\u00148.\u0003\u0003\u0002J\u0005\r#\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0002CA'\u0015A\u0005\t\u0019\u0001.\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\t\u0003#R\u0001\u0013!a\u00015\u0006IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t9FK\u0002[\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Kz\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u0001\rO\u0016$\u0018\t\u001c7U_BL7m\u001d\u000b\u0005\u0003K\t\t\bC\u0004\u0002t5\u0001\r!!\u001e\u0002\u001fQ,g.\u00198u!J,g-\u001b=PaR\u0004RAPA<\u0003WI1!!\u001f@\u0005\u0019y\u0005\u000f^5p]\u0006\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\ty(!#\u0011\u000bM\f9#!!\u0011\t\u0005\r\u0015QQ\u0007\u0003\u0003'IA!a\"\u0002\u0014\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAF\u001d\u0001\u0007\u00111F\u0001\ni>\u0004\u0018n\u0019(b[\u0016\f!bZ3u)>\u0004\u0018nY%e)\u0011\t\t*a&\u0011\t\u0005\r\u00151S\u0005\u0005\u0003+\u000b\u0019B\u0001\u0003Vk&$\u0007bBAF\u001f\u0001\u0007\u00111F\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u0003k\ni\nC\u0004\u0002 B\u0001\r!!%\u0002\u000fQ|\u0007/[2JI\u0006aq-\u001a;U_BL7\rV=qKR!\u0011QUAW!\u0015q\u0014qOAT!\u0011\t\u0019)!+\n\t\u0005-\u00161\u0003\u0002\n)>\u0004\u0018n\u0019+za\u0016Dq!a#\u0012\u0001\u0004\tY#\u0001\biCN\fE.\u001b<f\u0005J|7.\u001a:\u0015\u0007i\u000b\u0019\fC\u0003_%\u0001\u0007\u0001-A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t)\t\tI\f\u0005\u0004\u0002<\u0006\u0015\u00171\u001a\b\u0005\u0003{\u000b\tMD\u0002\u0000\u0003\u007fK\u0011\u0001Q\u0005\u0004\u0003\u0007|\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\fIM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\u0019m\u0010\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011[5\u0002\u000b\u0005$W.\u001b8\n\t\u0005U\u0017q\u001a\u0002\u000f\u0005J|7.\u001a:NKR\fG-\u0019;b\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005m\u00171]As!\u0015q\u0014qOAo!\u0011\t\u0019)a8\n\t\u0005\u0005\u00181\u0003\u0002\u0005\u001d>$W\rC\u0003_)\u0001\u0007\u0001\rC\u0004\u0002>Q\u0001\r!a\u0010\u0002\u001b\u001d,GO\u0011:pW\u0016\u0014H+Y4t)\u0011\tY/!=\u0011\u000fM\fi/a\u000b\u0002,%\u0019\u0011q\u001e;\u0003\u00075\u000b\u0007\u000fC\u0003_+\u0001\u0007\u0001-A\bhKR\u0014%o\\6fe\u000e+G\u000e\\%e)\r\u0001\u0017q\u001f\u0005\u0006=Z\u0001\r\u0001Y\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0003{\fy\u0010\u0005\u0003tm\u0006u\u0007bBA\u001f/\u0001\u0007\u0011qH\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$bA!\u0002\u0003\u0016\t]\u0001#\u0002 \u0002x\t\u001d\u0001\u0003\u0002B\u0005\u0005\u001fq1A\u001fB\u0006\u0013\u0011\u0011i!!\u0007\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005#\u0011\u0019B\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t5\u0011\u0011\u0004\u0005\b\u0003\u0017C\u0002\u0019AA\u0016\u0011\u0019\u0011I\u0002\u0007a\u0001A\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!q\u0004B\u0011!\u0011q\u0014q\u000f1\t\u000f\u0005-\u0015\u00041\u0001\u0002,\u0005yAo\u001c9jG:\u000bW.Z:U_&#7\u000f\u0006\u0002\u0003(AA!\u0011\u0006B\u001a\u0003W\t\t*\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003\u0011)H/\u001b7\u000b\u0005\tE\u0012\u0001\u00026bm\u0006LA!a<\u0003,\u0005yAo\u001c9jG&#7\u000fV8OC6,7\u000f\u0006\u0002\u0003:AA!\u0011\u0006B\u001a\u0003#\u000bY#A\u0006u_BL7-\u00133J]\u001a|GC\u0001B !\u001dq$\u0011\tB\u0014\u0005sI1Aa\u0011@\u0005\u0019!V\u000f\u001d7fe\u0005I\u0011n]&3)>\u0004\u0018n\u0019\u000b\u00045\n%\u0003bBAF;\u0001\u0007\u00111\u0006\u000b\u00045\n5\u0003bBAP=\u0001\u0007\u0011\u0011S\u0001\rSN\\%+\u00194u)>\u0004\u0018n\u0019\u000b\u00045\nM\u0003bBAP?\u0001\u0007\u0011\u0011\u0013\u000b\u00045\n]\u0003bBAFA\u0001\u0007\u00111F\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u00037\u0014iFa\u0018\u0003b!9\u00111R\u0011A\u0002\u0005-\u0002B\u0002B\rC\u0001\u0007\u0001\rC\u0004\u0002>\u0005\u0002\r!a\u0010\u00029\u001d,G\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1F]\u0012\u0004x.\u001b8ugR1!q\rB5\u0005[\u0002ba]AwA\u0006u\u0007b\u0002B6E\u0001\u0007\u0011\u0011Q\u0001\u0003iBDq!!\u0010#\u0001\u0004\ty$A\bhKR\u001cuN\u001c;s_2dWM]%e+\t\u0011\u0019\bE\u0003?\u0003o\u0012)\b\u0005\u0003\u0003x\teT\"A\u001c\n\u0007\tmtG\u0001\nDC\u000eDW\rZ\"p]R\u0014x\u000e\u001c7fe&#\u0017AF4fiJ\u000bg\u000eZ8n\u00032Lg/\u001a\"s_.,'/\u00133\u0016\u0005\t}\u0011AE4fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006$bA!\"\u0003\f\n=\u0005\u0003BAB\u0005\u000fKAA!#\u0002\u0014\t91\t\\;ti\u0016\u0014\bb\u0002BGK\u0001\u0007\u00111F\u0001\nG2,8\u000f^3s\u0013\u0012Dq!!\u0010&\u0001\u0004\ty$\u0001\u0005d_:$\u0018-\u001b8t)\rQ&Q\u0013\u0005\b\u0003\u00173\u0003\u0019AA\u0016)\rQ&\u0011\u0014\u0005\b\u0005W:\u0003\u0019AAA\u0003!\u0019X\r^%nC\u001e,G\u0003\u0002BP\u0005K\u00032A\u0010BQ\u0013\r\u0011\u0019k\u0010\u0002\u0005+:LG\u000f\u0003\u0004\u0003(\"\u0002\r!Z\u0001\t]\u0016<\u0018*\\1hK\u000611m\u001c8gS\u001e$BA!,\u00034B!!\u0011\u0006BX\u0013\u0011\u0011\tLa\u000b\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u00036&\u0002\rAa.\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKB!!\u0011\u0018B_\u001b\t\u0011YL\u0003\u0003\u0003*\u0006M\u0011\u0002\u0002B`\u0005w\u0013abQ8oM&<'+Z:pkJ\u001cW-A\bnKR\fG-\u0019;b-\u0016\u00148/[8o)\t\u0011)\r\u0005\u0003\u0003H\n5WB\u0001Be\u0015\u0011\tiAa3\u000b\u0005aJ\u0017\u0002\u0002Bh\u0005\u0013\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\tM\u0016\fG/\u001e:fgR\u0011!Q\u001b\t\u0005\u0005\u000f\u00149.\u0003\u0003\u0003Z\n%'!\u0005$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fg\u0006\u0001\u0012n\u001d\"s_.,'\u000fR3he\u0006$W\r\u001a\u000b\u00045\n}\u0007\"\u00020-\u0001\u0004\u0001\u0017!G5t\u0005J|7.\u001a:D_6\u0004xN\\3oi\u0012+wM]1eK\u0012$RA\u0017Bs\u0005ODQAX\u0017A\u0002\u0001DqA!;.\u0001\u0004\u0011Y/A\u0005d_6\u0004xN\\3oiB!!Q\u001eB{\u001b\t\u0011yO\u0003\u0003\u0002R\nE(b\u0001BzS\u000691\r\\5f]R\u001c\u0018\u0002\u0002B|\u0005_\u0014qB\u0011:pW\u0016\u00148i\\7q_:,g\u000e^\u0001\u0011[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$BA!@\u0004\fA)a(a\u001e\u0003\u0000B!1\u0011AB\u0004\u001b\t\u0019\u0019AC\u0002\u0004\u0006]\nA\u0001\\5oW&!1\u0011BB\u0002\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dqa!\u0004/\u0001\u0004\tY#A\u0003u_BL7-\u0001\fmS:\\7i\\8sI&t\u0017\r^8s\u000b:\f'\r\\3e\u0003E9W\r\u001e)beRLG/[8o\u0013:4wn\u001d\u000b\u0003\u0007+\u0001Ba\u001d<\u0003\b\u0005!B-Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN$Baa\u0007\u0004$A!1QDB\u0010\u001b\t\tI\"\u0003\u0003\u0004\"\u0005e!\u0001\t#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a#bi\u0006Dqa!\n2\u0001\u0004\u00199#A\u0004sKF,Xm\u001d;\u0011\t\ru1\u0011F\u0005\u0005\u0007W\tIBA\u0010EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e#bi\u0006\f\u0001\u0004Z3tGJL'-Z*de\u0006l7I]3eK:$\u0018.\u00197t)\u0011\u0019\tda\u000e\u0011\t\ru11G\u0005\u0005\u0007k\tIB\u0001\u0015EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0004&I\u0002\ra!\u000f\u0011\t\ru11H\u0005\u0005\u0007{\tIBA\u0014EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;ECR\f\u0017\u0001K4fiR{\u0007/[2NKR\fG-\u0019;b\r>\u0014H)Z:de&\u0014W\rV8qS\u000e\u0014Vm\u001d9p]N,G\u0003DB\"\u0007\u0013\u001a\tfa\u0015\u0004^\r\u0005\u0004\u0003BB\u000f\u0007\u000bJAaa\u0012\u0002\u001a\t\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0007bBA\u0012g\u0001\u000711\n\t\u0007\u0003w\u001bi%a\u000b\n\t\r=\u0013\u0011\u001a\u0002\t\u0013R,'/\u0019;pe\"9\u0011QH\u001aA\u0002\u0005}\u0002bBB+g\u0001\u00071qK\u0001\u0019i>\u0004\u0018n\u0019)beRLG/[8o'R\f'\u000f^%oI\u0016D\bC\u0002 \u0004Z\u0005-\u0002-C\u0002\u0004\\}\u0012\u0011BR;oGRLwN\\\u0019\t\r\r}3\u00071\u0001a\u0003ei\u0017\r_5nk6tU/\u001c2fe>3\u0007+\u0019:uSRLwN\\:\t\r\r\r4\u00071\u0001[\u0003iIwM\\8sKR{\u0007/[2t/&$\b.\u0012=dKB$\u0018n\u001c8t\u0001")
public class K2KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final KRaftMetadataCache kraftCache;
    private final K2MetadataCache k2Cache;
    private final boolean validateExclusivityAcrossCaches;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KRaftMetadataCache kraftCache() {
        return this.kraftCache;
    }

    public K2MetadataCache k2Cache() {
        return this.k2Cache;
    }

    public boolean validateExclusivityAcrossCaches() {
        return this.validateExclusivityAcrossCaches;
    }

    @Override
    public int brokerId() {
        return this.kraftCache().brokerId();
    }

    @Override
    public MetadataImage currentImage() {
        return this.kraftCache().currentImage();
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return (Seq)this.kraftCache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).$plus$plus(this.k2Cache().getTopicMetadata(topics, listenerName, errorUnavailableEndpoints, errorUnavailableListeners));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        return (Set)this.kraftCache().getAllTopics(tenantPrefixOpt).$plus$plus(this.k2Cache().getAllTopics(tenantPrefixOpt));
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return (Set)this.kraftCache().getTopicPartitions(topicName).$plus$plus(this.k2Cache().getTopicPartitions(topicName));
    }

    @Override
    public Uuid getTopicId(String topicName) {
        Uuid id = this.k2Cache().getTopicId(topicName);
        if (id.equals((Object)Uuid.ZERO_UUID)) {
            return this.kraftCache().getTopicId(topicName);
        }
        return id;
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return this.kraftCache().getTopicName(topicId).orElse((Function0 & Serializable)() -> this.k2Cache().getTopicName(topicId));
    }

    @Override
    public Option<TopicType> getTopicType(String topicName) {
        return this.kraftCache().getTopicType(topicName).orElse((Function0 & Serializable)() -> this.k2Cache().getTopicType(topicName));
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.kraftCache().hasAliveBroker(brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.kraftCache().getAliveBrokers();
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNode(brokerId, listenerName);
    }

    @Override
    public Map<String, String> getBrokerTags(int brokerId) {
        return this.kraftCache().getBrokerTags(brokerId);
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this.kraftCache().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return this.kraftCache().getAliveBrokerNodes(listenerName);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return this.kraftCache().getPartitionInfo(topicName, partitionId).orElse((Function0 & Serializable)() -> this.k2Cache().getPartitionInfo(topicName, partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return this.kraftCache().numPartitions(topicName).orElse((Function0 & Serializable)() -> this.k2Cache().numPartitions(topicName));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        int combinedSize = this.kraftCache().topicNamesToIds().size() + this.k2Cache().topicNamesToIds().size();
        HashMap<String, Uuid> cache = new HashMap<String, Uuid>(combinedSize);
        cache.putAll(this.kraftCache().topicNamesToIds());
        cache.putAll(this.k2Cache().topicNamesToIds());
        return cache;
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        int combinedSize = this.kraftCache().topicIdsToNames().size() + this.k2Cache().topicIdsToNames().size();
        HashMap<Uuid, String> cache = new HashMap<Uuid, String>(combinedSize);
        cache.putAll(this.kraftCache().topicIdsToNames());
        cache.putAll(this.k2Cache().topicIdsToNames());
        return cache;
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        return new Tuple2(this.topicNamesToIds(), this.topicIdsToNames());
    }

    public boolean isK2Topic(String topicName) {
        boolean found = this.k2Cache().topicNamesToIds().containsKey(topicName);
        if (this.validateExclusivityAcrossCaches() && found && this.kraftCache().topicNamesToIds().containsKey(topicName)) {
            throw new IllegalStateException(new StringBuilder(50).append("Topic ").append(topicName).append(" found in both kraft and k2 metadata caches.").toString());
        }
        return found;
    }

    public boolean isK2Topic(Uuid topicId) {
        boolean found = this.k2Cache().topicIdsToNames().containsKey(topicId);
        if (this.validateExclusivityAcrossCaches() && found && this.kraftCache().topicIdsToNames().containsKey(topicId)) {
            throw new IllegalStateException(new StringBuilder(50).append("Topic ").append(topicId).append(" found in both kraft and k2 metadata caches.").toString());
        }
        return found;
    }

    public boolean isKRaftTopic(Uuid topicId) {
        return this.kraftCache().topicIdsToNames().containsKey(topicId);
    }

    public boolean isKRaftTopic(String topicName) {
        return this.kraftCache().topicNamesToIds().containsKey(topicName);
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> option = this.getPartitionInfo(topicName, partitionId);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((Some)option).value();
            return this.kraftCache().getAliveBrokerNode(state.leader(), listenerName);
        }
        throw new MatchError(option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> option = this.getPartitionInfo(tp.topic(), tp.partition());
        if (None$.MODULE$.equals(option)) {
            return (Map)Map$.MODULE$.empty();
        }
        if (option instanceof Some) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((Some)option).value();
            return ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)r -> new Tuple2(r, this.kraftCache().getAliveBrokerNode(Predef$.MODULE$.Integer2int(r), listenerName)))).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)K2KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$2(x0$1)))).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Integer r = (Integer)x0$2._1();
                    Option nodeOpt = (Option)x0$2._2();
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(r)), nodeOpt.get());
                }
                throw new MatchError(null);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        throw new MatchError(option);
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.kraftCache().getControllerId();
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.kraftCache().getRandomAliveBrokerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        return this.kraftCache().getClusterMetadata(clusterId, listenerName);
    }

    @Override
    public boolean contains(String topicName) {
        return this.kraftCache().contains(topicName) || this.k2Cache().contains(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.kraftCache().contains(tp) || this.k2Cache().contains(tp);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this.kraftCache().setImage(newImage);
        this.k2Cache().setImage(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this.kraftCache().config(configResource);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.kraftCache().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        return this.kraftCache().features();
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return this.kraftCache().isBrokerDegraded(brokerId);
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return this.kraftCache().isBrokerComponentDegraded(brokerId, component);
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        if (this.isK2Topic(topic)) {
            throw new UnsupportedOperationException("K2 topics are not supported for mirroring yet.");
        }
        return this.kraftCache().mirrorTopicState(topic);
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    @Override
    public Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfos() {
        return (Seq)this.kraftCache().getPartitionInfos().$plus$plus(this.k2Cache().getPartitionInfos());
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this.kraftCache().describeClientQuotas(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this.kraftCache().describeScramCredentials(request);
    }

    @Override
    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        throw new UnsupportedOperationException("DescribeTopicPartitionsResponse is not currently implemented for K2 as no clients currently implement it yet.");
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Option)x0$1._2()).isDefined();
        }
        throw new MatchError(null);
    }

    public K2KRaftMetadataCache(KRaftMetadataCache kraftCache, K2MetadataCache k2Cache) {
        this.kraftCache = kraftCache;
        this.k2Cache = k2Cache;
        this.validateExclusivityAcrossCaches = true;
        if (kraftCache.brokerId() != k2Cache.brokerId()) {
            throw new IllegalStateException(new StringBuilder(54).append("Mismatch in kraftCache.brokerId=").append(kraftCache.brokerId()).append(" and k2Cache.brokerId=").append(k2Cache.brokerId()).toString());
        }
        this.logIdent_$eq(new StringBuilder(42).append("[K2KRaftMetadataCache brokerId=").append(kraftCache).append(".brokerId] ").toString());
    }
}

