/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0011}a\u0001\u0002\u001e<\u0001\tC\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001f\")1\u000b\u0001C\u0001)\"9q\u000b\u0001a\u0001\n\u0013A\u0006b\u00023\u0001\u0001\u0004%I!\u001a\u0005\u0007W\u0002\u0001\u000b\u0015B-\t\u000bA\u0004A\u0011B9\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!a;\u0001\t\u0013\ti\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!I!q\u0006\u0001\u0012\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0005\u000f\u0002\u0011\u0013!C\u0001\u0005cAqA!\u0013\u0001\t\u0003\u0012Y\u0005C\u0004\u0003T\u0001!\tE!\u0016\t\u000f\t]\u0004\u0001\"\u0011\u0003z!9!Q\u0011\u0001\u0005B\t\u001d\u0005b\u0002BI\u0001\u0011\u0005#1\u0013\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u00119\u000b\u0001C!\u0005SCqA!,\u0001\t\u0003\u0011y\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\te\u0006\u0001\"\u0011\u0003<\"9!\u0011\u0018\u0001\u0005\n\t=\u0007b\u0002Bj\u0001\u0011\u0005#Q\u001b\u0005\b\u00057\u0004A\u0011\tBo\u0011\u001d\u00119\u000f\u0001C!\u0005SDqA!<\u0001\t\u0003\u0012y\u000fC\u0004\u0003v\u0002!\tEa>\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!91Q\u0003\u0001\u0005B\r]\u0001bBB\u000f\u0001\u0011\u00053q\u0004\u0005\b\u0007K\u0001A\u0011IB\u0014\u0011\u001d\u0019Y\u0003\u0001C!\u0007[Aqa!\r\u0001\t\u0003\u001a\u0019\u0004C\u0004\u0004<\u0001!\te!\u0010\t\u000f\r\u001d\u0003\u0001\"\u0011\u0004J!91Q\u000b\u0001\u0005B\r]\u0003bBB-\u0001\u0011%11\f\u0005\b\u0007?\u0002A\u0011AB1\u0011\u001d\u0019i\u0007\u0001C!\u0007_Bqa! \u0001\t\u0003\u001ay\bC\u0004\u0004~\u0001!\tea!\t\u000f\r\u001d\u0005\u0001\"\u0011\u0004\n\"91q\u0012\u0001\u0005B\rE\u0005bBBT\u0001\u0011\u00053\u0011\u0016\u0005\b\u0007w\u0003A\u0011IB_\u0011\u001d\u0019i\r\u0001C!\u0007\u001fDqa!8\u0001\t\u0003\u001ay\u000eC\u0004\u0004h\u0002!\te!;\t\u000f\r5\b\u0001\"\u0011\u0004p\"9AQ\u0001\u0001\u0005B\u0011\u001d\u0001b\u0002C\u000e\u0001\u0011\u0005CQ\u0004\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002={\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002?\u007f\u000511/\u001a:wKJT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)[U\"A\u001e\n\u00051[$aF&SC\u001a$\u0018*\\1hK6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003!\u0011'o\\6fe&#W#A(\u0011\u0005\u0011\u0003\u0016BA)F\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\na\u0001P5oSRtDCA+W!\tQ\u0005\u0001C\u0003N\u0007\u0001\u0007q*A\u0007`GV\u0014(/\u001a8u\u00136\fw-Z\u000b\u00023B\u0011!LY\u0007\u00027*\u0011A,X\u0001\u0006S6\fw-\u001a\u0006\u0003\u0001zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111m\u0017\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002#}\u001bWO\u001d:f]RLU.Y4f?\u0012*\u0017\u000f\u0006\u0002gSB\u0011AiZ\u0005\u0003Q\u0016\u0013A!\u00168ji\"9!.BA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005qqlY;se\u0016tG/S7bO\u0016\u0004\u0003F\u0001\u0004n!\t!e.\u0003\u0002p\u000b\nAao\u001c7bi&dW-\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\u0012B]A\u0001\u0003\u0007\ti!!\t\u0011\u0007MD(0D\u0001u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014A\u0001T5tiB\u00111P`\u0007\u0002y*\u0011QP^\u0001\u0005Y\u0006tw-\u0003\u0002\u0000y\n9\u0011J\u001c;fO\u0016\u0014\b\"\u0002/\b\u0001\u0004I\u0006bBA\u0003\u000f\u0001\u0007\u0011qA\u0001\bEJ|7.\u001a:t!\u0011!\u0015\u0011B(\n\u0007\u0005-QIA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u0010\u001d\u0001\r!!\u0005\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u00059a.\u001a;x_J\\'bAA\u000e;\u000611m\\7n_:LA!a\b\u0002\u0016\taA*[:uK:,'OT1nK\"9\u00111E\u0004A\u0002\u0005\u0015\u0012A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bc\u0001#\u0002(%\u0019\u0011\u0011F#\u0003\u000f\t{w\u000e\\3b]\u0006a1-\u001e:sK:$\u0018*\\1hKR\t\u0011,\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0003g\t9(!\u001f\u0002\u000e\u0006=\u00151\u0013\t\u0006\t\u0006U\u0012\u0011H\u0005\u0004\u0003o)%AB(qi&|g\u000e\u0005\u0004\u0002<\u0005-\u0013\u0011\u000b\b\u0005\u0003{\t9E\u0004\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%Q\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K1!!\u0013F\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0014\u0002P\tA\u0011\n^3sCR|'OC\u0002\u0002J\u0015\u0003B!a\u0015\u0002r9!\u0011QKA6\u001d\u0011\t9&a\u001a\u000f\t\u0005e\u0013Q\r\b\u0005\u00037\n\u0019G\u0004\u0003\u0002^\u0005\u0005d\u0002BA \u0003?J\u0011!Y\u0005\u0003?\u0002L!\u0001\u00110\n\u0007\u0005mQ,\u0003\u0003\u0002j\u0005e\u0011aB7fgN\fw-Z\u0005\u0005\u0003[\ny'\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003S\nI\"\u0003\u0003\u0002t\u0005U$!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!!\u001c\u0002p!)A,\u0003a\u00013\"9\u00111P\u0005A\u0002\u0005u\u0014!\u0003;pa&\u001cg*Y7f!\u0011\ty(a\"\u000f\t\u0005\u0005\u00151\u0011\t\u0004\u0003\u007f)\u0015bAAC\u000b\u00061\u0001K]3eK\u001aLA!!#\u0002\f\n11\u000b\u001e:j]\u001eT1!!\"F\u0011\u001d\ty!\u0003a\u0001\u0003#Aq!!%\n\u0001\u0004\t)#A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bbBAK\u0013\u0001\u0007\u0011QE\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\u0017hKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$pe\u0012+7o\u0019:jE\u0016$v\u000e]5d%\u0016\u001c\bo\u001c8tKRa\u00111TA[\u0003o\u000bI,a/\u0002@B1A)!(\u0002\">K1!a(F\u0005\u0019!V\u000f\u001d7feA)A)!\u000e\u0002$B1\u00111HAS\u0003OK1!_A(!\u0011\tI+a,\u000f\t\u0005U\u00131V\u0005\u0005\u0003[\u000by'A\u0012EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019)beRLG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005E\u00161\u0017\u0002)\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003[\u000by\u0007C\u0003]\u0015\u0001\u0007\u0011\fC\u0004\u0002|)\u0001\r!! \t\u000f\u0005=!\u00021\u0001\u0002\u0012!1\u0011Q\u0018\u0006A\u0002=\u000b!b\u001d;beRLe\u000eZ3y\u0011\u0019\t\tM\u0003a\u0001\u001f\u0006AQ.\u0019=D_VtG/\u0001\nhKR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001cHc\u0002:\u0002H\u0006%\u0017q\u001b\u0005\u00069.\u0001\r!\u0017\u0005\b\u0003\u0017\\\u0001\u0019AAg\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002P\u0006MWBAAi\u0015\taT,\u0003\u0003\u0002V\u0006E'!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003\u001fY\u0001\u0019AA\t\u0003AI7OU3qY&\u001c\u0017m\u00144gY&tW\r\u0006\u0005\u0002&\u0005u\u0017q\\Aq\u0011\u001d\tY\r\u0004a\u0001\u0003\u001bDq!a\u0004\r\u0001\u0004\t\t\u0002C\u0004\u0002d2\u0001\r!!:\u0002\r\t\u0014xn[3s!\u0011\ty-a:\n\t\u0005%\u0018\u0011\u001b\u0002\u0013\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g.A\u000bjgJ+\u0007\u000f\\5dC&swJ\u001a4mS:,G)\u001b:\u0015\r\u0005\u0015\u0012q^Ay\u0011\u001d\t\u0019/\u0004a\u0001\u0003KDq!a3\u000e\u0001\u0004\ti-\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiRA\u0011q\u001fB\u0001\u0005\u0007\u00119\u0001E\u0003E\u0003k\tI\u0010\u0005\u0003\u0002|\u0006uXBAA\r\u0013\u0011\ty0!\u0007\u0003\t9{G-\u001a\u0005\u00069:\u0001\r!\u0017\u0005\u0007\u0005\u000bq\u0001\u0019A(\u0002\u0005%$\u0007bBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"B!\u0004\u0003 \t%\"1\u0006B\u0017!\u0019\u0011yA!\u0006\u0003\u001a5\u0011!\u0011\u0003\u0006\u0004\u0005')\u0015AC2pY2,7\r^5p]&!!q\u0003B\t\u0005\r\u0019V-\u001d\t\u0005\u0003'\u0012Y\"\u0003\u0003\u0003\u001e\u0005U$!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0005\b\u0005Cy\u0001\u0019\u0001B\u0012\u0003\u0019!x\u000e]5dgB1!q\u0002B\u0013\u0003{JAAa\n\u0003\u0012\t\u00191+\u001a;\t\u000f\u0005=q\u00021\u0001\u0002\u0012!I\u0011\u0011S\b\u0011\u0002\u0003\u0007\u0011Q\u0005\u0005\n\u0003+{\u0001\u0013!a\u0001\u0003K\t!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"Aa\r+\t\u0005\u0015\"QG\u0016\u0003\u0005o\u0001BA!\u000f\u0003D5\u0011!1\b\u0006\u0005\u0005{\u0011y$A\u0005v]\u000eDWmY6fI*\u0019!\u0011I#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003F\tm\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq-\u001a;BY2$v\u000e]5dgR!!1\u0005B'\u0011\u001d\u0011yE\u0005a\u0001\u0005#\nq\u0002^3oC:$\bK]3gSb|\u0005\u000f\u001e\t\u0006\t\u0006U\u0012QP\u0001)O\u0016$Hk\u001c9jG6+G/\u00193bi\u00064uN\u001d#fg\u000e\u0014\u0018NY3U_BL7MU3ta>t7/\u001a\u000b\r\u0005/\u0012yFa\u0019\u0003f\t=$1\u000f\t\u0005\u00053\u0012Y&\u0004\u0002\u0002p%!!QLA8\u0005\r\"Um]2sS\n,Gk\u001c9jGB\u000b'\u000f^5uS>t7OU3ta>t7/\u001a#bi\u0006DqA!\t\u0014\u0001\u0004\u0011\t\u0007\u0005\u0004\u0002<\u0005-\u0013Q\u0010\u0005\b\u0003\u001f\u0019\u0002\u0019AA\t\u0011\u001d\u00119g\u0005a\u0001\u0005S\n\u0001\u0004^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0015;beRLe\u000eZ3y!\u0019!%1NA?\u001f&\u0019!QN#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0002B9'\u0001\u0007q*A\rnCbLW.^7Ok6\u0014WM](g!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B;'\u0001\u0007\u0011QE\u0001\u001bS\u001etwN]3U_BL7m],ji\",\u0005pY3qi&|gn]\u0001\u0013O\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003|\t\r\u0005C\u0002B\b\u0005K\u0011i\b\u0005\u0003\u0002|\n}\u0014\u0002\u0002BA\u00033\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002|Q\u0001\r!! \u0002\u0015\u001d,G\u000fV8qS\u000eLE\r\u0006\u0003\u0003\n\n=\u0005\u0003BA~\u0005\u0017KAA!$\u0002\u001a\t!Q+^5e\u0011\u001d\tY(\u0006a\u0001\u0003{\nAbZ3u)>\u0004\u0018n\u0019(b[\u0016$BA!\u0015\u0003\u0016\"9!q\u0013\fA\u0002\t%\u0015a\u0002;pa&\u001c\u0017\nZ\u0001\rO\u0016$Hk\u001c9jGRK\b/\u001a\u000b\u0005\u0005;\u0013)\u000bE\u0003E\u0003k\u0011y\n\u0005\u0003\u0002|\n\u0005\u0016\u0002\u0002BR\u00033\u0011\u0011\u0002V8qS\u000e$\u0016\u0010]3\t\u000f\u0005mt\u00031\u0001\u0002~\u0005q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA\u0013\u0005WCQ!\u0014\rA\u0002=\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u0002&\tE\u0006\"B'\u001a\u0001\u0004y\u0015\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u0002&\t]\u0006\"B'\u001b\u0001\u0004y\u0015aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\tu\u0006CBA\u001e\u0005\u007f\u0013\u0019-\u0003\u0003\u0003B\u0006=#\u0001C%uKJ\f'\r\\3\u0011\t\t\u0015'1Z\u0007\u0003\u0005\u000fT1A!3^\u0003\u0015\tG-\\5o\u0013\u0011\u0011iMa2\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!Q\u0018Bi\u0011\u0015aF\u00041\u0001Z\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005](q\u001bBm\u0011\u0015iU\u00041\u0001P\u0011\u001d\ty!\ba\u0001\u0003#\tQbZ3u\u0005J|7.\u001a:UC\u001e\u001cH\u0003\u0002Bp\u0005K\u0004\u0002Ba\u0004\u0003b\u0006u\u0014QP\u0005\u0005\u0005G\u0014\tBA\u0002NCBDQ!\u0014\u0010A\u0002=\u000bqbZ3u\u0005J|7.\u001a:DK2d\u0017\n\u001a\u000b\u0004\u001f\n-\b\"B' \u0001\u0004y\u0015aE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016\u001cH\u0003\u0002By\u0005g\u0004bAa\u0004\u0003\u0016\u0005e\bbBA\bA\u0001\u0007\u0011\u0011C\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$bA!?\u0004\n\r-\u0001#\u0002#\u00026\tm\b\u0003\u0002B\u007f\u0007\u0007qA!!\u0016\u0003\u0000&!1\u0011AA8\u0003e)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR$\u0015\r^1\n\t\r\u00151q\u0001\u0002\u001d+B$\u0017\r^3NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\u0019\t!a\u001c\t\u000f\u0005m\u0014\u00051\u0001\u0002~!11QB\u0011A\u0002=\u000b1\u0002]1si&$\u0018n\u001c8JI\u0006\tr-\u001a;QCJ$\u0018\u000e^5p]&sgm\\:\u0015\u0005\rM\u0001C\u0002B\b\u0005+\u0011Y0A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u00073\u0019Y\u0002\u0005\u0003E\u0003ky\u0005bBA>G\u0001\u0007\u0011QP\u0001\u0010i>\u0004\u0018n\u0019(b[\u0016\u001cHk\\%egR\u00111\u0011\u0005\t\bg\u000e\r\u0012Q\u0010BE\u0013\r\u0011\u0019\u000f^\u0001\u0010i>\u0004\u0018nY%egR{g*Y7fgR\u00111\u0011\u0006\t\bg\u000e\r\"\u0011RA?\u0003-!x\u000e]5d\u0013\u0012LeNZ8\u0015\u0005\r=\u0002c\u0002#\u0002\u001e\u000e\u00052\u0011F\u0001\u001bO\u0016$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00128ea>Lg\u000e\u001e\u000b\t\u0003o\u001c)da\u000e\u0004:!9\u00111P\u0014A\u0002\u0005u\u0004BBB\u0007O\u0001\u0007q\nC\u0004\u0002\u0010\u001d\u0002\r!!\u0005\u00029\u001d,G\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1F]\u0012\u0004x.\u001b8ugR11qHB!\u0007\u000b\u0002rAa\u0004\u0003b>\u000bI\u0010C\u0004\u0004D!\u0002\rA! \u0002\u0005Q\u0004\bbBA\bQ\u0001\u0007\u0011\u0011C\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u001111\n\t\u0006\t\u0006U2Q\n\t\u0005\u0007\u001f\u001a\t&D\u0001>\u0013\r\u0019\u0019&\u0010\u0002\u0013\u0007\u0006\u001c\u0007.\u001a3D_:$(o\u001c7mKJLE-\u0001\fhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM]%e+\t\u0019I\"\u0001\u000bhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u00073\u0019i\u0006C\u0003]W\u0001\u0007\u0011,A\nhKR\fE.\u001b<f\u0005J|7.\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0004d\r-\u0004#\u0002#\u00026\r\u0015\u0004c\u0001#\u0004h%\u00191\u0011N#\u0003\t1{gn\u001a\u0005\u0006\u001b2\u0002\raT\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004r\r]41\u0010\t\u0005\u0003w\u001c\u0019(\u0003\u0003\u0004v\u0005e!aB\"mkN$XM\u001d\u0005\b\u0007sj\u0003\u0019AA?\u0003%\u0019G.^:uKJLE\rC\u0004\u0002\u00105\u0002\r!!\u0005\u0002\u0011\r|g\u000e^1j]N$B!!\n\u0004\u0002\"9\u00111\u0010\u0018A\u0002\u0005uD\u0003BA\u0013\u0007\u000bCqaa\u00110\u0001\u0004\u0011i(\u0001\u0005tKRLU.Y4f)\r171\u0012\u0005\u0007\u0007\u001b\u0003\u0004\u0019A-\u0002\u00119,w/S7bO\u0016\faaY8oM&<G\u0003BBJ\u00073\u00032a]BK\u0013\r\u00199\n\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBBNc\u0001\u00071QT\u0001\u000fG>tg-[4SKN|WO]2f!\u0011\u0019yja)\u000e\u0005\r\u0005&\u0002BBH\u00033IAa!*\u0004\"\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0004,\u000eE\u0006\u0003\u0002B-\u0007[KAaa,\u0002p\t\u0001C)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0019\u0019L\ra\u0001\u0007k\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003Z\r]\u0016\u0002BB]\u0003_\u0012q\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z9vKN$H)\u0019;b\u0003a!Wm]2sS\n,7k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0007\u007f\u001b)\r\u0005\u0003\u0003Z\r\u0005\u0017\u0002BBb\u0003_\u0012\u0001\u0006R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006Dqaa-4\u0001\u0004\u00199\r\u0005\u0003\u0003Z\r%\u0017\u0002BBf\u0003_\u0012q\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fR1uC\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0006\u0002\u0004RB!11[Bm\u001b\t\u0019)N\u0003\u0003\u0002\u001c\r]'B\u0001 ^\u0013\u0011\u0019Yn!6\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001BZ3biV\u0014Xm\u001d\u000b\u0003\u0007C\u0004Baa5\u0004d&!1Q]Bk\u0005E1\u0015N\\1mSj,GMR3biV\u0014Xm]\u0001\u0011SN\u0014%o\\6fe\u0012+wM]1eK\u0012$B!!\n\u0004l\")QJ\u000ea\u0001\u001f\u0006I\u0012n\u001d\"s_.,'oQ8na>tWM\u001c;EK\u001e\u0014\u0018\rZ3e)\u0019\t)c!=\u0004t\")Qj\u000ea\u0001\u001f\"91Q_\u001cA\u0002\r]\u0018!C2p[B|g.\u001a8u!\u0011\u0019I\u0010\"\u0001\u000e\u0005\rm(\u0002\u0002Be\u0007{T1aa@^\u0003\u001d\u0019G.[3oiNLA\u0001b\u0001\u0004|\ny!I]8lKJ\u001cu.\u001c9p]\u0016tG/\u0001\tnSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKR!A\u0011\u0002C\f!\u0015!\u0015Q\u0007C\u0006!\u0011!i\u0001b\u0005\u000e\u0005\u0011=!b\u0001C\t{\u0005!A.\u001b8l\u0013\u0011!)\u0002b\u0004\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9A\u0011\u0004\u001dA\u0002\u0005u\u0014!\u0002;pa&\u001c\u0017A\u00067j].\u001cun\u001c:eS:\fGo\u001c:F]\u0006\u0014G.\u001a3\u0016\u0005\u0005\u0015\u0002")
public class KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    @Override
    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            if (((Object)BoxesRunTime.boxToByte((byte)topic.topicType())).equals(BoxesRunTime.boxToByte((byte)TopicType.VIRTUAL.id()))) {
                int n;
                Option option2 = this.getAliveBrokers().toSeq().headOption();
                if (None$.MODULE$.equals(option2)) {
                    n = -1;
                } else if (option2 instanceof Some) {
                    n = ((BrokerMetadata)((Some)option2).value()).id;
                } else {
                    throw new MatchError((Object)option2);
                }
                int virtualTopicLeaderId = n;
                return Option$.MODULE$.apply((Object)package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetadataResponseData.MetadataResponsePartition[]{new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setLeaderId(virtualTopicLeaderId).setLeaderEpoch(-1).setReplicaNodes(Collections.emptyList()).setObservers(Collections.emptyList()).setIsrNodes(Collections.emptyList()).setOfflineReplicas(Collections.emptyList())})));
            }
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1 & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt((Object)partitionId)));
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> {
            TopicImage topicImage = image.topics().getTopic(topic);
            return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)topicImage.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava()).setTopicType(topicImage.topicType());
        }));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (None$.MODULE$.equals(tenantPrefixOpt)) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (tenantPrefixOpt instanceof Some) {
            String tenantName = (String)((Some)tenantPrefixOpt).value();
            return CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(tenantPrefixOpt);
    }

    @Override
    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> topics.foreach((Function1 & Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$5 -> x$5.name());
    }

    @Override
    public Option<TopicType> getTopicType(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Option$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return Option$.MODULE$.apply((Object)TopicType.forId((byte)topic.topicType()));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))));
    }

    @Override
    public Map<String, String> getBrokerTags(int brokerId) {
        return (Map)Map$.MODULE$.empty();
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable)x$13 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$13.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas)).setObservers(Replicas.toList((int[])partition.observers))));
    }

    @Override
    public Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfos() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().topics().topicsByName().values()).asScala().flatMap((Function1 & Serializable)img -> (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(img.partitions().keySet()).asScala().map((Function1 & Serializable)partitionId -> (UpdateMetadataRequestData.UpdateMetadataPartitionState)this.getPartitionInfo(img.name(), Predef$.MODULE$.Integer2int(partitionId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getPartitionInfos$3(p)))).toSeq();
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), KRaftMetadataCache.node$1(value.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, (PartitionRegistration)value, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        return new FinalizedFeatures(image.features().metadataVersion(), image.features().finalizedVersions(), image.highestOffsetAndEpoch().offset(), true);
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        TopicImage topicImage = this._currentImage().topics().getTopic(topic);
        if (topicImage == null) {
            return None$.MODULE$;
        }
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())).map((Function1 & Serializable)state -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)state));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = (PartitionRegistration)topic$1.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
        if (partitionRegistration != null) {
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.isr, listenerName$3, false);
            java.util.List<Integer> filteredObservers = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.observers, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration.leader, listenerName$3);
            if (None$.MODULE$.equals(maybeLeader)) {
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            if (maybeLeader instanceof Some) {
                Node leader = (Node)((Some)maybeLeader).value();
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            throw new MatchError(maybeLeader);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("The partition ").append(partitionId).append(" does not exist for ").append(topicName$2).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionInfos$3(UpdateMetadataRequestData.UpdateMetadataPartitionState p) {
        return p != null;
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        topic.partitions().values().forEach(partition -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
            BrokerRegistration broker = image$7.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$10.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            return !(brokerComponent != null ? !brokerComponent.equals(component$1) : component$1 != null);
        });
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
    }
}

