/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.SegmentDeleteComplete;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;

public class TierSegmentDeleteComplete
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    private final SegmentDeleteComplete metadata;

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<kafka.tier.state.OffsetAndEpoch> stateOffsetAndEpoch) {
        FlatBufferBuilder builder = new FlatBufferBuilder(64).forceDefaults(true);
        SegmentDeleteComplete.startSegmentDeleteComplete((FlatBufferBuilder)builder);
        SegmentDeleteComplete.addVersion((FlatBufferBuilder)builder, (byte)1);
        SegmentDeleteComplete.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpoch);
        stateOffsetAndEpoch.ifPresent(offsetAndEpoch -> {
            int offsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)offsetAndEpoch.offset(), (int)offsetAndEpoch.epoch().orElse(-1));
            SegmentDeleteComplete.addStateOffsetAndEpoch((FlatBufferBuilder)builder, (int)offsetAndEpochId);
        });
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)objectId.getMostSignificantBits(), (long)objectId.getLeastSignificantBits());
        SegmentDeleteComplete.addObjectId((FlatBufferBuilder)builder, (int)objectIdOffset);
        int entryId = SegmentDeleteComplete.endSegmentDeleteComplete((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentDeleteComplete.getRootAsSegmentDeleteComplete((ByteBuffer)builder.dataBuffer());
    }

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, SegmentDeleteComplete metadata, long timestamp) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
        this.timestamp = timestamp;
    }

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset, long timestamp) {
        this(topicIdPartition, tierEpoch, objectId, Optional.of(stateOffset));
        this.timestamp = timestamp;
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentDeleteComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE;
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentDeleteComplete(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ")";
    }
}

