/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.utils.Throttler;

public final class ThrottledSegmentUpload
extends TierSegmentUpload<File> {
    private final Optional<Throttler> throttlerOpt;

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<File> producerStateSnapshotOpt, Optional<ByteBuffer> txnIdxOpt, Optional<ByteBuffer> epochStateOpt, Optional<Throttler> throttlerOpt) {
        super(objectMetadata, segment, offsetIdx, timestampIdx, producerStateSnapshotOpt, txnIdxOpt, epochStateOpt);
        this.throttlerOpt = throttlerOpt;
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, ByteBuffer txnIdx) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.empty(), Optional.empty());
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, ByteBuffer txnIdx, ByteBuffer epochState) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.ofNullable(epochState), Optional.empty());
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, ByteBuffer txnIdx, ByteBuffer epochState, Throttler throttler) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.ofNullable(epochState), Optional.ofNullable(throttler));
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<Throttler> throttlerOpt) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.empty(), Optional.empty(), Optional.empty(), throttlerOpt);
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, Optional<Throttler> throttlerOpt) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.empty(), Optional.empty(), throttlerOpt);
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, ByteBuffer txnIdx, Optional<Throttler> throttlerOpt) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.empty(), throttlerOpt);
    }

    public ThrottledSegmentUpload(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, File producerStateSnapshot, ByteBuffer txnIdx, ByteBuffer epochState, Optional<Throttler> throttlerOpt) {
        this(objectMetadata, segment, offsetIdx, timestampIdx, Optional.ofNullable(producerStateSnapshot), Optional.ofNullable(txnIdx), Optional.ofNullable(epochState), throttlerOpt);
    }

    public static ThrottledSegmentUpload onlyWithTxnIdxOpt(ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<ByteBuffer> txnIdxOpt) {
        return new ThrottledSegmentUpload(objectMetadata, segment, offsetIdx, timestampIdx, Optional.empty(), txnIdxOpt, Optional.empty(), Optional.empty());
    }

    @Override
    public Optional<Throttler> throttlerOpt() {
        return this.throttlerOpt;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ThrottledSegmentUpload that = (ThrottledSegmentUpload)obj;
        return Objects.equals(super.objectMetadata(), that.objectMetadata()) && Objects.equals(super.segment(), that.segment()) && Objects.equals(super.offsetIdx(), that.offsetIdx()) && Objects.equals(super.timestampIdx(), that.timestampIdx()) && Objects.equals(super.producerStateSnapshotOpt(), that.producerStateSnapshotOpt()) && Objects.equals(super.txnIdxOpt(), that.txnIdxOpt()) && Objects.equals(super.epochStateOpt(), that.epochStateOpt()) && Objects.equals(this.throttlerOpt, that.throttlerOpt);
    }

    public int hashCode() {
        return Objects.hash(super.objectMetadata(), super.segment(), super.offsetIdx(), super.timestampIdx(), super.producerStateSnapshotOpt(), super.txnIdxOpt(), super.epochStateOpt(), this.throttlerOpt);
    }

    public String toString() {
        return "ThrottledSegmentUpload[objectMetadata=" + super.objectMetadata() + ", segment=" + super.segment() + ", offsetIdx=" + super.offsetIdx() + ", timestampIdx=" + super.timestampIdx() + ", producerStateSnapshotOpt=" + super.producerStateSnapshotOpt() + ", txnIdxOpt=" + super.txnIdxOpt() + ", epochStateOpt=" + super.epochStateOpt() + ", throttlerOpt=" + this.throttlerOpt + ']';
    }
}

