/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.resource.DiskIOManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.tasks.config.SnapshotTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig$;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.HeartbeatingShutdownableThread;
import kafka.utils.Logging;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rUc\u0001\u0002%J\u0001AC\u0001\u0002\u0019\u0001\u0003\u0002\u0004%\t!\u0019\u0005\tO\u0002\u0011\t\u0019!C\u0001Q\"A\u0011\u000f\u0001B\u0001B\u0003&!\r\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003x\u0011!Q\bA!A!\u0002\u0013Y\b\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\t9\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002&!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\u000e\u0001\u0005R\u0005-\u0004\"CAB\u0001\t\u0007I\u0011BAC\u0011!\t)\n\u0001Q\u0001\n\u0005\u001d\u0005\"CAL\u0001\u0001\u0007I\u0011BAM\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002(\u0002\u0001\u000b\u0015BAN\u0011%\tI\u000b\u0001a\u0001\n\u0013\tI\nC\u0005\u0002,\u0002\u0001\r\u0011\"\u0003\u0002.\"A\u0011\u0011\u0017\u0001!B\u0013\tY\nC\u0005\u00024\u0002\u0011\r\u0011\"\u0003\u00026\"A\u00111\u0019\u0001!\u0002\u0013\t9\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011Q\u001c\u0001!\u0002\u0013\tI\rC\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002b\"A\u00111\u001f\u0001!\u0002\u0013\t\u0019\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002x\"I!\u0011\u0001\u0001A\u0002\u0013%!1\u0001\u0005\t\u0005\u000f\u0001\u0001\u0015)\u0003\u0002z\"Q!\u0011\u0002\u0001C\u0002\u0013\u00051*a2\t\u0011\t-\u0001\u0001)A\u0005\u0003\u0013D!B!\u0004\u0001\u0005\u0004%\taSAd\u0011!\u0011y\u0001\u0001Q\u0001\n\u0005%\u0007\"\u0003B\t\u0001\t\u0007I\u0011\u0002B\n\u0011!\u0011y\u0002\u0001Q\u0001\n\tU\u0001\"\u0003B\u0011\u0001\t\u0007I\u0011\u0002B\u0012\u0011!\u0011\t\u0004\u0001Q\u0001\n\t\u0015\u0002\"\u0003B\u001a\u0001\t\u0007I\u0011\u0002B\u001b\u0011!\u0011\u0019\u0005\u0001Q\u0001\n\t]\u0002B\u0003B#\u0001\t\u0007I\u0011A&\u0003H!A!q\u000b\u0001!\u0002\u0013\u0011I\u0005\u0003\u0006\u0003Z\u0001\u0011\r\u0011\"\u0001L\u00057B\u0001Ba\u001b\u0001A\u0003%!Q\f\u0005\n\u0005[\u0002!\u0019!C\u0005\u0005_B\u0001Ba\"\u0001A\u0003%!\u0011\u000f\u0005\n\u0005/\u0003!\u0019!C\u0005\u00053C\u0001B!)\u0001A\u0003%!1\u0014\u0005\n\u0005G\u0003!\u0019!C\u0005\u0005KC\u0001B!0\u0001A\u0003%!q\u0015\u0005\b\u0005\u007f\u0003A\u0011\tBa\u0011\u001d\u0011\u0019\r\u0001C\u0001\u0005\u0003DqA!2\u0001\t\u0003\u0011\t\rC\u0004\u0003H\u0002!\tE!1\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!1\u001b\u0001\u0005\u0002\tU\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0005\b\u0005W\u0004A\u0011\tBw\u0011\u001d\u00119\u0010\u0001C!\u0005sDqa!\u0002\u0001\t\u0003\u001a9\u0001\u0003\u0005\u0004\u0006\u0001!\taSB\b\u000f\u001d\u0019)\"\u0013E\u0001\u0007/1a\u0001S%\t\u0002\re\u0001bBA)}\u0011\u00051\u0011\u0005\u0005\n\u0007Gq$\u0019!C\u0003\u0007KA\u0001b!\f?A\u000351q\u0005\u0005\n\u0007_q$\u0019!C\u0003\u0007KA\u0001b!\r?A\u000351q\u0005\u0005\n\u0007gq$\u0019!C\u0001\u0005[D\u0001b!\u000e?A\u0003%!q\u001e\u0005\n\u0007oq\u0014\u0013!C\u0001\u0007sA\u0011ba\u0014?#\u0003%\ta!\u0015\u0003\u0013QKWM\u001d+bg.\u001c(B\u0001&L\u0003\u0015!\u0018m]6t\u0015\taU*\u0001\u0003uS\u0016\u0014(\"\u0001(\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!U,[!\t\u0011V+D\u0001T\u0015\t!V*A\u0003vi&d7/\u0003\u0002W'\nq\u0002*Z1si\n,\u0017\r^5oONCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\t\u0003%bK!!W*\u0003\u000f1{wmZ5oOB\u00111LX\u0007\u00029*\u0011Q,T\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}c&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-\u0001\u0004d_:4\u0017nZ\u000b\u0002EB\u00111-Z\u0007\u0002I*\u0011\u0001-S\u0005\u0003M\u0012\u0014q\u0002V5feR\u000b7o[:D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fHCA5p!\tQW.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u0011)f.\u001b;\t\u000fA\u0014\u0011\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA!\u00121a\u001d\t\u0003URL!!^6\u0003\u0011Y|G.\u0019;jY\u0016\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\\q&\u0011\u0011\u0010\u0018\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005qlX\"A&\n\u0005y\\%A\u0005+jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peB\u0019A0a\u0001\n\u0007\u0005\u00151J\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\u0018!\u0005;jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010-\u000bQ\u0001^8qS\u000eLA!a\u0005\u0002\u000e\t\tB+[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;Y\u0015!B:u_J,\u0017\u0002BA\u0011\u00037\u0011q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0005i&lW\r\u0005\u0003\u0002(\u0005eRBAA\u0015\u0015\r!\u00161\u0006\u0006\u0005\u0003[\ty#\u0001\u0004d_6lwN\u001c\u0006\u0004\u001d\u0006E\"\u0002BA\u001a\u0003k\ta!\u00199bG\",'BAA\u001c\u0003\ry'oZ\u0005\u0005\u0003w\tIC\u0001\u0003US6,\u0017\u0001\u00053jg.Lu*T1oC\u001e,'o\u00149u!\u0015Q\u0017\u0011IA#\u0013\r\t\u0019e\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013]\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA(\u0003\u0013\u0012Q\u0002R5tW&{U*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\n\u0002V\u0005e\u00131LA/\u0003?\n\t'a\u0019\u0002f\u0005\u001d\u0004cAA,\u00015\t\u0011\nC\u0003a\u0017\u0001\u0007!\rC\u0003w\u0017\u0001\u0007q\u000fC\u0003{\u0017\u0001\u00071\u0010\u0003\u0004\u0000\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0011\u001d\t)b\u0003a\u0001\u0003/A\u0011\"a\t\f!\u0003\u0005\r!!\n\t\u0013\u0005u2\u0002%AA\u0002\u0005}\u0012A\u00037pO\u001e,'OT1nKV\u0011\u0011Q\u000e\t\u0005\u0003_\niH\u0004\u0003\u0002r\u0005e\u0004cAA:W6\u0011\u0011Q\u000f\u0006\u0004\u0003oz\u0015A\u0002\u001fs_>$h(C\u0002\u0002|-\fa\u0001\u0015:fI\u00164\u0017\u0002BA@\u0003\u0003\u0013aa\u0015;sS:<'bAA>W\u0006aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000b\t*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u001diW\r\u001e:jGNT1!XA\u0018\u0013\u0011\t\u0019*a#\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0013Y\u0006\u001cH\u000fT1h!JLg\u000e\u001e+j[\u0016l5/\u0006\u0002\u0002\u001cB\u0019!.!(\n\u0007\u0005}5N\u0001\u0003M_:<\u0017A\u00067bgRd\u0015m\u001a)sS:$H+[7f\u001bN|F%Z9\u0015\u0007%\f)\u000b\u0003\u0005q!\u0005\u0005\t\u0019AAN\u0003Ma\u0017m\u001d;MC\u001e\u0004&/\u001b8u)&lW-T:!\u0003\u0011b\u0017m\u001d;US\u0016\u0014H)\u001a7fi&|gn\u001d)f]\u0012LgnZ'fiJL7\rV5nK6\u001b\u0018\u0001\u000b7bgR$\u0016.\u001a:EK2,G/[8ogB+g\u000eZ5oO6+GO]5d)&lW-T:`I\u0015\fHcA5\u00020\"A\u0001oEA\u0001\u0002\u0004\tY*A\u0013mCN$H+[3s\t\u0016dW\r^5p]N\u0004VM\u001c3j]\u001elU\r\u001e:jGRKW.Z'tA\u0005\u00191\r\u001e=\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u007fk!!a/\u000b\u0007\u0005u6*A\u0004gKR\u001c\u0007.\u001a:\n\t\u0005\u0005\u00171\u0018\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\u0005GRD\b%A\fbe\u000eD\u0017N^3EK2,G/[8o\u000bb,7-\u001e;peV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\fI.\u0004\u0002\u0002N*!\u0011qZAi\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003'\f).\u0001\u0003vi&d'BAAl\u0003\u0011Q\u0017M^1\n\t\u0005m\u0017Q\u001a\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006A\u0012M]2iSZ,G)\u001a7fi&|g.\u0012=fGV$xN\u001d\u0011\u0002\u001d\rdW-\u00198feRC'/Z1egV\u0011\u00111\u001d\t\u0007\u0003K\fy/a'\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fq!\\;uC\ndWMC\u0002\u0002n.\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t0a:\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u0010G2,\u0017M\\3s)\"\u0014X-\u00193tA\u00051B/[3s\u0007>l\u0007/Y2uS>t7\t];NKR,'/\u0006\u0002\u0002zB)!.!\u0011\u0002|B\u0019!+!@\n\u0007\u0005}8KA\bUQJ,\u0017\rZ:DaVlU\r^3s\u0003i!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:\u001c\u0005/^'fi\u0016\u0014x\fJ3r)\rI'Q\u0001\u0005\tar\t\t\u00111\u0001\u0002z\u00069B/[3s\u0007>l\u0007/Y2uS>t7\t];NKR,'\u000fI\u0001\u0011G2,\u0017M\\5oO\u0016CXmY;u_J\f\u0011c\u00197fC:LgnZ#yK\u000e,Ho\u001c:!\u0003A\u0019h.\u00199tQ>$X\t_3dkR|'/A\tt]\u0006\u00048\u000f[8u\u000bb,7-\u001e;pe\u0002\n1#\u0019:dQ&4X\rR3mKRLwN\u001c)p_2,\"A!\u0006\u0011\t\t]!1D\u0007\u0003\u00053Q1!a4l\u0013\u0011\u0011iB!\u0007\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/\u0001\u000bbe\u000eD\u0017N^3EK2,G/[8o!>|G\u000eI\u0001\ri&,'/\u0011:dQ&4XM]\u000b\u0003\u0005K\u0001BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0004\u0005WI\u0015aB1sG\"Lg/Z\u0005\u0005\u0005_\u0011IC\u0001\u0007US\u0016\u0014\u0018I]2iSZ,'/A\u0007uS\u0016\u0014\u0018I]2iSZ,'\u000fI\u0001\u0014i&,'\u000fR3mKRLwN\\'b]\u0006<WM]\u000b\u0003\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{I\u0015A\u00023fY\u0016$X-\u0003\u0003\u0003B\tm\"a\u0005+jKJ$U\r\\3uS>tW*\u00198bO\u0016\u0014\u0018\u0001\u0006;jKJ$U\r\\3uS>tW*\u00198bO\u0016\u0014\b%A\u000buS\u0016\u0014Hj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\t%\u0003#\u00026\u0002B\t-\u0003\u0003\u0002B'\u0005'j!Aa\u0014\u000b\u0007\tE\u0013*\u0001\u0006d_6\u0004\u0018m\u0019;j_:LAA!\u0016\u0003P\t)B+[3s\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\u0018A\u0006;jKJdunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0011\u00027QLWM]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3s+\t\u0011i\u0006E\u0003k\u0003\u0003\u0012y\u0006\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)'S\u0001\tg:\f\u0007o\u001d5pi&!!\u0011\u000eB2\u0005m!\u0016.\u001a:NKR\fG-\u0019;b':\f\u0007o\u001d5pi6\u000bg.Y4fe\u0006aB/[3s\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_Rl\u0015M\\1hKJ\u0004\u0013A\u0004;jKJ$\u0016m]6Rk\u0016,Xm]\u000b\u0003\u0005c\u0002b!!:\u0003t\t]\u0014\u0002\u0002B;\u0003O\u0014!\u0002T5ti\n+hMZ3sa\u0011\u0011IHa!\u0011\r\u0005]#1\u0010B@\u0013\r\u0011i(\u0013\u0002\u000e)&,'\u000fV1tWF+X-^3\u0011\t\t\u0005%1\u0011\u0007\u0001\t-\u0011))LA\u0001\u0002\u0003\u0015\tA!#\u0003\u0007}#\u0013'A\buS\u0016\u0014H+Y:l#V,W/Z:!#\u0011\u0011YI!%\u0011\u0007)\u0014i)C\u0002\u0003\u0010.\u0014qAT8uQ&tw\rE\u0002k\u0005'K1A!&l\u0005\r\te._\u0001\u000eG\"\fgnZ3NC:\fw-\u001a:\u0016\u0005\tm\u0005\u0003BA,\u0005;K1Aa(J\u00055\u0019\u0005.\u00198hK6\u000bg.Y4fe\u0006q1\r[1oO\u0016l\u0015M\\1hKJ\u0004\u0013aD2zG2,G+[7f\u001b\u0016$(/[2\u0016\u0005\t\u001d\u0006\u0003\u0002BU\u0005sk!Aa+\u000b\t\t5&qV\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u000e\nE&\u0002\u0002BZ\u0005k\u000ba!_1n[\u0016\u0014(B\u0001B\\\u0003\r\u0019w.\\\u0005\u0005\u0005w\u0013YKA\u0003NKR,'/\u0001\tds\u000edW\rV5nK6+GO]5dA\u00051Am\\,pe.$\u0012![\u0001\u001c[\u0006L(-\u001a'pORKWM]!sG\"Lg/\u001a:MC\u001eLeNZ8\u000275\f\u0017PY3Va\u0012\fG/\u001a#fY\u0016$\u0018n\u001c8t!\u0016tG-\u001b8h\u0003!\u0019\b.\u001e;e_^t\u0017!E1sG\"Lg/\u001a:UCN\\\u0017+^3vKV\u0011!Q\u001a\t\u0005\u0005O\u0011y-\u0003\u0003\u0003R\n%\"!E!sG\"Lg/\u001a:UCN\\\u0017+^3vK\u0006\u00192m\\7qC\u000e$\u0018n\u001c8UCN\\\u0017+^3vKV\u0011!q\u001b\t\u0006U\u0006\u0005#\u0011\u001c\t\u0005\u0005\u001b\u0012Y.\u0003\u0003\u0003^\n=#aE\"p[B\f7\r^5p]R\u000b7o[)vKV,\u0017!G7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u)\u0006\u001c8.U;fk\u0016,\"Aa9\u0011\u000b)\f\tE!:\u0011\t\t\u0005$q]\u0005\u0005\u0005S\u0014\u0019GA\rNKR\fG-\u0019;b':\f\u0007o\u001d5piR\u000b7o[)vKV,\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005_\u0004bA!=\u0003t\u00065TBAAv\u0013\u0011\u0011)0a;\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0019\u0011Na?\t\u000f\tu(\b1\u0001\u0003\u0000\u0006Ia.Z<D_:4\u0017n\u001a\t\u00047\u000e\u0005\u0011bAB\u00029\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\u000b%\u001cIa!\u0004\t\u000f\r-1\b1\u0001\u0003\u0000\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005{\\\u0004\u0019\u0001B\u0000)\u0015I7\u0011CB\n\u0011\u0019\u0019Y\u0001\u0010a\u0001E\"1!Q \u001fA\u0002\t\f\u0011\u0002V5feR\u000b7o[:\u0011\u0007\u0005]chE\u0002?\u00077\u00012A[B\u000f\u0013\r\u0019yb\u001b\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r]\u0011a\u0005)F%&{E)S\"`\u0019>;u\fT!H?6\u001bVCAB\u0014!\rQ7\u0011F\u0005\u0004\u0007WY'aA%oi\u0006!\u0002+\u0012*J\u001f\u0012K5i\u0018'P\u000f~c\u0015iR0N'\u0002\n\u0011\u0005U#S\u0013>#\u0015jQ0E\u000b2+E+S(O?F+V)V#`\u001b\u0016#&+S\"`\u001bN\u000b!\u0005U#S\u0013>#\u0015jQ0E\u000b2+E+S(O?F+V)V#`\u001b\u0016#&+S\"`\u001bN\u0003\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"aa\u000f+\t\u0005\u00152QH\u0016\u0003\u0007\u007f\u0001Ba!\u0011\u0004L5\u001111\t\u0006\u0005\u0007\u000b\u001a9%A\u0005v]\u000eDWmY6fI*\u00191\u0011J6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004N\r\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"aa\u0015+\t\u0005}2Q\b")
public class TierTasks
extends HeartbeatingShutdownableThread
implements Logging,
BrokerReconfigurable {
    private volatile TierTasksConfig config;
    private final TierTopicAppender tierTopicAppender;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private long lastLagPrintTimeMs;
    private long lastTierDeletionsPendingMetricTimeMs;
    private final CancellationContext ctx;
    private final ExecutorService archiveDeletionExecutor;
    private final ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads;
    private Option<ThreadsCpuMeter> kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    private final ExecutorService cleaningExecutor;
    private final ExecutorService snapshotExecutor;
    private final ExecutionContextExecutor archiveDeletionPool;
    private final TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver;
    private final TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager;
    private final Option<TierLogCleanerManager> tierLogCleanerManager;
    private final Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager;
    private final ListBuffer<TierTaskQueue<?>> tierTaskQueues;
    private final ChangeManager changeManager;
    private final Meter cycleTimeMetric;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<DiskIOManager> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    public static Set<String> ReconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    public static int PERIODIC_DELETION_QUEUE_METRIC_MS() {
        return TierTasks$.MODULE$.PERIODIC_DELETION_QUEUE_METRIC_MS();
    }

    public static int PERIODIC_LOG_LAG_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    public void config_$eq(TierTasksConfig x$1) {
        this.config = x$1;
    }

    @Override
    public String loggerName() {
        return TierTasks.class.getName();
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private long lastLagPrintTimeMs() {
        return this.lastLagPrintTimeMs;
    }

    private void lastLagPrintTimeMs_$eq(long x$1) {
        this.lastLagPrintTimeMs = x$1;
    }

    private long lastTierDeletionsPendingMetricTimeMs() {
        return this.lastTierDeletionsPendingMetricTimeMs;
    }

    private void lastTierDeletionsPendingMetricTimeMs_$eq(long x$1) {
        this.lastTierDeletionsPendingMetricTimeMs = x$1;
    }

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ExecutorService archiveDeletionExecutor() {
        return this.archiveDeletionExecutor;
    }

    public ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads() {
        return this.kafka$tier$tasks$TierTasks$$cleanerThreads;
    }

    private Option<ThreadsCpuMeter> tierCompactionCpuMeter() {
        return this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    }

    public void kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = x$1;
    }

    public ExecutorService cleaningExecutor() {
        return this.cleaningExecutor;
    }

    public ExecutorService snapshotExecutor() {
        return this.snapshotExecutor;
    }

    private ExecutionContextExecutor archiveDeletionPool() {
        return this.archiveDeletionPool;
    }

    public TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver;
    }

    public TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager() {
        return this.kafka$tier$tasks$TierTasks$$tierDeletionManager;
    }

    public Option<TierLogCleanerManager> tierLogCleanerManager() {
        return this.tierLogCleanerManager;
    }

    public Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager() {
        return this.tierMetadataSnapshotManager;
    }

    private ListBuffer<TierTaskQueue<?>> tierTaskQueues() {
        return this.tierTaskQueues;
    }

    private ChangeManager changeManager() {
        return this.changeManager;
    }

    private Meter cycleTimeMetric() {
        return this.cycleTimeMetric;
    }

    public void doWork() {
        if (!this.tierTopicAppender.isReadyForWrites()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "TierTopicAppender is not ready. Backing off.");
            while (!this.tierTopicAppender.isReadyForWrites() && this.isRunning()) {
                this.pause(this.config().updateIntervalMs(), TimeUnit.MILLISECONDS);
            }
            if (!this.isRunning()) {
                return;
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> "TierTopicAppender is ready.");
        }
        this.cycleTimeMetric().mark();
        this.changeManager().process();
        this.tierLogCleanerManager().map((Function1 & Serializable)x$8 -> x$8.doWork());
        this.kafka$tier$tasks$TierTasks$$tierArchiver().doWork();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().doWork();
        this.tierMetadataSnapshotManager().map((Function1 & Serializable)x$9 -> x$9.doWork());
        this.maybeLogTierArchiverLagInfo();
        this.maybeUpdateDeletionsPending();
        if (this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().taskCount() == 0 && this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().taskCount() == 0 && BoxesRunTime.unboxToInt((Object)this.tierLogCleanerManager().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)TierTasks.$anonfun$doWork$5(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == 0 && BoxesRunTime.unboxToInt((Object)this.tierMetadataSnapshotManager().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)TierTasks.$anonfun$doWork$7(x$11))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) == 0) {
            this.changeManager().processAtLeastOne();
            return;
        }
        this.time.sleep((long)this.config().updateIntervalMs());
    }

    public void maybeLogTierArchiverLagInfo() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastLagPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS()) {
            this.kafka$tier$tasks$TierTasks$$tierArchiver().logPartitionLagInfo(currentTime);
            this.lastLagPrintTimeMs_$eq(currentTime);
            return;
        }
    }

    public void maybeUpdateDeletionsPending() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastTierDeletionsPendingMetricTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_DELETION_QUEUE_METRIC_MS()) {
            this.kafka$tier$tasks$TierTasks$$tierDeletionManager().recordDeletionsPendingMetric();
            this.lastTierDeletionsPendingMetricTimeMs_$eq(currentTime);
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.initiateShutdown();
        this.ctx().cancel();
        this.changeManager().close();
        this.kafka$tier$tasks$TierTasks$$tierArchiver().shutdown();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().shutdown();
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.tierMetadataSnapshotManager().foreach((Function1 & Serializable)x$13 -> {
            x$13.shutdown();
            return BoxedUnit.UNIT;
        });
        this.archiveDeletionExecutor().shutdown();
        this.archiveDeletionExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.cleaningExecutor().shutdown();
        this.cleaningExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.snapshotExecutor().shutdown();
        this.snapshotExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.awaitShutdown();
    }

    public ArchiverTaskQueue archiverTaskQueue() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue();
    }

    public Option<CompactionTaskQueue> compactionTaskQueue() {
        return this.tierLogCleanerManager().map((Function1 & Serializable)x$14 -> x$14.taskQueue());
    }

    public Option<MetadataSnapshotTaskQueue> metadataSnapshotTaskQueue() {
        return this.tierMetadataSnapshotManager().map((Function1 & Serializable)x$15 -> x$15.taskQueue());
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        if (newTierTasksConfig.numCleanerThreads() < 1) {
            throw new ConfigException("Tier cleaner threads should be at least 1");
        }
        if (newTierTasksConfig.numCleanerThreads() < this.config().numCleanerThreads() / 2) {
            throw new ConfigException(new StringBuilder(75).append("Tier cleaner threads cannot be reduced to less than half the current value ").append(this.config().numCleanerThreads()).toString());
        }
        if (newTierTasksConfig.numCleanerThreads() > this.config().numCleanerThreads() * 2) {
            throw new ConfigException(new StringBuilder(79).append("Tier cleaner threads cannot be increased to more than double the current value ").append(this.config().numCleanerThreads()).toString());
        }
        if (newTierTasksConfig.snapshotTaskConfig().exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)TierTasks.$anonfun$validateReconfiguration$1(c)))) {
            throw new ConfigException(new StringBuilder(47).append(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsRetentionDaysProp()).append(" must have a value of at least ").append(2).append(" days").toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        TierTasksConfig oldTierTasksConfig = this.config();
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        this.reconfigure(oldTierTasksConfig, newTierTasksConfig);
    }

    public void reconfigure(TierTasksConfig oldConfig, TierTasksConfig newConfig) {
        this.config_$eq(newConfig);
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$16 -> {
            x$16.updateConfig(newConfig);
            return BoxedUnit.UNIT;
        });
        if (newConfig.numCleanerThreads() != oldConfig.numCleanerThreads()) {
            ThreadPoolExecutor cleaningThreadPool = (ThreadPoolExecutor)this.cleaningExecutor();
            cleaningThreadPool.setMaximumPoolSize(newConfig.numCleanerThreads());
            cleaningThreadPool.setCorePoolSize(newConfig.numCleanerThreads());
            return;
        }
    }

    public final /* synthetic */ double kafka$tier$tasks$TierTasks$$$anonfun$new$2() {
        return BoxesRunTime.unboxToDouble((Object)this.tierCompactionCpuMeter().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$new$1(TierTasks $this, TierLogCleanerManager x$1) {
        x$1.logCleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>($this){
            private final /* synthetic */ TierTasks $outer;

            public final double value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final /* synthetic */ int $anonfun$doWork$5(TierLogCleanerManager x$10) {
        return x$10.taskQueue().taskCount();
    }

    public static final /* synthetic */ int $anonfun$doWork$7(TierMetadataSnapshotManager x$11) {
        return x$11.taskQueue().taskCount();
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$1(SnapshotTasksConfig c) {
        return c.retentionDays().apply$mcI$sp() < 2;
    }

    public TierTasks(TierTasksConfig config, ReplicaManager replicaManager, TierReplicaManager tierReplicaManager, TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time, Option<DiskIOManager> diskIOManagerOpt) {
        None$ none$;
        None$ none$2;
        this.config = config;
        this.tierTopicAppender = tierTopicAppender;
        this.time = time;
        super("tier-tasks", true);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.lastLagPrintTimeMs = time.milliseconds();
        this.lastTierDeletionsPendingMetricTimeMs = time.milliseconds();
        this.ctx = CancellationContext.newContext();
        this.archiveDeletionExecutor = Executors.newFixedThreadPool(this.config().numArchiverThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(9).append("TierTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.kafka$tier$tasks$TierTasks$$cleanerThreads = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = None$.MODULE$;
        this.cleaningExecutor = Executors.newFixedThreadPool(this.config().numCleanerThreads(), new ThreadFactory(this){
            private final AtomicInteger threadNum;
            private final /* synthetic */ TierTasks $outer;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(19).append("TierCompactionTask-").append(newThreadNum).toString();
                Object var4_3 = null;
                KafkaThread thread = new KafkaThread(nonDaemon_name, r, false);
                this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().append((Object)BoxesRunTime.boxToLong((long)thread.getId()));
                this.$outer.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().toSeq())));
                return thread;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.snapshotExecutor = Executors.newFixedThreadPool(this.config().numSnapshotThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(17).append("TierSnapshotTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.archiveDeletionPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.archiveDeletionExecutor());
        this.kafka$tier$tasks$TierTasks$$tierArchiver = new TierArchiver(this.config(), replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, time, diskIOManagerOpt, (ExecutionContext)this.archiveDeletionPool());
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager = new TierDeletionManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)this.archiveDeletionPool());
        if (this.config().tierCleanerFeatureEnable()) {
            ExecutionContextExecutor cleaningPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.cleaningExecutor());
            none$2 = new Some((Object)new TierLogCleanerManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)cleaningPool));
        } else {
            none$2 = None$.MODULE$;
        }
        this.tierLogCleanerManager = none$2;
        this.tierLogCleanerManager().foreach((Function1 & Serializable)x$1 -> {
            TierTasks.$anonfun$new$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        if (this.config().snapshotTaskConfig().isDefined()) {
            ExecutionContextExecutor snapshotPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.snapshotExecutor());
            none$ = new Some((Object)new TierMetadataSnapshotManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)snapshotPool));
        } else {
            none$ = None$.MODULE$;
        }
        this.tierMetadataSnapshotManager = none$;
        this.tierTaskQueues = new ListBuffer();
        this.tierTaskQueues().$plus$plus$eq((IterableOnce)((IterableOps)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue(), (List)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue(), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)this.tierLogCleanerManager().map((Function1 & Serializable)x$3 -> x$3.taskQueue()))).$plus$plus((IterableOnce)this.tierMetadataSnapshotManager().map((Function1 & Serializable)x$4 -> x$4.taskQueue())));
        this.changeManager = new ChangeManager(this.ctx().subContext(), this.tierTaskQueues().toSeq(), time);
        this.metricsGroup().removeMetric("HeartbeatMs");
        this.metricsGroup().newGauge("HeartbeatMs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public synchronized long value() {
                return System.currentTimeMillis() - this.$outer.lastHeartbeatMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric("CyclesPerSec");
        this.cycleTimeMetric = this.metricsGroup().newMeter("CyclesPerSec", "tier tasks cycles per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("NumPartitionsInError");
        this.metricsGroup().newGauge("NumPartitionsInError", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount() + this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount() + BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)$anon$5.$anonfun$value$1(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$1(TierLogCleanerManager x$5) {
                return x$5.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$2()}, serializedLambda);
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringArchival");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringArchival", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringDeletion");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringDeletion", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringCompaction");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringCompaction", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)$anon$8.$anonfun$value$3(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$3(TierLogCleanerManager x$6) {
                return x$6.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$4()}, serializedLambda);
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringMetadataSnapshot");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringMetadataSnapshot", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.tierMetadataSnapshotManager().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)$anon$9.$anonfun$value$5(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$5(TierMetadataSnapshotManager x$7) {
                return x$7.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$5$adapted(kafka.tier.tasks.snapshot.TierMetadataSnapshotManager ), $anonfun$value$6()}, serializedLambda);
            }
        }, Collections.emptyMap());
        tierReplicaManager.addListener(this.changeManager());
        tierDeletedPartitionsCoordinator.registerListener(this.changeManager());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }
}

