/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.UnfreezeLogStartOffsetRawInput;
import kafka.tier.tools.common.RestoreRawOutputInfoRemoteURI;
import kafka.tier.tools.common.UnfreezeTriggerOutputRemoteURI;
import org.apache.kafka.common.TopicPartition;

public class UnfreezeLogStartOffsetRawInputRemoteURI
extends UnfreezeLogStartOffsetRawInput<RestoreRawOutputInfoRemoteURI, UnfreezeTriggerOutputRemoteURI> {
    @Override
    public List<RestoreRawOutputInfoRemoteURI> getUnfreezeLogStartOffsetTriggerInput(Path inputJsonFile) {
        if (Files.notExists(inputJsonFile, new LinkOption[0]) || !Files.isRegularFile(inputJsonFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Trigger tool's input file does not exist: " + inputJsonFile);
        }
        try {
            return RestoreRawOutputInfoRemoteURI.readJsonFromFile(inputJsonFile);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + inputJsonFile, e);
        }
    }

    @Override
    public File getFtpsForTopicPartition(RestoreRawOutputInfoRemoteURI input) {
        String topic = input.input().restoreRemoteURIInfo().getKey().topic();
        int partition = input.input().restoreRemoteURIInfo().getKey().partition();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        File directoryPath = new File(RecoveryUtils.getTempDirectoryForPartition(topicPartition));
        File[] fileNames = directoryPath.listFiles();
        File file = null;
        if (fileNames != null) {
            file = fileNames[0];
        }
        return file;
    }

    @Override
    public UnfreezeTriggerOutputRemoteURI getUnfreezeTriggerOutput(RestoreRawOutputInfoRemoteURI input, String event) {
        return new UnfreezeTriggerOutputRemoteURI(input, event);
    }

    @Override
    public void writeOutputFile(List<UnfreezeTriggerOutputRemoteURI> outputs, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        UnfreezeTriggerOutputRemoteURI.writeJsonToFile(outputs, fos);
        fos.close();
    }
}

