/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import kafka.server.KafkaConfig;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.TreeSet;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StorageTool$
implements Logging {
    public static final StorageTool$ MODULE$ = new StorageTool$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode;
        None$ message = None$.MODULE$;
        try {
            exitCode = this.execute(args);
        }
        catch (TerseFailure e) {
            exitCode = 1;
            message = new Some((Object)e.getMessage());
        }
        message.foreach((Function1 & Serializable)x$1 -> {
            System.err.println(x$1);
            return BoxedUnit.UNIT;
        });
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)message);
    }

    public int execute(String[] args) {
        Namespace namespace = this.parseArguments(args);
        String command = namespace.getString("command");
        Option config = Option$.MODULE$.apply((Object)namespace.getString("config")).flatMap((Function1 & Serializable)p -> new Some((Object)new KafkaConfig(Utils.loadProps((String)p, null))));
        switch (command == null ? 0 : command.hashCode()) {
            case -1268779017: {
                if (!"format".equals(command)) break;
                return this.runFormatCommand(namespace, (KafkaConfig)config.get());
            }
            case -745688443: {
                if (!"random-uuid".equals(command)) break;
                System.out.println(Uuid.randomUuid());
                return 0;
            }
            case 3237038: {
                if (!"info".equals(command)) break;
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                boolean selfManagedMode = this.configToSelfManagedMode((KafkaConfig)config.get());
                return this.infoCommand(System.out, selfManagedMode, directories);
            }
        }
        throw new RuntimeException(new StringBuilder(16).append("Unknown command ").append(command).toString());
    }

    public int runFormatCommand(Namespace namespace, KafkaConfig config) {
        boolean releaseVersionFlagSpecified;
        Seq<String> directories = this.configToLogDirectories(config);
        String clusterId = namespace.getString("cluster_id");
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(config.nodeId()).build();
        ArrayBuffer metadataRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        java.util.List specifiedFeatures = namespace.getList("feature");
        boolean bl = releaseVersionFlagSpecified = namespace.getString("release_version") != null;
        if (releaseVersionFlagSpecified && specifiedFeatures != null) {
            throw new TerseFailure("Both --release-version and --feature were set. Only one of the two flags can be set.");
        }
        scala.collection.immutable.Map<String, Short> featureNamesAndLevelsMap = this.featureNamesAndLevels((List<String>)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)Option$.MODULE$.apply((Object)specifiedFeatures).getOrElse((Function0 & Serializable)() -> Collections.emptyList())).asScala().toList());
        MetadataVersion metadataVersion = this.getMetadataVersion(namespace, featureNamesAndLevelsMap, (Option<String>)Option$.MODULE$.apply(config.originals().get("inter.broker.protocol.version")).map((Function1 & Serializable)x$1 -> x$1.toString()));
        this.validateMetadataVersion(metadataVersion, config);
        this.generateFeatureRecords((ArrayBuffer<ApiMessageAndVersion>)metadataRecords, metadataVersion, featureNamesAndLevelsMap, (List<Features>)CollectionConverters$.MODULE$.ListHasAsScala(Features.PRODUCTION_FEATURES).asScala().toList(), Predef$.MODULE$.Boolean2boolean(config.unstableFeatureVersionsEnabled()), releaseVersionFlagSpecified);
        this.getUserScramCredentialRecords(namespace).foreach((Function1 & Serializable)userScramCredentialRecords -> {
            StorageTool$.$anonfun$runFormatCommand$3(metadataVersion, metadataRecords, userScramCredentialRecords);
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = this.buildBootstrapMetadata(metadataVersion, (Option<ArrayBuffer<ApiMessageAndVersion>>)new Some((Object)metadataRecords), "format command");
        Boolean ignoreFormatted = namespace.getBoolean("ignore_formatted");
        if (!this.configToSelfManagedMode(config)) {
            throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
        }
        return this.formatCommand(System.out, directories, metaProperties, bootstrapMetadata, metadataVersion, Predef$.MODULE$.Boolean2boolean(ignoreFormatted));
    }

    private void validateMetadataVersion(MetadataVersion metadataVersion, KafkaConfig config) {
        if (!metadataVersion.isKRaftSupported()) {
            throw new TerseFailure(new StringBuilder(57).append("Must specify a valid KRaft metadata.version of at least ").append(MetadataVersion.IBP_3_0_IV0).append(".").toString());
        }
        if (!metadataVersion.isProduction()) {
            if (Predef$.MODULE$.Boolean2boolean(config.unstableFeatureVersionsEnabled())) {
                System.out.println(new StringBuilder(48).append("WARNING: using pre-production metadata.version ").append(metadataVersion).append(".").toString());
            } else {
                throw new TerseFailure(new StringBuilder(58).append("The metadata.version ").append(metadataVersion).append(" is not ready for production use yet.").toString());
            }
        }
        try {
            config.validateWithMetadataVersion(metadataVersion);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new TerseFailure(new StringBuilder(44).append("Invalid configuration for metadata version: ").append(e.getMessage()).toString());
        }
    }

    public void generateFeatureRecords(ArrayBuffer<ApiMessageAndVersion> metadataRecords, MetadataVersion metadataVersion, scala.collection.immutable.Map<String, Short> specifiedFeatures, List<Features> allFeatures, boolean unstableFeatureVersionsEnabled, boolean releaseVersionSpecified) {
        MetadataVersion metadataVersionForDefault = releaseVersionSpecified ? metadataVersion : MetadataVersion.LATEST_PRODUCTION;
        ArrayBuffer allNonZeroFeaturesAndLevels = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        allFeatures.foreach((Function1 & Serializable)feature -> {
            Short level = (Short)specifiedFeatures.getOrElse((Object)feature.featureName(), (Function0 & Serializable)() -> Predef$.MODULE$.short2Short(feature.defaultValue(metadataVersionForDefault)));
            if (!BoxesRunTime.equalsNumObject((Number)level, (Object)BoxesRunTime.boxToInteger((int)0))) {
                return allNonZeroFeaturesAndLevels.append((Object)feature.fromFeatureLevel(Predef$.MODULE$.Short2short(level), unstableFeatureVersionsEnabled));
            }
            return BoxedUnit.UNIT;
        });
        Map featuresMap = Features.featureImplsToMap((java.util.List)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)allNonZeroFeaturesAndLevels).asJava());
        featuresMap.put("confluent.metadata.version", Predef$.MODULE$.short2Short(metadataVersion.confluentFeatureLevel()));
        try {
            allNonZeroFeaturesAndLevels.foreach((Function1 & Serializable)feature -> {
                Features.validateVersion((FeatureVersion)feature, (Map)featuresMap);
                return (ArrayBuffer)metadataRecords.append((Object)new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(feature.featureName()).setFeatureLevel(feature.featureLevel()), (short)0));
            });
            return;
        }
        catch (Throwable e) {
            throw new TerseFailure(e.getMessage());
        }
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser2 = ArgumentParsers.newArgumentParser((String)"kafka-storage", (boolean)true, (String)"-", (String)"@").description("The Kafka storage tool.");
        Subparsers subparsers = parser2.addSubparsers().dest("command");
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        subparsers.addParser("random-uuid").help("Print a random UUID.");
        new .colon.colon((Object)infoParser, (List)new .colon.colon((Object)formatParser, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)parser -> parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).help("The Kafka configuration file to use."));
        formatParser.addArgument(new String[]{"--cluster-id", "-t"}).action((ArgumentAction)Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument(new String[]{"--add-scram", "-S"}).action((ArgumentAction)Arguments.append()).help(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A SCRAM_CREDENTIAL to add to the __cluster_metadata log e.g.\n              |'SCRAM-SHA-256=[name=alice,password=alice-secret]'\n              |'SCRAM-SHA-512=[name=alice,iterations=8192,salt=\"N3E=\",saltedpassword=\"YCE=\"]'")));
        formatParser.addArgument(new String[]{"--ignore-formatted", "-g"}).action((ArgumentAction)Arguments.storeTrue());
        formatParser.addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help(new StringBuilder(97).append("A KRaft release version to use for the initial metadata.version. The minimum is ").append(MetadataVersion.IBP_3_0_IV0).append(", the default is ").append(MetadataVersion.LATEST_PRODUCTION).toString());
        formatParser.addArgument(new String[]{"--feature", "-f"}).help("A feature upgrade we should perform, in feature=level format. For example: `confluent.metadata.version=105`.").action((ArgumentAction)Arguments.append());
        return parser2.parseArgsOrFail(args);
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet directories = new TreeSet((Ordering)Ordering.String$.MODULE$);
        directories.$plus$plus$eq(config.logDirs());
        Option$.MODULE$.apply((Object)config.metadataLogDir()).foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return directories.toSeq();
    }

    private boolean configToSelfManagedMode(KafkaConfig config) {
        return config.processRoles().nonEmpty();
    }

    public MetadataVersion getMetadataVersion(Namespace namespace, scala.collection.immutable.Map<String, Short> featureNamesAndLevelsMap, Option<String> defaultVersionString) {
        MetadataVersion metadataVersion;
        if (defaultVersionString instanceof Some) {
            metadataVersion = MetadataVersion.fromVersionString((String)((String)((Some)defaultVersionString).value()));
        } else if (None$.MODULE$.equals(defaultVersionString)) {
            metadataVersion = MetadataVersion.LATEST_PRODUCTION;
        } else {
            throw new MatchError(defaultVersionString);
        }
        MetadataVersion defaultValue = metadataVersion;
        if (featureNamesAndLevelsMap.get((Object)"metadata.version").isDefined()) {
            throw new IllegalArgumentException("'metadata.version' can not be used to set metadata version. Use 'confluent.metadata.version' instead.");
        }
        Option releaseVersionTag = Option$.MODULE$.apply((Object)namespace.getString("release_version"));
        Option featureTag = featureNamesAndLevelsMap.get((Object)"confluent.metadata.version");
        Tuple2 tuple2 = new Tuple2((Object)releaseVersionTag, (Object)featureTag);
        if (releaseVersionTag instanceof Some && featureTag instanceof Some) {
            throw new IllegalArgumentException("Both --release_version and --feature were set. Only one of the two flags can be set.");
        }
        if (releaseVersionTag instanceof Some) {
            String version = (String)((Some)releaseVersionTag).value();
            if (None$.MODULE$.equals(featureTag)) {
                return MetadataVersion.fromVersionString((String)version);
            }
        }
        if (None$.MODULE$.equals(releaseVersionTag) && featureTag instanceof Some) {
            Short level = (Short)((Some)featureTag).value();
            return MetadataVersion.fromConfluentFeatureLevel((short)Predef$.MODULE$.Short2short(level));
        }
        if (None$.MODULE$.equals(releaseVersionTag) && None$.MODULE$.equals(featureTag)) {
            return defaultValue;
        }
        throw new MatchError((Object)tuple2);
    }

    private UserScramCredentialRecord getUserScramCredentialRecord(String mechanism, String config) {
        scala.collection.immutable.Map argMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])config.substring(1, config.length() - 1).split(",")), (Function1 & Serializable)x$2 -> x$2.split("=(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)args -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)args[0]), (Object)args[1].replaceAll("\"", "")), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
        String name = StorageTool$.getName$1(argMap);
        byte[] salt = StorageTool$.getSalt$1(argMap, scramMechanism);
        int iterations = StorageTool$.getIterations$1(argMap, scramMechanism);
        byte[] saltedPassword = StorageTool$.getSaltedPassword$1(argMap, scramMechanism, salt, iterations);
        try {
            ScramFormatter formatter = new ScramFormatter(scramMechanism);
            return new UserScramCredentialRecord().setName(name).setMechanism(scramMechanism.type()).setSalt(salt).setStoredKey(formatter.storedKey(formatter.clientKey(saltedPassword))).setServerKey(formatter.serverKey(saltedPassword)).setIterations(iterations);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(54).append("Error attempting to create UserScramCredentialRecord: ").append(e.getMessage()).toString());
        }
    }

    public Option<ArrayBuffer<UserScramCredentialRecord>> getUserScramCredentialRecords(Namespace namespace) {
        if (namespace.getList("add_scram") != null) {
            List listofAddConfig = CollectionConverters$.MODULE$.ListHasAsScala(namespace.getList("add_scram")).asScala().toList();
            ArrayBuffer userScramCredentialRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            listofAddConfig.foreach((Function1 & Serializable)singleAddConfig -> {
                String[] nameValueRecord = singleAddConfig.split("\\s+")[0].split("=", 2);
                String string = nameValueRecord[0];
                switch (string == null ? 0 : string.hashCode()) {
                    case -1875511693: {
                        if (!"SCRAM-SHA-256".equals(string)) break;
                        return (ArrayBuffer)userScramCredentialRecords.append((Object)MODULE$.getUserScramCredentialRecord(nameValueRecord[0], nameValueRecord[1]));
                    }
                    case -1875508938: {
                        if (!"SCRAM-SHA-512".equals(string)) break;
                        return (ArrayBuffer)userScramCredentialRecords.append((Object)MODULE$.getUserScramCredentialRecord(nameValueRecord[0], nameValueRecord[1]));
                    }
                }
                throw new TerseFailure(new StringBuilder(42).append("The add-scram mechanism ").append(nameValueRecord[0]).append(" is not supported.").toString());
            });
            return new Some((Object)userScramCredentialRecords);
        }
        return None$.MODULE$;
    }

    public int infoCommand(PrintStream stream, boolean selfManagedMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef prevMetadata = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)directories.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)directory -> {
            BoxedUnit boxedUnit;
            block8: {
                Path directoryPath = Paths.get(directory, new String[0]);
                if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        return problems.$plus$eq((Object)new StringBuilder(15).append(directoryPath).append(" does not exist").toString());
                    }
                    return problems.$plus$eq((Object)new StringBuilder(19).append(directoryPath).append(" is not a directory").toString());
                }
                foundDirectories.$plus$eq((Object)((Object)directoryPath).toString());
                Path metaPath = directoryPath.resolve("meta.properties");
                if (!Files.exists(metaPath, new LinkOption[0])) {
                    return problems.$plus$eq((Object)new StringBuilder(18).append(directoryPath).append(" is not formatted.").toString());
                }
                Properties properties = PropertiesUtils.readPropertiesFile((String)((Object)metaPath).toString());
                try {
                    MetaProperties curMetadata = new MetaProperties.Builder(properties).build();
                    if (((Option)prevMetadata$1.elem).isEmpty()) {
                        prevMetadata$1.elem = new Some((Object)curMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).clusterId().equals(curMetadata.clusterId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched cluster IDs between storage directories.");
                        break block8;
                    }
                    if (!((MetaProperties)((Option)prevMetadata$1.elem).get()).nodeId().equals(curMetadata.nodeId())) {
                        boxedUnit = problems.$plus$eq((Object)"Mismatched node IDs between storage directories.");
                        break block8;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    boxedUnit = problems.$plus$eq((Object)new StringBuilder(16).append("Error loading ").append(metaPath).append(": ").append(e.getMessage()).toString());
                }
            }
            return boxedUnit;
        });
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable)prev -> {
            if (selfManagedMode) {
                if (prev.version().equals((Object)MetaPropertiesVersion.V0)) {
                    return problems.$plus$eq((Object)"The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version().equals((Object)MetaPropertiesVersion.V1)) {
                return problems.$plus$eq((Object)"The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1 & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1 & Serializable)d -> {
                stream.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("  %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public BootstrapMetadata buildBootstrapMetadata(MetadataVersion metadataVersion, Option<ArrayBuffer<ApiMessageAndVersion>> metadataOptionalArguments, String source) {
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(metadataVersion.confluentFeatureLevel()), (short)0));
        metadataOptionalArguments.foreach((Function1 & Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$3.add(record)));
            return BoxedUnit.UNIT;
        });
        return BootstrapMetadata.fromRecords(metadataRecords, (String)source, (boolean)true);
    }

    public MetaProperties buildMetadataProperties(String clusterIdStr, KafkaConfig config) {
        Uuid uuid;
        try {
            uuid = Uuid.fromString((String)clusterIdStr);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(55).append("Cluster ID string ").append(clusterIdStr).append(" ").append("does not appear to be a valid UUID: ").append(e.getMessage()).toString());
        }
        Uuid effectiveClusterId = uuid;
        if (config.nodeId() < 0) {
            throw new TerseFailure(new StringBuilder(58).append("The node.id must be set to a non-negative integer. We saw ").append(config.nodeId()).toString());
        }
        return new MetaProperties.Builder().setClusterId(effectiveClusterId.toString()).setNodeId(config.nodeId()).build();
    }

    public int formatCommand(PrintStream stream, Seq<String> directories, MetaProperties metaProperties, MetadataVersion metadataVersion, boolean ignoreFormatted) {
        BootstrapMetadata bootstrapMetadata = this.buildBootstrapMetadata(metadataVersion, (Option<ArrayBuffer<ApiMessageAndVersion>>)None$.MODULE$, "format command");
        return this.formatCommand(stream, directories, metaProperties, bootstrapMetadata, metadataVersion, ignoreFormatted);
    }

    public int formatCommand(PrintStream stream, Seq<String> directories, MetaProperties metaProperties, BootstrapMetadata bootstrapMetadata, MetadataVersion metadataVersion, boolean ignoreFormatted) {
        if (directories.isEmpty()) {
            throw new TerseFailure("No log directories found in the configuration.");
        }
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        directories.foreach((Function1 & Serializable)x$1 -> loader.addLogDir(x$1));
        MetaPropertiesEnsemble metaPropertiesEnsemble = loader.load();
        metaPropertiesEnsemble.verify(metaProperties.clusterId(), metaProperties.nodeId(), EnumSet.noneOf(MetaPropertiesEnsemble.VerificationFlag.class));
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(metaPropertiesEnsemble);
        if (!ignoreFormatted && !copier.logDirProps().isEmpty()) {
            String firstLogDir = (String)copier.logDirProps().keySet().iterator().next();
            throw new TerseFailure(new StringBuilder(107).append("Log directory ").append(firstLogDir).append(" is already formatted. ").append("Use --ignore-formatted to ignore this directory and format the others.").toString());
        }
        if (!copier.errorLogDirs().isEmpty()) {
            copier.errorLogDirs().forEach(errorLogDir -> stream.println(new StringBuilder(52).append("I/O error trying to read log directory ").append((String)errorLogDir).append(". Ignoring...").toString()));
            if (metaPropertiesEnsemble.emptyLogDirs().isEmpty() && copier.logDirProps().isEmpty()) {
                throw new TerseFailure("No available log directories to format.");
            }
        }
        if (metaPropertiesEnsemble.emptyLogDirs().isEmpty()) {
            stream.println("All of the log directories are already formatted.");
        } else {
            metaPropertiesEnsemble.emptyLogDirs().forEach(logDir2 -> {
                copier.setLogDirProps(logDir2, new MetaProperties.Builder(metaProperties).setDirectoryId(copier.generateValidDirectoryId()).build());
                copier.setPreWriteHandler((logDir, x$3, x$4) -> {
                    stream.println(new StringBuilder(35).append("Formatting ").append(logDir).append(" with metadata.version ").append(metadataVersion).append(".").toString());
                    Files.createDirectories(Paths.get(logDir, new String[0]), new FileAttribute[0]);
                    new BootstrapDirectory(logDir, Optional.empty()).writeBinaryFile(bootstrapMetadata);
                });
                copier.setWriteErrorHandler((logDir, e) -> {
                    throw new TerseFailure(new StringBuilder(43).append("Error while writing meta.properties file ").append(logDir).append(": ").append(e.getMessage()).toString());
                });
            });
            copier.writeLogDirChanges();
        }
        return 0;
    }

    private Tuple2<String, Short> parseNameAndLevel(String input) {
        int equalsIndex = input.indexOf("=");
        if (equalsIndex < 0) {
            throw new RuntimeException(new StringBuilder(57).append("Can't parse feature=level string ").append(input).append(": equals sign not found.").toString());
        }
        String name = input.substring(0, equalsIndex).trim();
        String levelString = input.substring(equalsIndex + 1).trim();
        try {
            StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(levelString));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(new StringBuilder(63).append("Can't parse feature=level string ").append(input).append(": ").append("unable to parse ").append(levelString).append(" as a short.").toString());
        }
        return new Tuple2((Object)name, (Object)Predef$.MODULE$.short2Short(StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(levelString))));
    }

    public scala.collection.immutable.Map<String, Short> featureNamesAndLevels(List<String> features) {
        return features.map((Function1 & Serializable)feature -> {
            Tuple2<String, Short> nameAndLevel = MODULE$.parseNameAndLevel((String)feature);
            return new Tuple2(nameAndLevel._1(), nameAndLevel._2());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$runFormatCommand$3(MetadataVersion metadataVersion$1, ArrayBuffer metadataRecords$1, ArrayBuffer userScramCredentialRecords) {
        if (!metadataVersion$1.isScramSupported()) {
            throw new TerseFailure(new StringBuilder(54).append("SCRAM is only supported in metadata.version ").append(MetadataVersion.IBP_3_5_IV2).append(" or later.").toString());
        }
        userScramCredentialRecords.foreach((Function1 & Serializable)record -> (ArrayBuffer)metadataRecords$1.append((Object)new ApiMessageAndVersion((ApiMessage)record, (short)0)));
    }

    private static final String getName$1(scala.collection.immutable.Map argMap) {
        if (!argMap.contains((Object)"name")) {
            throw new TerseFailure("You must supply 'name' to add-scram");
        }
        return (String)argMap.apply((Object)"name");
    }

    private static final byte[] getSalt$1(scala.collection.immutable.Map argMap, ScramMechanism scramMechanism) {
        if (argMap.contains((Object)"salt")) {
            return Base64.getDecoder().decode((String)argMap.apply((Object)"salt"));
        }
        return new ScramFormatter(scramMechanism).secureRandomBytes();
    }

    private static final int getIterations$1(scala.collection.immutable.Map argMap, ScramMechanism scramMechanism) {
        if (argMap.contains((Object)"salt")) {
            int iterations = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)argMap.apply((Object)"iterations")));
            if (iterations < scramMechanism.minIterations()) {
                throw new TerseFailure(new StringBuilder(48).append("The 'iterations' value must be >= ").append(scramMechanism.minIterations()).append(" for add-scram").toString());
            }
            if (iterations > scramMechanism.maxIterations()) {
                throw new TerseFailure(new StringBuilder(48).append("The 'iterations' value must be <= ").append(scramMechanism.maxIterations()).append(" for add-scram").toString());
            }
            return iterations;
        }
        return 4096;
    }

    private static final byte[] getSaltedPassword$1(scala.collection.immutable.Map argMap, ScramMechanism scramMechanism, byte[] salt, int iterations) {
        if (argMap.contains((Object)"password")) {
            if (argMap.contains((Object)"saltedpassword")) {
                throw new TerseFailure("You must only supply one of 'password' or 'saltedpassword' to add-scram");
            }
            return new ScramFormatter(scramMechanism).saltedPassword((String)argMap.apply((Object)"password"), salt, iterations);
        }
        if (!argMap.contains((Object)"saltedpassword")) {
            throw new TerseFailure("You must supply one of 'password' or 'saltedpassword' to add-scram");
        }
        if (!argMap.contains((Object)"salt")) {
            throw new TerseFailure("You must supply 'salt' with 'saltedpassword' to add-scram");
        }
        return Base64.getDecoder().decode((String)argMap.apply((Object)"saltedpassword"));
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, MetaProperties prev) {
        TreeMap sortedOutput = new TreeMap();
        prev.toProperties().entrySet().forEach(e -> sortedOutput.put(e.getKey().toString(), e.getValue().toString()));
        stream$1.println(new StringBuilder(16).append("Found metadata: ").append(sortedOutput).toString());
        stream$1.println("");
    }

    private StorageTool$() {
    }
}

