/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.TlsContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLConnection
implements BCSSLConnection {
    protected final TlsContext tlsContext;
    protected final ProvSSLSession session;

    ProvSSLConnection(TlsContext tlsContext, ProvSSLSession session) {
        this.tlsContext = tlsContext;
        this.session = session;
    }

    public String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.tlsContext.getSecurityParametersConnection());
    }

    public byte[] getChannelBinding(String channelBinding) {
        if (channelBinding.equals("tls-server-end-point")) {
            return this.tlsContext.exportChannelBinding(0);
        }
        if (channelBinding.equals("tls-unique")) {
            return this.tlsContext.exportChannelBinding(1);
        }
        throw new UnsupportedOperationException();
    }

    public ProvSSLSession getSession() {
        return this.session;
    }
}

