/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RangeAssignmentProto;
import java.util.Objects;

public class K2Node {
    private final String id;

    public static K2RangeAssignmentProto.NodeId toNodeId(K2Node node) {
        return K2RangeAssignmentProto.NodeId.newBuilder().setId(node.nodeId()).build();
    }

    public static K2Node fromNodeId(K2RangeAssignmentProto.NodeId nodeId) {
        return new K2Node(nodeId.getId());
    }

    public K2Node(Integer id) {
        this(Integer.toString(id));
    }

    public K2Node(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K2Node k2Node = (K2Node)o;
        return Objects.equals(this.id, k2Node.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String nodeId() {
        return this.id;
    }

    public String toString() {
        return "K2Node{nodeId='" + this.id + '\'' + '}';
    }

    public static enum NodeStatus {
        OFFLINE,
        ONLINE;

    }
}

