/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RequestDeterminationBasedOnContextOnly;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.RequestFeatureFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K2RequestDeterminationBasedOnRequestDetails
implements RequestFeatureFilter {
    private static final Logger logger = LoggerFactory.getLogger(K2RequestDeterminationBasedOnRequestDetails.class);
    public static final String HEALTHCHECK_TOPIC_K2_PREFIX = "_k2_";
    private final K2RequestDeterminationBasedOnContextOnly principalDetermination = new K2RequestDeterminationBasedOnContextOnly();
    private final Function<Uuid, Optional<String>> topicIdToNameMapper;
    private final Function<String, Optional<TopicType>> topicNameToTypeMapper;

    public K2RequestDeterminationBasedOnRequestDetails(Function<Uuid, Optional<String>> topicIdToNameMapper, Function<String, Optional<TopicType>> topicNameToTypeMapper) {
        this.topicIdToNameMapper = Objects.requireNonNull(topicIdToNameMapper);
        this.topicNameToTypeMapper = Objects.requireNonNull(topicNameToTypeMapper);
    }

    public boolean appliesTo(AbstractRequest request, RequestContext context, Optional<Supplier<Set<String>>> sessionTopicNames) {
        boolean appliesToPrincipal = this.principalDetermination.appliesTo(request, context, sessionTopicNames);
        if (appliesToPrincipal) {
            if (logger.isTraceEnabled()) {
                logger.trace(request.getClass().getSimpleName() + " determined to be a K2 request via context: " + context);
            }
            return true;
        }
        if (request instanceof CreateTopicsRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            RequestTypeForFurtherIntrospection requestTypeForFurtherIntrospection = K2RequestDeterminationBasedOnContextOnly.isHealthcheckTenant(context) ? RequestTypeForFurtherIntrospection.HEALTHCHECK_TENANT : RequestTypeForFurtherIntrospection.INTERNAL_LISTENER;
            return this.appliesToCreateTopics((CreateTopicsRequest)request, requestTypeForFurtherIntrospection);
        }
        if (request instanceof DeleteTopicsRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToDeleteTopics((DeleteTopicsRequest)request);
        }
        if (request instanceof CreatePartitionsRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToCreatePartitions((CreatePartitionsRequest)request);
        }
        if (request instanceof ProduceRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToProduce((ProduceRequest)request);
        }
        if (request instanceof FetchRequest) {
            return this.appliesToFetch((FetchRequest)request, sessionTopicNames);
        }
        if (request instanceof OffsetsForLeaderEpochRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToOffsetsForLeaderEpoch((OffsetsForLeaderEpochRequest)request);
        }
        if (request instanceof ListOffsetsRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToListOffsets((ListOffsetsRequest)request);
        }
        if (request instanceof DeleteRecordsRequest) {
            K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
            return this.appliesToDeleteRecords((DeleteRecordsRequest)request);
        }
        if (request instanceof MetadataRequest) {
            return true;
        }
        logger.warn("Request class not covered in " + this.getClass().getSimpleName() + ": " + request.getClass());
        return false;
    }

    private static void confirmNoTopicNameOverrides(AbstractRequest request, Optional<Supplier<Set<String>>> sessionTopicNames) {
        if (sessionTopicNames.isPresent()) {
            throw new IllegalArgumentException("Cannot set session topic names for " + request.getClass().getSimpleName());
        }
    }

    private boolean appliesToCreateTopics(CreateTopicsRequest request, RequestTypeForFurtherIntrospection requestTypeForFurtherIntrospection) {
        Stream<String> topicNames = request.data().topics().stream().map(CreateTopicsRequestData.CreatableTopic::name);
        return K2RequestDeterminationBasedOnRequestDetails.appliesToNewTopicNames((AbstractRequest)request, topicNames, requestTypeForFurtherIntrospection, "create topics");
    }

    private boolean appliesToDeleteTopics(DeleteTopicsRequest request) {
        Stream<Optional<String>> topics = request.topics().stream().map(deleteTopicState -> {
            if (deleteTopicState.name() != null) {
                return Optional.of(deleteTopicState.name());
            }
            return this.topicIdToNameMapper.apply(deleteTopicState.topicId());
        });
        return this.appliesToExistingTopicNames((AbstractRequest)request, K2RequestDeterminationBasedOnRequestDetails.filterPresent(topics), "delete topics");
    }

    private boolean appliesToCreatePartitions(CreatePartitionsRequest request) {
        Stream<String> topicNames = request.data().topics().stream().map(CreatePartitionsRequestData.CreatePartitionsTopic::name);
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "create partitions");
    }

    private boolean appliesToProduce(ProduceRequest request) {
        Stream<String> topicNames = request.data().topicData().stream().map(ProduceRequestData.TopicProduceData::name);
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "produce");
    }

    private boolean appliesToFetch(FetchRequest request, Optional<Supplier<Set<String>>> sessionTopicNames) {
        if (!sessionTopicNames.isPresent()) {
            throw new IllegalArgumentException("Must set session topic names for " + request.getClass().getSimpleName());
        }
        Stream<String> topicNames = sessionTopicNames.get().get().stream();
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "fetch");
    }

    private boolean appliesToOffsetsForLeaderEpoch(OffsetsForLeaderEpochRequest request) {
        Stream<String> topicNames = request.data().topics().stream().map(OffsetForLeaderEpochRequestData.OffsetForLeaderTopic::topic);
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "offsets for leader epoch");
    }

    private boolean appliesToListOffsets(ListOffsetsRequest request) {
        Stream<String> topicNames = request.data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name);
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "list offsets");
    }

    private boolean appliesToDeleteRecords(DeleteRecordsRequest request) {
        Stream<String> topicNames = request.data().topics().stream().map(DeleteRecordsRequestData.DeleteRecordsTopic::name);
        return this.appliesToExistingTopicNames((AbstractRequest)request, topicNames, "list offsets");
    }

    private static Boolean isK2HealthcheckTopic(String hcTenantTopicName) {
        return hcTenantTopicName.contains(HEALTHCHECK_TOPIC_K2_PREFIX);
    }

    private static Boolean isK2InternalTopic(String internalTopicName) {
        return !internalTopicName.startsWith("_");
    }

    private static Stream<String> filterPresent(Stream<Optional<String>> optionalStream) {
        return optionalStream.filter(Optional::isPresent).map(Optional::get);
    }

    private boolean appliesToExistingTopicNames(AbstractRequest request, Stream<String> topicNames, String requestDescription) {
        Map<String, Optional<TopicType>> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, this.topicNameToTypeMapper));
        Map<String, Boolean> topicToK2Applicability = topicDeterminations.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> TopicType.FREIGHT == ((Optional)entry.getValue()).get()));
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicToK2Applicability, requestDescription);
        if (logger.isTraceEnabled()) {
            logger.trace(requestDescription + " request determined to " + (isK2Request ? "be " : "not be ") + "a K2 request: topicDeterminations=" + Utils.mkString(topicDeterminations, (String)"(", (String)")", (String)"=", (String)",") + "; request=" + request);
        }
        return isK2Request;
    }

    private static boolean appliesToNewTopicNames(AbstractRequest request, Stream<String> topicNames, RequestTypeForFurtherIntrospection requestTypeForFurtherIntrospection, String requestDescription) {
        boolean hcTenant = requestTypeForFurtherIntrospection == RequestTypeForFurtherIntrospection.HEALTHCHECK_TENANT;
        Map<String, Boolean> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, topicName -> hcTenant ? K2RequestDeterminationBasedOnRequestDetails.isK2HealthcheckTopic(topicName) : K2RequestDeterminationBasedOnRequestDetails.isK2InternalTopic(topicName)));
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicDeterminations, requestDescription);
        if (logger.isTraceEnabled()) {
            logger.trace(requestDescription + " request determined to " + (isK2Request ? "be " : "not be ") + "a K2 request: topicDeterminations=" + Utils.mkString(topicDeterminations, (String)"(", (String)")", (String)"=", (String)",") + "; request=" + request);
        }
        return isK2Request;
    }

    private static boolean validate(Map<String, Boolean> topicNamesToDeterminations, String requestDescription) {
        HashSet<Boolean> uniqueTopicDeterminations = new HashSet<Boolean>(topicNamesToDeterminations.values());
        if (uniqueTopicDeterminations.size() > 1) {
            throw new InvalidRequestException("Existence of both K2 and Non-K2 topics in the same " + requestDescription + " request is not supported: " + Utils.mkString(topicNamesToDeterminations, (String)"", (String)"", (String)"=", (String)","));
        }
        return uniqueTopicDeterminations.isEmpty() || (Boolean)uniqueTopicDeterminations.iterator().next() != false;
    }

    private static enum RequestTypeForFurtherIntrospection {
        INTERNAL_LISTENER,
        HEALTHCHECK_TENANT;

    }
}

