/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.JsonIterator;
import io.confluent.kafka.tools.recovery.MetadataLogIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryState;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.utils.FileLock;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;

final class ApplyCommand {
    static final String COMMAND = "apply";
    private static final String METADATA_LOG_DIR_OPTION = "--metadata-log-dir";
    private static final String STARTING_OFFSET_OPTION = "--start-offset";
    private static final String ENDING_OFFSET_OPTION = "--ending-offset";
    private static final String JSON_OPTION = "--json";

    ApplyCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparser applyCmd = subparsers.addParser(COMMAND).help("update the recovery state by applying new metadata records");
        MutuallyExclusiveGroup sourceOptions = applyCmd.addMutuallyExclusiveGroup("apply origin options").required(true);
        sourceOptions.addArgument(new String[]{METADATA_LOG_DIR_OPTION}).dest(METADATA_LOG_DIR_OPTION).metavar(new String[]{"<path-metadata-dir>"}).help("apply records directly from the cluster metadata log dir <path-metadata-dir>. must specify --start-offset").type((ArgumentType)Arguments.fileType().verifyCanRead());
        sourceOptions.addArgument(new String[]{JSON_OPTION}).dest(JSON_OPTION).metavar(new String[]{"<json-objects>"}).help("provide an array of <json-objects> as records to apply. pass '-' to use stdin").type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead());
        applyCmd.addArgument(new String[]{STARTING_OFFSET_OPTION}).dest(STARTING_OFFSET_OPTION).metavar(new String[]{"<offset>"}).choices((ArgumentChoice)Arguments.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).help("apply will start after applying <offset> (inclusive)").type(Long.class);
        applyCmd.addArgument(new String[]{ENDING_OFFSET_OPTION}).dest(ENDING_OFFSET_OPTION).metavar(new String[]{"<offset>"}).choices((ArgumentChoice)Arguments.range((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE))).help("apply will stop before applying <offset> (exclusive)").type(Long.class);
        MetadataRecoveryUtils.addRecoveryDirectoryOption(applyCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int execute(Namespace namespace) {
        long endingOffset;
        if (namespace.get(JSON_OPTION) != null && (namespace.getLong(STARTING_OFFSET_OPTION) != null || namespace.getLong(ENDING_OFFSET_OPTION) != null)) {
            throw new IllegalArgumentException(String.format("Offset specifications are invalid for %s option", JSON_OPTION));
        }
        if (namespace.getString(METADATA_LOG_DIR_OPTION) != null && namespace.getLong(STARTING_OFFSET_OPTION) == null) {
            throw new IllegalArgumentException(String.format("Must specify %s with %s option", STARTING_OFFSET_OPTION, METADATA_LOG_DIR_OPTION));
        }
        long startOffset = Optional.ofNullable(namespace.getLong(STARTING_OFFSET_OPTION)).orElse(0L);
        if (startOffset >= (endingOffset = Optional.ofNullable(namespace.getLong(ENDING_OFFSET_OPTION)).orElse(Long.MAX_VALUE).longValue())) {
            throw new IllegalArgumentException(String.format("Start offset must be < ending offset: %d >= %d", startOffset, endingOffset));
        }
        Path logDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
        Optional<FileLock> lock = MetadataRecoveryUtils.maybeSetupLogDirFileLock(namespace);
        try (MetadataRecoveryPartition recoveryPartition = MetadataRecoveryPartition.open(logDir, new Metrics(), Time.SYSTEM);){
            Properties props = MetadataRecoveryUtils.loadRecoveryConfig(namespace);
            MetadataEncryptorFactory encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)props);
            MetadataRecoveryState metadataRecoveryState = new MetadataRecoveryState(recoveryPartition, encryptorFactory);
            metadataRecoveryState.load();
            try (AutoCloseableIterator<Batch<ApiMessageAndVersion>> iterator = ApplyCommand.metadataIterator(namespace, startOffset);){
                metadataRecoveryState.applyLogs(iterator, startOffset, endingOffset);
            }
        }
        finally {
            lock.ifPresent(FileLock::unlock);
        }
        return 0;
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> metadataIterator(Namespace namespace, long startOffset) {
        if (namespace.getString(METADATA_LOG_DIR_OPTION) != null) {
            Path clusterMetadataPartition = Paths.get(namespace.getString(METADATA_LOG_DIR_OPTION), new String[0]).resolve(MetadataRecoveryUtils.LOG_DIR);
            if (!Files.exists(clusterMetadataPartition, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Directory %s doesn't exist so it cannot be applied", clusterMetadataPartition));
            }
            KafkaScheduler scheduler = new KafkaScheduler(1, true, "target-dir-scheduler", false);
            KafkaMetadataLog log = KafkaMetadataLog.apply((TopicPartition)Topic.CLUSTER_METADATA_TOPIC_PARTITION, (Uuid)Uuid.METADATA_TOPIC_ID, (File)clusterMetadataPartition.toFile(), (Time)Time.SYSTEM, (Metrics)new Metrics(), (Scheduler)scheduler, (MetadataLogConfig)MetadataRecoveryPartition.metadataLogConfig(), ignore -> {}, ignore -> {});
            final MetadataLogIterator iterator = MetadataLogIterator.open((ReplicatedLog)log, startOffset);
            return new AutoCloseableIterator<Batch<ApiMessageAndVersion>>((ReplicatedLog)log, (Scheduler)scheduler){
                final /* synthetic */ ReplicatedLog val$log;
                final /* synthetic */ Scheduler val$scheduler;
                {
                    this.val$log = replicatedLog;
                    this.val$scheduler = scheduler;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Batch<ApiMessageAndVersion> next() {
                    return iterator.next();
                }

                @Override
                public void close() {
                    try {
                        iterator.close();
                        this.val$log.close();
                        this.val$scheduler.shutdown();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }
        if (namespace.getString(JSON_OPTION) != null) {
            Optional<InputStream> stream;
            Optional<Path> path;
            String jsonOption = namespace.getString(JSON_OPTION);
            if (jsonOption.equals("-")) {
                path = Optional.empty();
                stream = Optional.of(System.in);
            } else {
                path = Optional.of(Paths.get(jsonOption, new String[0]));
                stream = Optional.empty();
            }
            return new JsonIterator(path, stream);
        }
        throw new IllegalArgumentException("one 'origin' option must be specified");
    }
}

