/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class StopCellMigrationCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "stop-migration";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Deactivate cell migration");
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        try {
            admin.alterCellMigration(CellMigrationState.INACTIVE).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to stop cell migration", e.getCause());
            return;
        }
        CellsAdminCommand.printMessageAndExit(out, "Successfully stopped cell migration");
    }
}

