/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;

public abstract class BasePhysicalClusterMetadata<LCMType extends LogicalClusterMetadata>
implements MultiTenantMetadata,
Reconfigurable {
    protected static final Map<String, BasePhysicalClusterMetadata> INSTANCES = new HashMap<String, BasePhysicalClusterMetadata>();
    private static final Set<String> RECONFIGURABLE_CONFIGS = new HashSet<String>();
    protected Map<String, Object> interBrokerClientConfig;
    protected double linkRequestPercentageMultipler = ConfluentConfigs.CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasePhysicalClusterMetadata getInstance(String sessionUuid) {
        Map<String, BasePhysicalClusterMetadata> map = INSTANCES;
        synchronized (map) {
            return INSTANCES.get(sessionUuid);
        }
    }

    public void reconfigure(Map<String, ?> configs) {
        double newLinkRequestPercentageMultiplier = ConfluentConfigs.linkRequestPercentageMultiplier(configs);
        if (this.linkRequestPercentageMultipler != newLinkRequestPercentageMultiplier) {
            this.linkRequestPercentageMultipler = newLinkRequestPercentageMultiplier;
            this.reconfigureQuotas();
        }
    }

    protected void reconfigureQuotas() {
    }

    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        ConfluentConfigs.linkRequestPercentageMultiplier(configs);
    }

    public abstract Set<String> logicalClusterIdsIncludingStale();

    public abstract LCMType metadata(String var1);

    static {
        RECONFIGURABLE_CONFIGS.add("confluent.cluster.link.request.quota.request.percentage.multiplier");
    }
}

