/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AggregationRule {
    private static final Operator DEFAULT_OPERATOR = Operator.sum;
    private final String metric;
    private final List<String> attributes;
    private final Operator operator;
    private final String outputName;

    @JsonCreator
    public AggregationRule(@JsonProperty(value="metric") String metric, @JsonProperty(value="attributes") List<String> attributes, @JsonProperty(value="operator") Operator operator, @JsonProperty(value="outputName") String outputName) {
        this.metric = metric;
        this.attributes = attributes;
        this.operator = (Operator)((Object)MoreObjects.firstNonNull((Object)((Object)operator), (Object)((Object)DEFAULT_OPERATOR)));
        this.outputName = outputName;
    }

    private AggregationRule(Builder builder) {
        this.metric = builder.metric;
        this.attributes = builder.attributes;
        this.operator = builder.operator;
        this.outputName = builder.outputName;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getMetric() {
        return this.metric;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregationRule)) {
            return false;
        }
        AggregationRule that = (AggregationRule)o;
        return Objects.equals(this.metric, that.metric) && Objects.equals(this.attributes, that.attributes) && this.operator == that.operator && Objects.equals(this.outputName, that.outputName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metric, this.attributes, this.operator, this.outputName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metric", (Object)this.metric).add("attributes", this.attributes).add("operator", (Object)this.operator).add("outputName", (Object)this.outputName).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String metric;
        private final List<String> attributes = new ArrayList<String>();
        private Operator operator = Operator.sum;
        private String outputName;

        private Builder() {
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder setAttributes(String ... attributes) {
            this.attributes.addAll(Arrays.asList(attributes));
            return this;
        }

        public Builder setOperator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setOutputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public AggregationRule build() {
            return new AggregationRule(this);
        }
    }

    public static enum Operator {
        sum,
        count,
        avg,
        min,
        max;

    }
}

