/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.awskms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.util.BinaryUtils;
import com.google.common.base.Splitter;
import com.google.crypto.tink.Aead;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.List;

public final class AwsKmsAead
implements Aead {
    private final AWSKMS kmsClient;
    private final String keyArn;

    public AwsKmsAead(AWSKMS kmsClient, String keyArn) {
        this.kmsClient = kmsClient;
        this.keyArn = keyArn;
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        try {
            EncryptRequest req = new EncryptRequest().withKeyId(this.keyArn).withPlaintext(ByteBuffer.wrap(plaintext));
            if (associatedData != null && associatedData.length != 0) {
                req = req.addEncryptionContextEntry("associatedData", BinaryUtils.toHex((byte[])associatedData));
            }
            return this.kmsClient.encrypt(req).getCiphertextBlob().array();
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        try {
            DecryptRequest req = new DecryptRequest().withKeyId(this.keyArn).withCiphertextBlob(ByteBuffer.wrap(ciphertext));
            if (associatedData != null && associatedData.length != 0) {
                req = req.addEncryptionContextEntry("associatedData", BinaryUtils.toHex((byte[])associatedData));
            }
            DecryptResult result = this.kmsClient.decrypt(req);
            if (AwsKmsAead.isKeyArnFormat(this.keyArn) && !result.getKeyId().equals(this.keyArn)) {
                throw new GeneralSecurityException("decryption failed: wrong key id");
            }
            return result.getPlaintext().array();
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }

    private static boolean isKeyArnFormat(String keyArn) {
        List tokens = Splitter.on((char)':').splitToList((CharSequence)keyArn);
        return tokens.size() == 6 && ((String)tokens.get(5)).startsWith("key/");
    }
}

