/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.message.DeleteClusterLinksResponseData;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ConfigurationControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.MirrorTopicControlManager;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.interceptor.ClusterLinkInterceptor;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.policy.CreateClusterLinkPolicy;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ClusterLinkControlManager {
    private final ConfigurationControlManager configManager;
    private final MirrorTopicControlManager mirrorTopicControl;
    private final FeatureControlManager featureControl;
    private final Consumer<Uuid> topicUnlinker;
    private final Consumer<Uuid> aclUnlinker;
    private final Logger log;
    private final TimelineHashMap<String, Uuid> linkNameToId;
    private final TimelineHashMap<Uuid, ClusterLink> clusterLinks;
    private final String localClusterId;
    private final Optional<CreateClusterLinkPolicy> createClusterLinkPolicy;

    public ClusterLinkControlManager(SnapshotRegistry snapshotRegistry, LogContext logContext, ConfigurationControlManager configManager, MirrorTopicControlManager mirrorTopicControl, FeatureControlManager featureControl, Consumer<Uuid> topicUnlinker, Consumer<Uuid> aclUnlinker, String localClusterId, Optional<CreateClusterLinkPolicy> policy) {
        this.linkNameToId = new TimelineHashMap(snapshotRegistry, 0);
        this.clusterLinks = new TimelineHashMap(snapshotRegistry, 0);
        this.log = logContext.logger(ClusterLinkControlManager.class);
        this.configManager = configManager;
        this.mirrorTopicControl = mirrorTopicControl;
        this.featureControl = featureControl;
        this.topicUnlinker = topicUnlinker;
        this.aclUnlinker = aclUnlinker;
        this.localClusterId = localClusterId;
        this.createClusterLinkPolicy = policy;
    }

    public ControllerResult<CreateClusterLinksResponseData> createClusterLinks(CreateClusterLinksRequestData request, KafkaPrincipal kafkaPrincipal) {
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        CreateClusterLinksResponseData response = new CreateClusterLinksResponseData();
        response.setEntries(new ArrayList());
        request.entries().forEach(arg_0 -> this.lambda$createClusterLinks$0((List)records, kafkaPrincipal, response, arg_0));
        if (request.validateOnly()) {
            return ControllerResult.of(Collections.emptyList(), response);
        }
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)records, response);
    }

    public ControllerResult<DeleteClusterLinksResponseData> deleteClusterLinks(DeleteClusterLinksRequestData request) {
        BoundedList records = BoundedList.newArrayBacked((int)10000);
        DeleteClusterLinksResponseData response = new DeleteClusterLinksResponseData();
        response.setEntries(new ArrayList());
        request.linkNames().forEach(arg_0 -> this.lambda$deleteClusterLinks$1((List)records, request, response, arg_0));
        if (request.validateOnly()) {
            return ControllerResult.atomicOf(Collections.emptyList(), response);
        }
        return ControllerResult.atomicOf((List<ApiMessageAndVersion>)records, response);
    }

    public Optional<Uuid> getClusterLinkId(String clusterLinkName) {
        return Optional.ofNullable(this.linkNameToId.get((Object)clusterLinkName));
    }

    public Optional<ClusterLink> getClusterLink(String linkId) {
        try {
            Uuid clusterLinkId = Uuid.fromString((String)linkId);
            return Optional.ofNullable(this.clusterLinks.get((Object)clusterLinkId));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    ResultOrError<Uuid> createClusterLink(CreateClusterLinksRequestData.EntryData clusterLinkData, Consumer<ApiMessageAndVersion> recordConsumer, KafkaPrincipal kafkaPrincipal) {
        Map<String, Map.Entry<AlterConfigOp.OpType, String>> configMap;
        String clusterLinkName = clusterLinkData.linkName();
        Map<String, String> clusterLinkConfig = ClusterLinkControlManager.toConfigMap(clusterLinkData.configs());
        ApiError nameError = ClusterLinkControlManager.validateLinkName(clusterLinkName);
        if (nameError != ApiError.NONE) {
            return ResultOrError.of(nameError);
        }
        if (this.linkNameToId.containsKey((Object)clusterLinkName)) {
            return ResultOrError.of(new ApiError(Errors.CLUSTER_LINK_EXISTS, "Cluster Link " + clusterLinkName + " already exists."));
        }
        if (clusterLinkData.clusterId() == null) {
            return ResultOrError.of(new ApiError(Errors.INVALID_REQUEST, "Source cluster ID cannot be null."));
        }
        if (this.localClusterId.equals(clusterLinkData.clusterId())) {
            return ResultOrError.of(new ApiError(Errors.INVALID_REQUEST, "Source cluster ID matches local cluster ID " + this.localClusterId + ". Cannot create cluster link to self."));
        }
        ClusterLinkConfig.LinkMode linkMode = ClusterLinkControlManager.getLinkMode(clusterLinkConfig);
        Uuid clusterLinkId = ClusterLinkControlManager.validateAndGetLinkIdForClusterLink(clusterLinkData, linkMode, clusterLinkConfig);
        if (this.clusterLinks.containsKey((Object)clusterLinkId)) {
            return ResultOrError.of(new ApiError(Errors.CLUSTER_LINK_EXISTS, "Cluster Link " + clusterLinkId + " already exists."));
        }
        ConfigResource clusterLinkResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLinkId.toString());
        ControllerResult<Map<ConfigResource, ApiError>> configResult = this.configManager.incrementalAlterConfigs(Collections.singletonMap(clusterLinkResource, configMap = ClusterLinkControlManager.toAlterConfigs(clusterLinkData.configs())), true, kafkaPrincipal);
        ApiError configError = configResult.response().get(clusterLinkResource);
        if (configError != ApiError.NONE) {
            return ResultOrError.of(configError);
        }
        this.validateClusterLinkPolicy(clusterLinkData.tenantPrefix(), linkMode.name(), clusterLinkConfig);
        ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord().setClusterLinkName(clusterLinkData.linkName()).setClusterLinkId(clusterLinkId).setRemoteClusterId(clusterLinkData.clusterId()).setTenantPrefix(clusterLinkData.tenantPrefix());
        if (!this.featureControl.metadataVersion().isClusterLinkModeSupported() && linkMode != ClusterLinkConfig.LinkMode.DESTINATION) {
            throw new UnsupportedVersionException("Attempted to write non-default link mode at unsupported version.");
        }
        clusterLinkRecord = clusterLinkRecord.setLinkMode(linkMode.toString());
        recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)clusterLinkRecord, this.featureControl.metadataVersion().clusterLinkRecordVersion()));
        configResult.records().forEach(recordConsumer);
        return ResultOrError.of(clusterLinkId);
    }

    private void validateClusterLinkPolicy(String tenantPrefixStr, String linkModeStr, Map<String, String> clusterLinkConfig) {
        Optional<String> tenantPrefix = Optional.ofNullable(tenantPrefixStr).filter(str -> !str.isEmpty());
        this.createClusterLinkPolicy.ifPresent(policy -> {
            if (!tenantPrefix.isPresent()) {
                throw new InvalidRequestException("Tenant prefix cannot be null if a CreateClusterLinkPolicy is set.");
            }
            this.createClusterLinkPolicy.get().validate(tenantPrefix, linkModeStr, clusterLinkConfig);
        });
    }

    ApiError deleteClusterLink(String clusterLinkName, Consumer<ApiMessageAndVersion> recordConsumer, boolean force) {
        ApiError nameError = ClusterLinkControlManager.validateLinkName(clusterLinkName);
        if (nameError != ApiError.NONE) {
            return nameError;
        }
        Optional<Uuid> clusterLinkId = this.getClusterLinkId(clusterLinkName);
        if (!clusterLinkId.isPresent()) {
            return new ApiError(Errors.CLUSTER_LINK_NOT_FOUND, "Cluster Link " + clusterLinkName + " does not exist.");
        }
        Set<String> topicsInUse = this.mirrorTopicControl.topicsInUse(clusterLinkId.get());
        if (!topicsInUse.isEmpty() && !force) {
            return new ApiError(Errors.CLUSTER_LINK_IN_USE, "Cluster link " + clusterLinkName + " with ID " + clusterLinkId.get() + " in use by topics: " + topicsInUse);
        }
        Uuid linkId = clusterLinkId.get();
        recordConsumer.accept(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkName(clusterLinkName).setClusterLinkId(linkId), 0));
        return ApiError.NONE;
    }

    public void replay(ClusterLinkRecord clusterLinkRecord) {
        this.log.info("Created cluster link {} with ID {}", (Object)clusterLinkRecord.clusterLinkName(), (Object)clusterLinkRecord.clusterLinkId());
        this.linkNameToId.put((Object)clusterLinkRecord.clusterLinkName(), (Object)clusterLinkRecord.clusterLinkId());
        this.clusterLinks.put((Object)clusterLinkRecord.clusterLinkId(), (Object)new ClusterLink(clusterLinkRecord));
        this.createClusterLinkPolicy.filter(policy -> policy instanceof ClusterLinkInterceptor).ifPresent(policy -> ((ClusterLinkInterceptor)policy).linkAdded(clusterLinkRecord.clusterLinkId(), Optional.of(clusterLinkRecord.tenantPrefix()), clusterLinkRecord.linkMode()));
    }

    public void replay(RemoveClusterLinkRecord removeClusterLinkRecord) {
        ClusterLink removedLink = (ClusterLink)this.clusterLinks.remove((Object)removeClusterLinkRecord.clusterLinkId());
        if (removedLink == null) {
            this.log.error("Trying to remove cluster link {} with ID {}, but we have no record of it.", (Object)removeClusterLinkRecord.clusterLinkName(), (Object)removeClusterLinkRecord.clusterLinkId());
            throw new IllegalStateException();
        }
        this.log.info("Deleting cluster link {} with ID {}", (Object)removeClusterLinkRecord.clusterLinkName(), (Object)removeClusterLinkRecord.clusterLinkId());
        String linkName = removedLink.linkName();
        Uuid linkId = removedLink.linkId();
        this.linkNameToId.remove((Object)linkName);
        this.configManager.deleteClusterLinkConfigs(linkId.toString());
        Set<Uuid> topicsInUse = this.mirrorTopicControl.topicIdsForClusterLinkId(linkId, false);
        topicsInUse.forEach(this.topicUnlinker);
        this.mirrorTopicControl.unLinkMirrorTopics(linkId, linkName);
        this.createClusterLinkPolicy.filter(policy -> policy instanceof ClusterLinkInterceptor).ifPresent(policy -> ((ClusterLinkInterceptor)policy).linkDeleted(linkId));
        this.aclUnlinker.accept(linkId);
    }

    public Iterator<List<ApiMessageAndVersion>> iterator(long epoch) {
        return this.clusterLinks.entrySet(epoch).stream().map(entry -> Collections.singletonList(new ApiMessageAndVersion((ApiMessage)((ClusterLink)entry.getValue()).toRecord(), 1))).iterator();
    }

    static ApiError validateLinkName(String linkName) {
        try {
            ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
            return ApiError.NONE;
        }
        catch (Throwable t) {
            return ApiError.fromThrowable((Throwable)t);
        }
    }

    private static Uuid validateAndGetLinkIdForClusterLink(CreateClusterLinksRequestData.EntryData clusterLinkData, ClusterLinkConfig.LinkMode linkMode, Map<String, String> linkConfigs) {
        boolean linkIdProvided = !clusterLinkData.linkId().equals((Object)Uuid.ZERO_UUID);
        switch (linkMode) {
            case SOURCE: {
                if (linkIdProvided) break;
                throw new InvalidRequestException("Cluster link id should be provided in source initiated cluster link.");
            }
            case DESTINATION: {
                if (!linkIdProvided) break;
                throw new InvalidRequestException("Unexpected cluster link id " + clusterLinkData.linkId() + ". Should not be provided for destination initiated cluster link.");
            }
            case BIDIRECTIONAL: {
                boolean isInbound;
                String connectionMode = linkConfigs.get("connection.mode");
                boolean bl = isInbound = connectionMode != null && connectionMode.equalsIgnoreCase(ClusterLinkDescription.ConnectionMode.INBOUND.name().toLowerCase(Locale.ROOT));
                if (!linkIdProvided || !isInbound) break;
                throw new InvalidRequestException("Unexpected cluster link id " + clusterLinkData.linkId() + ". Should not be provided for bi-directional cluster link with inbound connections.");
            }
            default: {
                throw new InvalidRequestException("Unknown link mode " + linkMode);
            }
        }
        if (!clusterLinkData.linkId().equals((Object)Uuid.ZERO_UUID)) {
            return clusterLinkData.linkId();
        }
        return Uuid.randomUuid();
    }

    static Map<String, Map.Entry<AlterConfigOp.OpType, String>> toAlterConfigs(List<CreateClusterLinksRequestData.ConfigData> configData) {
        HashMap<String, Map.Entry<AlterConfigOp.OpType, String>> configMap = new HashMap<String, Map.Entry<AlterConfigOp.OpType, String>>();
        configData.forEach(configKeyValue -> {
            Map.Entry cfr_ignored_0 = configMap.put(configKeyValue.key(), new AbstractMap.SimpleImmutableEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.SET, configKeyValue.value()));
        });
        return configMap;
    }

    static Map<String, String> toConfigMap(List<CreateClusterLinksRequestData.ConfigData> configData) {
        return configData.stream().collect(Collectors.toMap(CreateClusterLinksRequestData.ConfigData::key, CreateClusterLinksRequestData.ConfigData::value));
    }

    static ClusterLinkConfig.LinkMode getLinkMode(Map<String, String> clusterLinkConfig) {
        return ClusterLinkConfig.LinkMode.fromString((String)clusterLinkConfig.getOrDefault("link.mode", ClusterLinkConfig.LinkMode.DESTINATION.name()));
    }

    public ClusterLinkControlState getClusterLinkControlState() {
        Optional<Set<Uuid>> policyLinks = this.createClusterLinkPolicy.filter(policy -> policy instanceof ClusterLinkInterceptor).map(policy -> ((ClusterLinkInterceptor)policy).links());
        return new ClusterLinkControlState(Collections.unmodifiableSet(this.clusterLinks.keySet()), policyLinks);
    }

    public boolean isValidLinkId(Uuid linkId) {
        return this.clusterLinks.containsKey((Object)linkId);
    }

    private /* synthetic */ void lambda$deleteClusterLinks$1(List records, DeleteClusterLinksRequestData request, DeleteClusterLinksResponseData response, String linkName) {
        ApiError apiError = this.deleteClusterLink(linkName, records::add, request.force());
        response.entries().add(new DeleteClusterLinksResponseData.EntryData().setLinkName(linkName).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
    }

    private /* synthetic */ void lambda$createClusterLinks$0(List records, KafkaPrincipal kafkaPrincipal, CreateClusterLinksResponseData response, CreateClusterLinksRequestData.EntryData clusterLinkData) {
        ResultOrError<Object> result;
        try {
            result = this.createClusterLink(clusterLinkData, records::add, kafkaPrincipal);
        }
        catch (Throwable e) {
            result = ResultOrError.of(ApiError.fromThrowable((Throwable)e));
        }
        if (result.isResult()) {
            response.entries().add(new CreateClusterLinksResponseData.EntryData().setLinkName(clusterLinkData.linkName()).setLinkId((Uuid)result.result()));
        } else {
            response.entries().add(new CreateClusterLinksResponseData.EntryData().setLinkName(clusterLinkData.linkName()).setLinkId(Uuid.ZERO_UUID).setErrorCode(result.error().error().code()).setErrorMessage(result.error().message()));
        }
    }

    public static class ClusterLinkControlState {
        public final Set<Uuid> links;
        public final Optional<Set<Uuid>> policyLinks;

        ClusterLinkControlState(Set<Uuid> links, Optional<Set<Uuid>> policyLinks) {
            this.links = links;
            this.policyLinks = policyLinks;
        }
    }
}

