/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.metadata.authorizer.AclsBuilder;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAcl;

class ResourceAclsBuilder
implements AclsBuilder<ResourceAcls> {
    private final Map<StandardAcl, Boolean> changes = new LinkedHashMap<StandardAcl, Boolean>(0);
    private int numRemovals = 0;
    private int numAdditions = 0;
    AtomicInteger numRemoved = new AtomicInteger();
    AtomicInteger numAdded = new AtomicInteger();

    ResourceAclsBuilder() {
    }

    @Override
    public void newRemoval(StandardAcl acl) {
        Boolean prev = this.changes.put(acl, false);
        if (prev == null) {
            ++this.numRemovals;
        } else if (prev.booleanValue()) {
            ++this.numRemovals;
            --this.numAdditions;
        }
    }

    @Override
    public void newAddition(StandardAcl acl) {
        Boolean prev = this.changes.put(acl, true);
        if (prev == null) {
            ++this.numAdditions;
        } else if (!prev.booleanValue()) {
            ++this.numAdditions;
            --this.numRemovals;
        }
    }

    public ResourceAcls build(ResourceAcls oldResourceAcls) {
        return this.apply(oldResourceAcls.allowAcls(), oldResourceAcls.denyAcls());
    }

    private ResourceAcls apply(List<StandardAcl> sourceAllowAcls, List<StandardAcl> sourceDenyAcls) {
        for (Map.Entry<StandardAcl, Boolean> entry : this.changes.entrySet()) {
            if (entry.getKey().permissionType() == AclPermissionType.ALLOW) {
                sourceAllowAcls = this.apply(sourceAllowAcls, entry);
                continue;
            }
            sourceDenyAcls = this.apply(sourceDenyAcls, entry);
        }
        if (this.numRemoved.get() != this.numRemovals) {
            throw new RuntimeException("Unable to find " + (this.numRemovals - this.numRemoved.get()) + " ACL(s) to remove.");
        }
        if (this.numAdded.get() != this.numAdditions) {
            throw new RuntimeException("Unable to find " + (this.numAdditions - this.numAdded.get()) + " ACL(s) to add.");
        }
        return new ResourceAcls(sourceAllowAcls, sourceDenyAcls);
    }

    private List<StandardAcl> apply(List<StandardAcl> source, Map.Entry<StandardAcl, Boolean> changeEntry) {
        StandardAcl acl = changeEntry.getKey();
        source = new ArrayList<StandardAcl>(source);
        if (changeEntry.getValue().booleanValue()) {
            source.add(acl);
            this.numAdded.getAndIncrement();
        } else {
            source.remove(acl);
            this.numRemoved.getAndIncrement();
        }
        return source;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceAclsBuilder(");
        String prefix = "";
        for (Map.Entry<StandardAcl, Boolean> entry : this.changes.entrySet()) {
            builder.append(prefix);
            builder.append(entry.getKey()).append(": ");
            if (entry.getValue().booleanValue()) {
                builder.append("added");
            } else {
                builder.append("removed");
            }
            prefix = ", ";
        }
        builder.append(")");
        return builder.toString();
    }

    boolean isRemoved(StandardAcl acl) {
        Boolean existing = this.changes.get(acl);
        return existing != null && existing == false;
    }

    int numRemovals() {
        return this.numRemovals;
    }

    int netSizeChange() {
        return this.changes.size() - 2 * this.numRemovals;
    }
}

