/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.DefaultDirProvider;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.StripedReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.slf4j.Logger;

public class TopicPlacementReplicaPlacer {
    static final String RACK_KEY = "rack";
    private final Logger log;
    private final Random random;

    public TopicPlacementReplicaPlacer(LogContext logContext, Random random) {
        this.log = logContext.logger(TopicPlacementReplicaPlacer.class);
        this.random = random;
    }

    public static void validateTopicPlacementConfigurationChange(TopicPlacement placement, Iterator<UsableBroker> brokerIterator, Logger log, DefaultDirProvider defaultDirProvider) {
        ClusterMetadata clusterMetadata = TopicPlacementReplicaPlacer.buildClusterMetadata(log, Collections.emptySet(), brokerIterator);
        List<ConstraintAndMatchingBrokers> syncReplicas = TopicPlacementReplicaPlacer.buildConstraintsAndMatchingBrokers(placement.replicas(), clusterMetadata);
        List<ConstraintAndMatchingBrokers> observers = TopicPlacementReplicaPlacer.buildConstraintsAndMatchingBrokers(placement.observers(), clusterMetadata);
        TopicPlacementReplicaPlacer.place(new TopicAssignmentInput(syncReplicas, observers), 0, false, defaultDirProvider);
    }

    public TopicAssignment place(PlacementSpec placement, Iterator<UsableBroker> brokerIterator, DefaultDirProvider defaultDirProvider) {
        TopicAssignmentInput topicAssignmentInput = TopicPlacementReplicaPlacer.buildTopicAssignmentInput(this.log, this.random, placement, brokerIterator);
        int epoch = 0;
        ArrayList<PartitionAssignment> partitionAssignments = new ArrayList<PartitionAssignment>();
        for (int partition = 0; partition < placement.numPartitions; ++partition) {
            partitionAssignments.add(TopicPlacementReplicaPlacer.place(topicAssignmentInput, epoch, true, defaultDirProvider));
            ++epoch;
        }
        return new TopicAssignment(partitionAssignments);
    }

    private static PartitionAssignment place(TopicAssignmentInput topicAssignmentInput, int epoch, boolean requirePreferredLeaderUnfenced, DefaultDirProvider defaultDirProvider) {
        List<Integer> syncReplicaAssignment = TopicPlacementReplicaPlacer.assignSyncReplicas(topicAssignmentInput.syncReplicas, epoch, requirePreferredLeaderUnfenced);
        List<Integer> observerAssignment = TopicPlacementReplicaPlacer.assignObservers(topicAssignmentInput.observers, epoch, syncReplicaAssignment);
        ArrayList<Integer> fullAssignment = new ArrayList<Integer>(syncReplicaAssignment);
        fullAssignment.addAll(observerAssignment);
        return new PartitionAssignment(fullAssignment, observerAssignment, defaultDirProvider);
    }

    private static List<Integer> assignSyncReplicas(List<ConstraintAndMatchingBrokers> constraintsAndMatchingBrokers, int epoch, boolean requirePreferredLeaderUnfenced) {
        ArrayList<Integer> syncReplicaAssignment = new ArrayList<Integer>();
        for (int i = 0; i < constraintsAndMatchingBrokers.size(); ++i) {
            ConstraintAndMatchingBrokers constraintAndMatchingBrokers = constraintsAndMatchingBrokers.get(i);
            int requiredCount = constraintAndMatchingBrokers.count;
            StripedReplicaPlacer.Rack matchingBrokers = constraintAndMatchingBrokers.matchingBrokers;
            for (int j = 0; j < requiredCount; ++j) {
                int broker;
                if (requirePreferredLeaderUnfenced && i == 0 && j == 0) {
                    broker = matchingBrokers.nextUnfenced(epoch);
                    if (broker < 0) {
                        throw new InvalidConfigurationException("Not enough unfenced brokers for the preferred leader" + constraintAndMatchingBrokers.rackName.map(r -> " on rack " + r).orElse(""));
                    }
                } else {
                    broker = TopicPlacementReplicaPlacer.assignNextReplica(matchingBrokers, constraintAndMatchingBrokers.rackName, epoch, syncReplicaAssignment, Collections.emptyList());
                }
                syncReplicaAssignment.add(broker);
            }
        }
        return syncReplicaAssignment;
    }

    private static List<Integer> assignObservers(List<ConstraintAndMatchingBrokers> constraintsAndMatchingBrokers, int epoch, List<Integer> syncReplicaAssignment) {
        ArrayList<Integer> observerAssignment = new ArrayList<Integer>();
        for (int i = 0; i < constraintsAndMatchingBrokers.size(); ++i) {
            ConstraintAndMatchingBrokers constraintAndMatchingBrokers = constraintsAndMatchingBrokers.get(i);
            int requiredCount = constraintAndMatchingBrokers.count;
            StripedReplicaPlacer.Rack matchingBrokers = constraintAndMatchingBrokers.matchingBrokers;
            for (int j = 0; j < requiredCount; ++j) {
                int broker = TopicPlacementReplicaPlacer.assignNextReplica(matchingBrokers, constraintAndMatchingBrokers.rackName, epoch, syncReplicaAssignment, observerAssignment);
                observerAssignment.add(broker);
            }
        }
        return observerAssignment;
    }

    private static int assignNextReplica(StripedReplicaPlacer.Rack rack, Optional<String> rackName, int epoch, List<Integer> syncReplicaAssignment, List<Integer> observerAssignment) {
        int broker;
        while (syncReplicaAssignment.contains(broker = rack.next(epoch)) || observerAssignment.contains(broker)) {
        }
        if (broker < 0) {
            throw new InvalidConfigurationException("Not enough brokers" + rackName.map(r -> " on rack " + r).orElse(""));
        }
        return broker;
    }

    static TopicAssignmentInput buildTopicAssignmentInput(Logger log, Random random, PlacementSpec placementSpec, Iterator<UsableBroker> brokerIterator) {
        ClusterMetadata clusterMetadata = TopicPlacementReplicaPlacer.buildClusterMetadata(log, placementSpec.excludedBrokerIds, brokerIterator);
        clusterMetadata.initialize(random);
        List<ConstraintAndMatchingBrokers> syncReplicas = TopicPlacementReplicaPlacer.buildConstraintsAndMatchingBrokers(placementSpec.topicPlacement.replicas(), clusterMetadata);
        List<ConstraintAndMatchingBrokers> observers = TopicPlacementReplicaPlacer.buildConstraintsAndMatchingBrokers(placementSpec.topicPlacement.observers(), clusterMetadata);
        return new TopicAssignmentInput(syncReplicas, observers);
    }

    private static ClusterMetadata buildClusterMetadata(Logger log, Set<Integer> excludedBrokerIds, Iterator<UsableBroker> brokerIterator) {
        HashMap<Optional<String>, StripedReplicaPlacer.Rack> racks = new HashMap<Optional<String>, StripedReplicaPlacer.Rack>();
        StripedReplicaPlacer.Rack allBrokers = new StripedReplicaPlacer.Rack();
        while (brokerIterator.hasNext()) {
            UsableBroker broker = brokerIterator.next();
            if (excludedBrokerIds.contains(broker.id())) {
                log.debug("Excluding broker {} on rack {}.", (Object)broker.id(), broker.rack());
                continue;
            }
            StripedReplicaPlacer.Rack rack = (StripedReplicaPlacer.Rack)racks.get(broker.rack());
            if (rack == null) {
                rack = new StripedReplicaPlacer.Rack();
                racks.put(broker.rack(), rack);
            }
            if (broker.fenced()) {
                rack.fenced().add(broker.id());
            } else {
                rack.unfenced().add(broker.id());
            }
            if (broker.fenced()) {
                allBrokers.fenced().add(broker.id());
                continue;
            }
            allBrokers.unfenced().add(broker.id());
        }
        ClusterMetadata clusterMetadata = new ClusterMetadata(racks, allBrokers);
        return clusterMetadata;
    }

    private static List<ConstraintAndMatchingBrokers> buildConstraintsAndMatchingBrokers(List<TopicPlacement.ConstraintCount> placementConstraints, ClusterMetadata clusterMetadata) {
        HashSet requestedRacks = new HashSet();
        ArrayList<ConstraintAndMatchingBrokers> constraintAndMatchingBrokers = new ArrayList<ConstraintAndMatchingBrokers>();
        for (TopicPlacement.ConstraintCount constraintCount : placementConstraints) {
            StripedReplicaPlacer.Rack rack;
            Optional<Object> rackStrOpt;
            Map constraints = constraintCount.constraints();
            if (constraints.isEmpty()) {
                rackStrOpt = Optional.empty();
                rack = clusterMetadata.allBrokers;
            } else {
                rackStrOpt = Optional.ofNullable(constraintCount.constraints().get(RACK_KEY));
                rackStrOpt.ifPresent(r -> {
                    if (!requestedRacks.add(r)) {
                        throw new InvalidConfigurationException("Contains duplicate rack " + r);
                    }
                });
                rack = clusterMetadata.racks.getOrDefault(rackStrOpt, ClusterMetadata.EMPTY_RACK);
            }
            constraintAndMatchingBrokers.add(new ConstraintAndMatchingBrokers(rackStrOpt, constraintCount.count(), rack));
        }
        return constraintAndMatchingBrokers;
    }

    static class ConstraintAndMatchingBrokers {
        final Optional<String> rackName;
        final int count;
        final StripedReplicaPlacer.Rack matchingBrokers;

        public ConstraintAndMatchingBrokers(Optional<String> rackName, int count, StripedReplicaPlacer.Rack matchingBrokers) {
            this.rackName = rackName;
            this.count = count;
            this.matchingBrokers = matchingBrokers;
        }
    }

    static class TopicAssignmentInput {
        final List<ConstraintAndMatchingBrokers> syncReplicas;
        final List<ConstraintAndMatchingBrokers> observers;

        public TopicAssignmentInput(List<ConstraintAndMatchingBrokers> syncReplicas, List<ConstraintAndMatchingBrokers> observers) {
            this.syncReplicas = Collections.unmodifiableList(new ArrayList<ConstraintAndMatchingBrokers>(syncReplicas));
            this.observers = Collections.unmodifiableList(new ArrayList<ConstraintAndMatchingBrokers>(observers));
        }
    }

    private static class ClusterMetadata {
        static final StripedReplicaPlacer.Rack EMPTY_RACK = new StripedReplicaPlacer.Rack();
        final Map<Optional<String>, StripedReplicaPlacer.Rack> racks;
        final StripedReplicaPlacer.Rack allBrokers;

        public ClusterMetadata(Map<Optional<String>, StripedReplicaPlacer.Rack> racks, StripedReplicaPlacer.Rack allBrokers) {
            this.racks = racks;
            this.allBrokers = allBrokers;
        }

        private void initialize(Random random) {
            for (StripedReplicaPlacer.Rack rack : this.racks.values()) {
                rack.initialize(random);
            }
            this.allBrokers.initialize(random);
        }
    }

    public static class PlacementSpec {
        private final TopicPlacement topicPlacement;
        private final Set<Integer> excludedBrokerIds;
        private final int startPartition;
        private final int numPartitions;

        public PlacementSpec(TopicPlacement topicPlacement, Set<Integer> excludedBrokerIds, int startPartition, int numPartitions) {
            this.topicPlacement = topicPlacement;
            this.excludedBrokerIds = excludedBrokerIds;
            this.startPartition = startPartition;
            this.numPartitions = numPartitions;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!o.getClass().equals(PlacementSpec.class)) {
                return false;
            }
            PlacementSpec other = (PlacementSpec)o;
            return this.topicPlacement.equals((Object)other.topicPlacement) && this.excludedBrokerIds.equals(other.excludedBrokerIds) && this.startPartition == other.startPartition && this.numPartitions == other.numPartitions;
        }

        public int hashCode() {
            return Objects.hash(this.topicPlacement, this.excludedBrokerIds, this.startPartition, this.numPartitions);
        }

        public String toString() {
            return "PlacementSpec(topicPlacement=" + this.topicPlacement + ", excludedBrokerIds=" + this.excludedBrokerIds + ", startPartition=" + this.startPartition + ", numPartitions=" + this.numPartitions + ")";
        }
    }
}

