/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufDeserializer;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.builtin.deserializers.MessageDeserializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MessageDeserializerFactory
extends Deserializers.Base {
    private final ProtobufJacksonConfig config;
    private final ConcurrentMap<Class<? extends Message>, ProtobufDeserializer<?, ?>> deserializerCache;

    @Deprecated
    public MessageDeserializerFactory(ExtensionRegistryWrapper extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public MessageDeserializerFactory(ProtobufJacksonConfig config) {
        this.config = config;
        this.deserializerCache = new ConcurrentHashMap();
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (Message.class.isAssignableFrom(type.getRawClass())) {
            return this.getDeserializer(type.getRawClass()).buildAtEnd();
        }
        if (Message.Builder.class.isAssignableFrom(type.getRawClass())) {
            return this.getDeserializer(type.getRawClass().getDeclaringClass());
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    private <T extends Message> ProtobufDeserializer<T, ?> getDeserializer(Class<T> messageType) {
        ProtobufDeserializer deserializer = (ProtobufDeserializer)((Object)this.deserializerCache.get(messageType));
        if (deserializer == null) {
            MessageDeserializer newDeserializer = new MessageDeserializer(messageType, this.config);
            ProtobufDeserializer previousDeserializer = this.deserializerCache.putIfAbsent(messageType, newDeserializer);
            deserializer = previousDeserializer == null ? newDeserializer : previousDeserializer;
        }
        return deserializer;
    }
}

