/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.platform;

import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.connect.hub.platform.InstallationState;
import io.confluent.connect.hub.utils.NamingUtils;
import io.confluent.pluginregistry.rest.entities.PluginManifest;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class InstallationTypeConsumer
implements Consumer<Path> {
    private static final String WRONG_NUMBER_OF_COMPONENTS_MSG = "Expected to find only one version of a component";
    private final Path lookupPath;
    private final Path bundledLookupPath;
    private String componentJarName;
    private InstallationState installationState;

    public InstallationTypeConsumer(PluginManifest manifest, String installationPath) {
        this.lookupPath = Paths.get(NamingUtils.getInstallToComponentFolder(installationPath, manifest), new String[0]);
        this.bundledLookupPath = Paths.get(NamingUtils.getBundledComponentFolder(installationPath, manifest), new String[0]);
        this.componentJarName = NamingUtils.getComponentJarName(manifest);
        this.installationState = InstallationState.NOT_INSTALLED;
    }

    @Override
    public void accept(Path path) {
        if (path.equals(this.lookupPath)) {
            if (InstallationState.NOT_INSTALLED != this.installationState) {
                throw new ConfluentHubClientException(WRONG_NUMBER_OF_COMPONENTS_MSG, ExitCode.UNKNOWN_ERROR);
            }
            this.installationState = InstallationState.IMMEDIATE_DIRECTORY;
        } else if (path.endsWith(this.componentJarName)) {
            if (InstallationState.NOT_INSTALLED != this.installationState) {
                throw new ConfluentHubClientException(WRONG_NUMBER_OF_COMPONENTS_MSG, ExitCode.UNKNOWN_ERROR);
            }
            this.installationState = InstallationState.UBER_JAR;
        } else if (path.equals(this.bundledLookupPath)) {
            if (InstallationState.NOT_INSTALLED != this.installationState) {
                throw new ConfluentHubClientException(WRONG_NUMBER_OF_COMPONENTS_MSG, ExitCode.UNKNOWN_ERROR);
            }
            this.installationState = InstallationState.BUNDLED;
        }
    }

    public InstallationState getInstallationState() {
        return this.installationState;
    }
}

