/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry;

import io.confluent.pluginregistry.util.ObjectUtil;
import java.util.Comparator;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class Version
implements Comparable<Version> {
    private final ComparableVersion parsedVersion;

    public static Comparator<Version> earliestToRecent() {
        return new SemanticComparator();
    }

    public static Comparator<Version> recentToEarliest() {
        return new SemanticComparator().reversed();
    }

    public Version(String version) {
        Objects.requireNonNull(version, "Version string cannot be null");
        this.parsedVersion = new ComparableVersion(version);
    }

    public String getCanonical() {
        return this.parsedVersion.getCanonical();
    }

    public int hashCode() {
        return this.parsedVersion.toString().toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version that = (Version)obj;
        return this.parsedVersion.toString().equalsIgnoreCase(that.parsedVersion.toString());
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.parsedVersion, that.parsedVersion);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.parsedVersion.toString().toLowerCase(), that.parsedVersion.toString().toLowerCase());
        return diff;
    }

    public String toString() {
        return this.parsedVersion.toString();
    }

    private static class SemanticComparator
    implements Comparator<Version> {
        private SemanticComparator() {
        }

        @Override
        public int compare(Version v1, Version v2) {
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.parsedVersion.compareTo(v2.parsedVersion);
        }
    }
}

