/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.ConfluentAuthorizerConfig;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.Auditable;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import io.confluent.security.authorizer.provider.GroupProvider;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import io.confluent.security.authorizer.provider.MetadataProvider;
import io.confluent.security.authorizer.provider.Provider;
import io.confluent.security.authorizer.provider.ProviderFailedException;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.authorizer.provider.SharedProvider;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.AuthorizerNotReadyException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedAuthorizer
implements Authorizer {
    protected static final Logger log = LoggerFactory.getLogger((String)"kafka.authorizer.logger");
    protected final Set<Provider> providersCreated = new HashSet<Provider>();
    private GroupProvider groupProvider;
    protected List<AccessRuleProvider> accessRuleProviders;
    private AuditLogProvider auditLogProvider;
    protected ConfluentAuthorizerConfig authorizerConfig;
    private MetadataProvider metadataProvider;
    protected boolean allowEveryoneIfNoAcl;
    private Set<KafkaPrincipal> superUsers = Collections.emptySet();
    protected Set<KafkaPrincipal> brokerUsers = Collections.emptySet();
    protected String interBrokerListener;
    protected Duration initTimeout;
    protected volatile boolean ready;
    protected volatile String clusterId;
    protected volatile Scope scope = Scope.ROOT_SCOPE;
    protected volatile Scope auditLogScope = Scope.ROOT_SCOPE;
    protected AuthorizerMetrics authorizerMetrics;
    private volatile boolean isKraft;
    private static final Map<String, Set<Provider>> AUTHORIZER_PROVIDERS_MAP = new HashMap<String, Set<Provider>>();
    private String sessionUuid = null;
    private String physicalClusterId;
    private static final Object AUTHORIZER_PROVIDERS_MAP_LOCK = new Object();

    public void configure(Map<String, ?> configs) {
        Object physicalClusterIdValue;
        String role = (String)configs.get("process.roles");
        this.isKraft = role != null && !role.isEmpty();
        this.authorizerConfig = new ConfluentAuthorizerConfig(configs);
        this.allowEveryoneIfNoAcl = this.authorizerConfig.allowEveryoneIfNoAcl;
        this.superUsers = this.authorizerConfig.superUsers;
        this.brokerUsers = this.authorizerConfig.brokerUsers;
        Object uuid = configs.get("broker.session.uuid");
        if (uuid != null) {
            this.sessionUuid = configs.get("broker.session.uuid").toString();
        }
        if ((physicalClusterIdValue = configs.get("confluent.security.event.logger.physical.cluster.id")) != null) {
            this.physicalClusterId = configs.get("confluent.security.event.logger.physical.cluster.id").toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureServerInfo(ConfluentAuthorizerServerInfo serverInfo) {
        Set existing;
        this.clusterId = serverInfo.clusterResource().clusterId();
        log.debug("Configuring scope for Kafka cluster with cluster id {}", (Object)this.clusterId);
        this.scope = Scope.kafkaClusterScope((String)this.clusterId);
        this.auditLogScope = this.physicalClusterId == null || this.physicalClusterId.isEmpty() ? this.scope : Scope.kafkaClusterScope((String)this.physicalClusterId);
        this.interBrokerListener = (String)serverInfo.interBrokerEndpoint().listenerName().get();
        this.authorizerMetrics = new AuthorizerMetrics(serverInfo.metrics(), Time.SYSTEM);
        Object object = AUTHORIZER_PROVIDERS_MAP_LOCK;
        synchronized (object) {
            existing = this.sessionUuid != null ? (Set)AUTHORIZER_PROVIDERS_MAP.getOrDefault(this.sessionUuid, new HashSet()) : Collections.emptySet();
        }
        ConfluentAuthorizerConfig.Providers providers = this.authorizerConfig.createProviders(this.clusterId, existing);
        this.providersCreated.addAll(providers.accessRuleProviders);
        if (providers.groupProvider != null) {
            this.providersCreated.add(providers.groupProvider);
        }
        if (providers.metadataProvider != null) {
            this.providersCreated.add(providers.metadataProvider);
        }
        this.providersCreated.stream().filter(provider -> provider instanceof Auditable).forEach(provider -> ((Auditable)((Object)provider)).auditLogProvider(serverInfo.auditLogProvider()));
        this.configureProviders(providers.accessRuleProviders, providers.groupProvider, providers.metadataProvider, serverInfo.auditLogProvider());
    }

    @Override
    public List<AuthorizeResult> authorize(RequestContext requestContext, List<Action> actions) {
        long startTime = this.authorizerMetrics.metricsTime().milliseconds();
        List<AuthorizeResult> results = actions.stream().map(action -> this.authorize(requestContext, (Action)action, this::authorize)).collect(Collectors.toList());
        this.authorizerMetrics.recordAuthorizerMetrics(results, actions, startTime);
        return results;
    }

    public GroupProvider groupProvider() {
        return this.groupProvider;
    }

    public AccessRuleProvider accessRuleProvider(String providerName) {
        Optional<AccessRuleProvider> provider = this.accessRuleProviders.stream().filter(p -> p.providerName().equals(providerName)).findFirst();
        if (provider.isPresent()) {
            return provider.get();
        }
        throw new IllegalArgumentException("Access rule provider not found: " + providerName);
    }

    public MetadataProvider metadataProvider() {
        return this.metadataProvider;
    }

    public List<AccessRuleProvider> accessRuleProviders() {
        return this.accessRuleProviders;
    }

    public AuditLogProvider auditLogProvider() {
        return this.auditLogProvider;
    }

    public CompletableFuture<Void> start(ConfluentAuthorizerServerInfo serverInfo, Runnable initTask) {
        boolean usesMetadataFromThisKafkaCluster;
        this.initTimeout = this.authorizerConfig.initTimeout;
        if (this.authorizerMetrics == null) {
            this.authorizerMetrics = new AuthorizerMetrics(serverInfo.metrics(), Time.SYSTEM);
        }
        HashSet<Provider> allProviders = new HashSet<Provider>();
        if (this.groupProvider != null) {
            allProviders.add(this.groupProvider);
        }
        allProviders.addAll(this.accessRuleProviders);
        if (this.metadataProvider != null) {
            allProviders.add(this.metadataProvider);
        }
        List<CompletableFuture> futures = allProviders.stream().map(provider -> provider.start(serverInfo)).map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[futures.size()]);
        CompletionStage readyFuture = ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futureArray).thenAccept(unused -> {
            this.ready = true;
        })).thenRunAsync(initTask)).thenAccept(unused -> this.auditLogProvider.start(serverInfo.interBrokerClientConfig()));
        CompletableFuture<Void> future = this.futureOrTimeout((CompletableFuture<Void>)readyFuture, this.initTimeout);
        boolean bl = usesMetadataFromThisKafkaCluster = this.groupProvider != null && this.groupProvider.usesMetadataFromThisKafkaCluster() || this.metadataProvider != null && this.metadataProvider.usesMetadataFromThisKafkaCluster() || this.accessRuleProviders.stream().anyMatch(Provider::usesMetadataFromThisKafkaCluster) || this.auditLogProvider.usesMetadataFromThisKafkaCluster();
        if (!usesMetadataFromThisKafkaCluster) {
            future.join();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureProviders(List<AccessRuleProvider> accessRuleProviders, GroupProvider groupProvider, MetadataProvider metadataProvider, AuditLogProvider auditLogProvider) {
        this.accessRuleProviders = accessRuleProviders;
        this.groupProvider = groupProvider;
        this.metadataProvider = metadataProvider;
        this.auditLogProvider = auditLogProvider == null ? NoOpAuditLogProvider.INSTANCE : auditLogProvider;
        Object object = AUTHORIZER_PROVIDERS_MAP_LOCK;
        synchronized (object) {
            if (this.sessionUuid != null && !AUTHORIZER_PROVIDERS_MAP.containsKey(this.sessionUuid)) {
                for (Provider provider : accessRuleProviders) {
                    if (!(provider instanceof SharedProvider)) continue;
                    AUTHORIZER_PROVIDERS_MAP.putIfAbsent(this.sessionUuid, new HashSet());
                    AUTHORIZER_PROVIDERS_MAP.get(this.sessionUuid).add(provider);
                }
            }
        }
    }

    protected boolean ready() {
        return this.ready;
    }

    protected boolean isSuperUser(KafkaPrincipal sessionPrincipal, KafkaPrincipal userOrGroupPrincipal, Action action) {
        return this.superUsers.contains(userOrGroupPrincipal);
    }

    protected AuthorizeResult authorizeByResourceType(RequestContext requestContext, Operation op, ResourceType resourceType) {
        Action action = this.actionForAuthorizeByResourceType(requestContext, op, resourceType);
        return this.authorize(requestContext, action, this::authorizeByResourceType);
    }

    protected Action actionForAuthorizeByResourceType(RequestContext requestContext, Operation op, ResourceType resourceType) {
        return new Action(this.scope(), new ResourcePattern(resourceType, "", PatternType.ANY), op, 1, true, true);
    }

    private AuthorizeResult authorize(RequestContext requestContext, Action action, Function<AuthorizationContext, AuthorizePolicy> authorizeFunction) {
        try {
            AuthorizePolicy authorizePolicy;
            KafkaPrincipal sessionPrincipal = requestContext.principal();
            String host = requestContext.clientAddress().getHostAddress();
            KafkaPrincipal userPrincipal = this.userPrincipal(sessionPrincipal);
            if (this.isSuperUser(sessionPrincipal, userPrincipal, action)) {
                log.debug("principal = {} is a super user, allowing operation without checking any providers.", (Object)userPrincipal);
                authorizePolicy = new AuthorizePolicy.SuperUser(AuthorizePolicy.PolicyType.SUPER_USER, userPrincipal);
            } else if (this.isBrokerUserOnInterBrokerListener(requestContext)) {
                log.debug("principal = {} is a broker user, allowing operation without checking any providers.", (Object)userPrincipal);
                authorizePolicy = new AuthorizePolicy.BrokerUser(AuthorizePolicy.PolicyType.BROKER_USER, userPrincipal);
            } else {
                Scope scope = action.scope();
                Set<KafkaPrincipal> groupPrincipals = this.groupProvider.groups(sessionPrincipal);
                Optional<KafkaPrincipal> superGroup = groupPrincipals.stream().filter(group -> this.isSuperUser(sessionPrincipal, (KafkaPrincipal)group, action)).findFirst();
                if (superGroup.isPresent()) {
                    log.debug("principal = {} belongs to super group {}, allowing operation without checking acls.", (Object)userPrincipal, (Object)superGroup.get());
                    authorizePolicy = new AuthorizePolicy.SuperUser(AuthorizePolicy.PolicyType.SUPER_GROUP, superGroup.get());
                } else {
                    authorizePolicy = this.accessRuleProviders.stream().anyMatch(p -> p.isSuperUser(sessionPrincipal, scope)) ? new AuthorizePolicy.SuperUser(AuthorizePolicy.PolicyType.SUPER_USER, sessionPrincipal) : ((superGroup = groupPrincipals.stream().filter(principal -> this.accessRuleProviders.stream().anyMatch(p -> p.isSuperUser((KafkaPrincipal)principal, scope))).findAny()).isPresent() ? new AuthorizePolicy.SuperUser(AuthorizePolicy.PolicyType.SUPER_GROUP, superGroup.get()) : authorizeFunction.apply(new AuthorizationContext(sessionPrincipal, groupPrincipals, host, action)));
                }
            }
            AuthorizeResult authorizeResult = authorizePolicy.policyType().accessGranted() ? AuthorizeResult.ALLOWED : AuthorizeResult.DENIED;
            try {
                this.logAuditMessage(this.auditLogScope, requestContext, action, authorizeResult, authorizePolicy);
            }
            catch (Exception e) {
                log.error("Failed to log Audit message.\n  scope: {}\n  context: {}\n  principal: {}\n  action: {}\n  result: {}\n  policy: {}", new Object[]{this.auditLogScope, requestContext, requestContext.principal(), action, authorizeResult, authorizePolicy, e});
            }
            return authorizeResult;
        }
        catch (InvalidScopeException e) {
            log.error("Authorizer failed with unknown scope. principal {}, action: {}", new Object[]{requestContext.principal(), action, e});
            return AuthorizeResult.UNKNOWN_SCOPE;
        }
        catch (ProviderFailedException e) {
            log.error("Authorization provider has failed. principal {}, action: {}", new Object[]{requestContext.principal(), action, e});
            return AuthorizeResult.AUTHORIZER_FAILED;
        }
        catch (Throwable t) {
            log.error("Authorization failed with unexpected exception. principal {}, action: {}", new Object[]{requestContext.principal(), action, t});
            return AuthorizeResult.UNKNOWN_ERROR;
        }
    }

    private boolean isBrokerUserOnInterBrokerListener(RequestContext requestContext) {
        return this.interBrokerListener != null && this.interBrokerListener.equals(requestContext.listenerName()) && this.brokerUsers.contains(requestContext.principal());
    }

    private AuthorizePolicy authorize(AuthorizationContext context) {
        if (this.isKraft && !this.ready) {
            throw new AuthorizerNotReadyException();
        }
        KafkaPrincipal sessionPrincipal = context.sessionPrincipal;
        Set<KafkaPrincipal> groupPrincipals = context.groupPrincipals;
        String host = context.host;
        Action action = context.action;
        ResourcePattern resource = action.resourcePattern();
        Operation operation = action.operation();
        AuthorizeRule authorizeRule = new AuthorizeRule();
        this.accessRuleProviders.stream().filter(AccessRuleProvider::mayDeny).forEach(p -> authorizeRule.add(p.findRule(sessionPrincipal, groupPrincipals, host, action)));
        Optional<AuthorizePolicy> authorizePolicy = this.authorizePolicy(operation, resource, host, authorizeRule);
        if (authorizePolicy.isPresent()) {
            return authorizePolicy.get();
        }
        this.accessRuleProviders.stream().filter(p -> !p.mayDeny()).forEach(p -> authorizeRule.add(p.findRule(sessionPrincipal, groupPrincipals, host, action)));
        authorizePolicy = this.authorizePolicy(operation, resource, host, authorizeRule);
        if (authorizePolicy.isPresent()) {
            return authorizePolicy.get();
        }
        return authorizePolicy.orElse(this.authorizePolicyWithNoMatchingRule(resource, authorizeRule));
    }

    private AuthorizePolicy authorizeByResourceType(AuthorizationContext context) {
        ResourceAuthorizeRules matchingRules = new ResourceAuthorizeRules();
        this.accessRuleProviders.forEach(provider -> provider.addMatchingRules(matchingRules, context.sessionPrincipal, context.groupPrincipals, context.host, context.action.operation(), context.action.scope(), context.action.resourceType()));
        Set<String> denyLiterals = matchingRules.denyLiteralRules().keySet();
        Set<String> denyPrefixes = matchingRules.denyPrefixedRules().keySet();
        Set<String> allowLiterals = matchingRules.allowLiteralRules().keySet();
        Set<String> allowPrefixes = matchingRules.allowPrefixedRules().keySet();
        AuthorizePolicy authorizePolicy = null;
        if (denyLiterals.contains("*")) {
            authorizePolicy = matchingRules.denyLiteralRules().get("*");
        } else if (allowLiterals.contains("*")) {
            authorizePolicy = matchingRules.allowLiteralRules().get("*");
        } else if (this.allowEveryoneIfNoAcl) {
            authorizePolicy = AuthorizePolicy.ALLOW_ON_NO_RULE;
        } else if (denyLiterals.isEmpty() && denyPrefixes.isEmpty()) {
            authorizePolicy = allowLiterals.isEmpty() && allowPrefixes.isEmpty() ? AuthorizePolicy.DENY_ON_NO_RULE : (allowPrefixes.isEmpty() ? (AuthorizePolicy)matchingRules.allowLiteralRules().values().iterator().next() : (AuthorizePolicy)matchingRules.allowPrefixedRules().values().iterator().next());
        } else {
            for (String allowLiteral : allowLiterals) {
                if (denyLiterals.contains(allowLiteral) || this.hasDominatedDeny(allowLiteral, denyPrefixes)) continue;
                authorizePolicy = matchingRules.allowLiteralRules().get(allowLiteral);
                break;
            }
            if (authorizePolicy == null) {
                for (String allowPrefix : allowPrefixes) {
                    if (this.hasDominatedDeny(allowPrefix, denyPrefixes)) continue;
                    authorizePolicy = matchingRules.allowPrefixedRules().get(allowPrefix);
                    break;
                }
            }
        }
        if (authorizePolicy == null) {
            authorizePolicy = denyPrefixes.isEmpty() ? (AuthorizePolicy)matchingRules.denyLiteralRules().values().iterator().next() : (AuthorizePolicy)matchingRules.denyPrefixedRules().values().iterator().next();
        }
        return authorizePolicy;
    }

    @Override
    public void close() {
        EmbeddedAuthorizer.removeFromAuthorizerProvidersMap(this.sessionUuid);
        log.debug("Closing embedded authorizer");
        AtomicReference<Object> firstException = new AtomicReference<Object>();
        this.providersCreated.forEach(provider -> Utils.closeQuietly((AutoCloseable)provider, (String)provider.providerName(), (AtomicReference)firstException));
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            log.error("Failed to close authorizer cleanly", exception);
        }
    }

    protected Scope scope() {
        return this.scope;
    }

    protected void setupAuthorizerMetrics(Metrics metrics) {
        this.authorizerMetrics = new AuthorizerMetrics(metrics, Time.SYSTEM);
    }

    private Optional<AuthorizePolicy> authorizePolicy(Operation op, ResourcePattern resource, String host, AuthorizeRule authorizeRule) {
        Optional<AccessRule> ruleOpt = authorizeRule.denyRule().isPresent() ? authorizeRule.denyRule() : authorizeRule.allowRule();
        ruleOpt.ifPresent(rule -> log.debug("operation = {} on resource = {} from host = {} is {} based on policy = {}", new Object[]{op, resource, host, rule.permissionType(), rule}));
        return ruleOpt.map(Function.identity());
    }

    private AuthorizePolicy authorizePolicyWithNoMatchingRule(ResourcePattern resource, AuthorizeRule authorizeRule) {
        if (authorizeRule.noResourceAcls()) {
            log.debug("No acl found for resource {}, authorized = {}", (Object)resource, (Object)this.allowEveryoneIfNoAcl);
            return this.allowEveryoneIfNoAcl ? AuthorizePolicy.ALLOW_ON_NO_RULE : AuthorizePolicy.DENY_ON_NO_RULE;
        }
        return AuthorizePolicy.NO_MATCHING_RULE;
    }

    private KafkaPrincipal userPrincipal(KafkaPrincipal sessionPrincipal) {
        return sessionPrincipal.getClass() != KafkaPrincipal.class ? new KafkaPrincipal(sessionPrincipal.getPrincipalType(), sessionPrincipal.getName()) : sessionPrincipal;
    }

    private boolean hasDominatedDeny(String allowedName, Set<String> deniedPrefixes) {
        StringBuilder sb = new StringBuilder();
        for (char ch : allowedName.toCharArray()) {
            sb.append(ch);
            if (!deniedPrefixes.contains(sb.toString())) continue;
            return true;
        }
        return false;
    }

    protected void logAuditMessage(Scope sourceScope, RequestContext requestContext, Action action, AuthorizeResult authorizeResult, AuthorizePolicy authorizePolicy) {
        ConfluentAuthorizationEvent auditEvent = new ConfluentAuthorizationEvent(sourceScope, requestContext, action, authorizeResult, authorizePolicy);
        this.logAuthorization(auditEvent);
        this.auditLogProvider.logEvent((AuditEvent)auditEvent, requestContext.isProxyModeLocal());
    }

    private void logAuthorization(ConfluentAuthorizationEvent authZEvent) {
        String logMessage = "Principal = {} is {} Operation = {} from host = {} on resource = {}";
        KafkaPrincipal principal = authZEvent.requestContext().principal();
        String operation = authZEvent.action().operation().name();
        Supplier<String> host = () -> authZEvent.requestContext().clientAddress().getHostAddress();
        Supplier<String> resource = () -> SecurityUtils.toPascalCase((String)authZEvent.action().resourceType().name()) + ":" + authZEvent.action().resourcePattern().patternType() + ":" + authZEvent.action().resourceName();
        if (authZEvent.authorizeResult() == AuthorizeResult.ALLOWED) {
            if (authZEvent.action().logIfAllowed() && log.isDebugEnabled()) {
                log.debug(logMessage, new Object[]{principal, "Allowed", operation, host.get(), resource.get()});
            } else if (log.isTraceEnabled()) {
                log.trace(logMessage, new Object[]{principal, "Allowed", operation, host.get(), resource.get()});
            }
        } else if (authZEvent.action().logIfDenied() && log.isInfoEnabled()) {
            log.info(logMessage, new Object[]{principal, "Denied", operation, host.get(), resource.get()});
        } else if (log.isTraceEnabled()) {
            log.trace(logMessage, new Object[]{principal, "Denied", operation, host.get(), resource.get()});
        }
    }

    protected CompletableFuture<Void> futureOrTimeout(CompletableFuture<Void> readyFuture, Duration timeout) {
        if (readyFuture.isDone()) {
            return readyFuture;
        }
        CompletableFuture timeoutFuture = new CompletableFuture();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory("authorizer-%d", true));
        executor.schedule(() -> {
            String errorMessage = String.format("Authorizer did not start up within the timeout %s=%d ms. This may be due to one or more brokers being down for longer than this interval. Please start all brokers in the cluster within '%s' of each other to ensure that all partitions required for authorizer start up are available within this timeout.", "confluent.authorizer.init.timeout.ms", this.initTimeout.toMillis(), "confluent.authorizer.init.timeout.ms");
            timeoutFuture.completeExceptionally((Throwable)new TimeoutException(errorMessage));
        }, timeout.toMillis(), TimeUnit.MILLISECONDS);
        return ((CompletableFuture)CompletableFuture.anyOf(readyFuture, timeoutFuture).thenApply(unused -> null)).whenComplete((unused, e) -> executor.shutdownNow());
    }

    protected Metrics metrics() {
        return this.authorizerMetrics.metrics();
    }

    void setupAuthorizerMetrics(Time time) {
        this.authorizerMetrics = new AuthorizerMetrics(time);
    }

    protected Time metricsTime() {
        return this.authorizerMetrics.metricsTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromAuthorizerProvidersMap(String sessionUuid) {
        if (sessionUuid != null) {
            Object object = AUTHORIZER_PROVIDERS_MAP_LOCK;
            synchronized (object) {
                AUTHORIZER_PROVIDERS_MAP.remove(sessionUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAuthorizerProvidersMap() {
        Object object = AUTHORIZER_PROVIDERS_MAP_LOCK;
        synchronized (object) {
            AUTHORIZER_PROVIDERS_MAP.clear();
        }
    }

    protected static class AuthorizationContext {
        protected final KafkaPrincipal sessionPrincipal;
        protected final Set<KafkaPrincipal> groupPrincipals;
        protected final String host;
        protected final Action action;

        AuthorizationContext(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
            this.sessionPrincipal = sessionPrincipal;
            this.groupPrincipals = groupPrincipals;
            this.host = host;
            this.action = action;
        }
    }

    public static class AuthorizerMetrics {
        public static final String GROUP_NAME = "confluent-authorizer-metrics";
        public static final String AUTHORIZATION_REQUEST_RATE_MINUTE = "authorization-request-rate-per-minute";
        public static final String AUTHORIZATION_ALLOWED_RATE_MINUTE = "authorization-allowed-rate-per-minute";
        public static final String AUTHORIZATION_DENIED_RATE_MINUTE = "authorization-denied-rate-per-minute";
        public static final String AUTHORIZATION_REQUEST_DENIED_RATE_MINUTE = "authorization-request-denied-rate-per-minute";
        public static final String AUTHORIZER_RESOURCE_FILTER_RATE_MINUTE = "authorizer-resource-filter-rate-per-minute";
        public static final String AUTHORIZER_ERROR_RATE_MINUTE = "authorizer-error-rate-per-minute";
        public static final String AUTHORIZER_AUTHORIZATION_LATENCY_METRIC_P90 = "authorizer-authorization-latency-p90";
        public static final String AUTHORIZER_AUTHORIZATION_LATENCY_METRIC_P99 = "authorizer-authorization-latency-p99";
        private static final String AUTHORIZER_AUTHORIZATION_ALLOWED_SENSOR = "authorizer-authorization-allowed";
        private static final String AUTHORIZER_AUTHORIZATION_DENIED_SENSOR = "authorizer-authorization-denied";
        private static final String AUTHORIZER_AUTHORIZATION_REQUEST_DENIED_SENSOR = "authorizer-authorization-request-denied";
        private static final String AUTHORIZER_RESOURCE_FILTER_SENSOR = "authorizer-resource-filter";
        private static final String AUTHORIZER_AUTHORIZATION_REQUEST_SENSOR = "authorizer-authorization-request";
        private static final String AUTHORIZER_AUTHORIZATION_LATENCY_SENSOR = "authorizer-authorization-latency";
        private static final String AUTHORIZER_AUTHORIZATION_FAILED_SENSOR = "authorizer-authorization-failed";
        private static final Map<AuthorizeResult, String> FAILED_AUTH_MAP = Collections.unmodifiableMap(new EnumMap<AuthorizeResult, String>(AuthorizeResult.class){
            {
                this.put(AuthorizeResult.AUTHORIZER_FAILED, "authorizer-failed");
                this.put(AuthorizeResult.UNKNOWN_SCOPE, "unknown-scope");
                this.put(AuthorizeResult.UNKNOWN_ERROR, "unknown-error");
            }
        });
        private final Time time;
        private final Metrics metrics;
        private final Sensor authorizationAllowedSensor;
        private final Sensor authorizationDeniedSensor;
        private final Sensor authorizationRequestDeniedSensor;
        private final Sensor authorizerResourceFilterSensor;
        private final Sensor authorizationRequestSensor;
        private final Map<AuthorizeResult, Sensor> failedSensors = new EnumMap<AuthorizeResult, Sensor>(AuthorizeResult.class);
        private final Sensor authorizationLatencySensor;

        public AuthorizerMetrics(Metrics metrics, Time time) {
            this.time = time;
            this.metrics = metrics;
            this.authorizationAllowedSensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_ALLOWED_SENSOR);
            this.authorizationAllowedSensor.add(metrics.metricName(AUTHORIZATION_ALLOWED_RATE_MINUTE, GROUP_NAME, "The number of authorization allowed per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.authorizationDeniedSensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_DENIED_SENSOR);
            this.authorizationDeniedSensor.add(metrics.metricName(AUTHORIZATION_DENIED_RATE_MINUTE, GROUP_NAME, "The number of authorization denied per minute (includes denials from metadata/list topic requests)"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.authorizationRequestDeniedSensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_REQUEST_DENIED_SENSOR);
            this.authorizationRequestDeniedSensor.add(metrics.metricName(AUTHORIZATION_REQUEST_DENIED_RATE_MINUTE, GROUP_NAME, "The number of request authorization denials per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.authorizerResourceFilterSensor = metrics.sensor(AUTHORIZER_RESOURCE_FILTER_SENSOR);
            this.authorizerResourceFilterSensor.add(metrics.metricName(AUTHORIZER_RESOURCE_FILTER_RATE_MINUTE, GROUP_NAME, "The number of request authorizer resource filter per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.authorizationRequestSensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_REQUEST_SENSOR);
            this.authorizationRequestSensor.add(metrics.metricName(AUTHORIZATION_REQUEST_RATE_MINUTE, GROUP_NAME, "The number of authorization request per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            this.addAuthFailureMetrics();
            this.authorizationLatencySensor = metrics.sensor(AUTHORIZER_AUTHORIZATION_LATENCY_SENSOR);
            this.addAuthLatencyMetrics();
        }

        final void addAuthFailureMetrics() {
            for (AuthorizeResult key : FAILED_AUTH_MAP.keySet()) {
                this.failedSensors.put(key, this.metrics.sensor("authorizer-authorization-failed-" + FAILED_AUTH_MAP.get((Object)key)));
                this.failedSensors.get((Object)key).add(this.metrics.metricName(AUTHORIZER_ERROR_RATE_MINUTE, GROUP_NAME, "Authorization failed count", new String[]{"error-type", FAILED_AUTH_MAP.get((Object)key)}), (MeasurableStat)new Rate(TimeUnit.MINUTES));
            }
        }

        final void addAuthLatencyMetrics() {
            MetricName authLatencyP90 = this.metrics.metricName(AUTHORIZER_AUTHORIZATION_LATENCY_METRIC_P90, GROUP_NAME, "Authorizer Authorization latency ms p90", Collections.emptyMap());
            MetricName authLatencyP99 = this.metrics.metricName(AUTHORIZER_AUTHORIZATION_LATENCY_METRIC_P99, GROUP_NAME, "Authorizer Authorization latency ms p99", Collections.emptyMap());
            Percentile p90 = new Percentile(authLatencyP90, 90.0);
            Percentile p99 = new Percentile(authLatencyP99, 99.0);
            double maxTotalTimeMs = 30000.0;
            int totalBucketSizeInBytes = (int)maxTotalTimeMs * 4;
            Percentiles percentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{p90, p99});
            this.authorizationLatencySensor.add((CompoundStat)percentiles);
        }

        AuthorizerMetrics(Time time) {
            this(new Metrics(time), time);
        }

        void recordAuthorizerMetrics(List<AuthorizeResult> results, List<Action> actions, long opStartTimeMs) {
            long deniedCount;
            long timeMs = this.time.milliseconds();
            int resultsCount = results.size();
            this.authorizationLatencySensor.record((double)(timeMs - opStartTimeMs), timeMs, false);
            this.authorizationRequestSensor.record((double)resultsCount, timeMs, false);
            long allowedCount = results.stream().filter(r -> r == AuthorizeResult.ALLOWED).count();
            if (allowedCount > 0L) {
                this.authorizationAllowedSensor.record((double)allowedCount, timeMs, false);
            }
            if ((deniedCount = (long)resultsCount - allowedCount) > 0L) {
                this.authorizationDeniedSensor.record((double)deniedCount, timeMs, false);
            }
            int requestDeniedCount = 0;
            for (int i = 0; i < results.size(); ++i) {
                if (results.get(i) == AuthorizeResult.ALLOWED || !actions.get(i).logIfDenied()) continue;
                ++requestDeniedCount;
            }
            if (requestDeniedCount > 0) {
                this.authorizationRequestDeniedSensor.record((double)requestDeniedCount, timeMs, false);
            }
            int authorizerResourceFilterCount = 0;
            for (int i = 0; i < results.size(); ++i) {
                if (results.get(i) != AuthorizeResult.DENIED || actions.get(i).logIfDenied()) continue;
                ++authorizerResourceFilterCount;
            }
            if (authorizerResourceFilterCount > 0) {
                this.authorizerResourceFilterSensor.record((double)authorizerResourceFilterCount, timeMs, false);
            }
            EnumMap<AuthorizeResult, Integer> errStats = new EnumMap<AuthorizeResult, Integer>(AuthorizeResult.class);
            for (AuthorizeResult result : results) {
                if (!FAILED_AUTH_MAP.containsKey((Object)result)) continue;
                if (!errStats.containsKey((Object)result)) {
                    errStats.put(result, 0);
                }
                errStats.put(result, (Integer)errStats.get((Object)result) + 1);
            }
            for (AuthorizeResult key : errStats.keySet()) {
                this.failedSensors.get((Object)key).record((double)((Integer)errStats.get((Object)key)).intValue(), timeMs, false);
            }
        }

        public Metrics metrics() {
            return this.metrics;
        }

        Time metricsTime() {
            return this.time;
        }
    }
}

