/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Objects;
import org.apache.kafka.common.resource.PatternType;

public class ResourcePatternFilter {
    private final String name;
    private final ResourceType resourceType;
    private final PatternType patternType;

    public ResourcePatternFilter(@JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="name") String name, @JsonProperty(value="patternType") PatternType patternType) {
        this.name = name;
        this.resourceType = resourceType == null ? ResourceType.ALL : resourceType;
        this.patternType = patternType == null ? PatternType.ANY : patternType;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public ResourceType resourceType() {
        return this.resourceType;
    }

    @JsonProperty
    public PatternType patternType() {
        return this.patternType;
    }

    public boolean matches(ResourcePattern resource) {
        if (this.resourceType() != ResourceType.ALL && !this.resourceType().equals((Object)resource.resourceType())) {
            return false;
        }
        org.apache.kafka.common.resource.ResourceType unusedResourceType = org.apache.kafka.common.resource.ResourceType.TOPIC;
        org.apache.kafka.common.resource.ResourcePatternFilter filter = new org.apache.kafka.common.resource.ResourcePatternFilter(unusedResourceType, this.name(), this.patternType());
        org.apache.kafka.common.resource.ResourcePattern pattern = new org.apache.kafka.common.resource.ResourcePattern(unusedResourceType, resource.name(), resource.patternType());
        return filter.matches(pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePatternFilter)) {
            return false;
        }
        ResourcePatternFilter that = (ResourcePatternFilter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.patternType, that.patternType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceType, this.patternType);
    }

    public String toString() {
        return String.format("%s:%s:%s", this.resourceType, this.patternType, this.name);
    }
}

