/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.spiffe.bundle.jwtbundle.JwtBundle;
import io.spiffe.exception.AuthorityNotFoundException;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.exception.InvalidSpiffeIdException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.workloadapi.JwtSource;
import java.security.Key;
import java.util.List;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpireVerificationKeyResolver
implements VerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(SpireVerificationKeyResolver.class);
    private final JwtSource jwtSource;
    private final String spireIssuerSuffix;

    public SpireVerificationKeyResolver(JwtSource jwtSource, String spireIssuerSuffix) {
        this.jwtSource = jwtSource;
        this.spireIssuerSuffix = spireIssuerSuffix;
    }

    public String getSpireIssuerSuffix() {
        return this.spireIssuerSuffix;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        String subject;
        JwtClaims jwtClaims;
        try {
            jwtClaims = JwtClaims.parse((String)jws.getUnverifiedPayload());
        }
        catch (InvalidJwtException e) {
            throw new UnresolvableKeyException("Cannot parse the JWS payload with error", (Throwable)e);
        }
        String issuer = this.checkIssuerClaim(jwtClaims);
        if (!issuer.contains(this.spireIssuerSuffix)) {
            throw new UnresolvableKeyException("Token issuer: " + issuer + " is not SPIRE");
        }
        try {
            subject = jwtClaims.getSubject();
            if (subject == null || subject.isEmpty()) {
                throw new MalformedClaimException("Unable to find subject field in the token with header");
            }
        }
        catch (MalformedClaimException e) {
            log.debug("Unable to find subject field in the token with header " + jws.getHeaders().getFullHeaderAsJsonString());
            throw new UnresolvableKeyException("Unable to get subject payload from jws with error", (Throwable)e);
        }
        JwtBundle jwtBundle = this.getTrustBundleFromTrustDomain(subject);
        String kid = jws.getHeaders().getStringHeaderValue("kid");
        if (kid == null || kid.isEmpty()) {
            log.debug("Unable to find kid field in the token with header " + jws.getHeaders().getFullHeaderAsJsonString());
            throw new UnresolvableKeyException("Unable to get kid in the JWS with header " + jws.getHeaders().getFullHeaderAsJsonString());
        }
        try {
            return jwtBundle.findJwtAuthority(kid);
        }
        catch (AuthorityNotFoundException e) {
            log.error("Unable to retrieve public key from SPIRE trust bundle");
            throw new UnresolvableKeyException("Unable to find a suitable verification key for JWS with header " + jws.getHeaders().getFullHeaderAsJsonString());
        }
    }

    private String checkIssuerClaim(JwtClaims jwtClaims) throws UnresolvableKeyException {
        try {
            String issuer = jwtClaims.getIssuer();
            if (issuer == null || issuer.isEmpty()) {
                throw new MalformedClaimException("Token missing issuer claim or empty issuer claim");
            }
            return issuer;
        }
        catch (MalformedClaimException e) {
            throw new UnresolvableKeyException("Cannot find issuer payload from jws with error", (Throwable)e);
        }
    }

    private JwtBundle getTrustBundleFromTrustDomain(String subject) throws UnresolvableKeyException {
        try {
            if (this.jwtSource == null) {
                throw new UnresolvableKeyException("Jwt source not initialized. Unable to get jwt bundle for subject " + SpiffeId.parse((String)subject));
            }
            return (JwtBundle)this.jwtSource.getBundleForTrustDomain(SpiffeId.parse((String)subject).getTrustDomain());
        }
        catch (InvalidSpiffeIdException e) {
            log.debug("Unable to parse the subject " + subject + " as SPIFFE ID");
            throw new UnresolvableKeyException("Unable to parse the subject " + subject + " as SPIFFE ID", (Throwable)e);
        }
        catch (BundleNotFoundException e) {
            log.debug("Unable to get jwt bundle from jwt source for subject " + SpiffeId.parse((String)subject));
            throw new UnresolvableKeyException("Unable to get jwt bundle from jwt source for subject " + SpiffeId.parse((String)subject), (Throwable)e);
        }
    }
}

