/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.output;

import com.github.rvesse.airline.io.AnsiControlCodes;
import com.github.rvesse.airline.io.output.OutputStreamControlTracker;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AnsiOutputStream
extends PrintStream {
    private final List<OutputStreamControlTracker> controls = new ArrayList<OutputStreamControlTracker>();

    public AnsiOutputStream(OutputStream output) {
        super(output);
    }

    public final void registerControl(OutputStreamControlTracker control) {
        if (control == null) {
            return;
        }
        this.controls.add(control);
    }

    public final void registerControls(OutputStreamControlTracker ... controls) {
        if (controls == null) {
            return;
        }
        OutputStreamControlTracker[] outputStreamControlTrackerArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStreamControlTracker control = outputStreamControlTrackerArray[n2];
            this.registerControl(control);
            ++n2;
        }
    }

    @Override
    public void write(int b) {
        this.applyAll();
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.applyAll();
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.applyAll();
        super.write(b, off, len);
    }

    protected final void applyAll() {
        try {
            for (OutputStreamControlTracker control : this.controls) {
                control.apply();
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void reset(boolean full) {
        this.resetAll();
        if (full) {
            try {
                super.write(AnsiControlCodes.getGraphicsResetCode().getBytes());
            }
            catch (IOException e) {
                this.setError();
            }
        }
    }

    @Override
    public void close() {
        this.resetAll();
        super.close();
    }

    protected final void resetAll() {
        try {
            for (OutputStreamControlTracker control : this.controls) {
                control.reset();
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }
}

