/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;

public enum Features {
    TEST_VERSION("test.feature.version", TestFeatureVersion.values());

    public static final Features[] FEATURES;
    public static final List<Features> PRODUCTION_FEATURES;
    public static final List<String> PRODUCTION_FEATURE_NAMES;
    private final String name;
    private final FeatureVersion[] featureVersions;

    private Features(String name, FeatureVersion[] featureVersions) {
        this.name = name;
        this.featureVersions = featureVersions;
    }

    public String featureName() {
        return this.name;
    }

    public FeatureVersion[] featureVersions() {
        return this.featureVersions;
    }

    public short latestProduction() {
        return this.defaultValue(MetadataVersion.LATEST_PRODUCTION);
    }

    public short latestTesting() {
        return this.featureVersions[this.featureVersions.length - 1].featureLevel();
    }

    public FeatureVersion fromFeatureLevel(short level, boolean allowUnstableFeatureVersions) {
        return Arrays.stream(this.featureVersions).filter(featureVersion -> featureVersion.featureLevel() == level && (allowUnstableFeatureVersions || level <= this.latestProduction())).findFirst().orElseThrow(() -> new IllegalArgumentException("No feature:" + this.featureName() + " with feature level " + level));
    }

    public static void validateVersion(FeatureVersion feature, Map<String, Short> features) {
        Short metadataVersion = features.get("confluent.metadata.version");
        if (feature.featureLevel() >= 1 && (metadataVersion == null || metadataVersion < MetadataVersion.IBP_3_3_IV0.confluentFeatureLevel())) {
            throw new IllegalArgumentException(feature.featureName() + " could not be set to " + feature.featureLevel() + " because it depends on metadata.version=104 (" + (Object)((Object)MetadataVersion.IBP_3_3_IV0) + ")");
        }
        for (Map.Entry<String, Short> dependency : feature.dependencies().entrySet()) {
            Short featureLevel = features.get(dependency.getKey());
            if (featureLevel != null && featureLevel >= dependency.getValue()) continue;
            throw new IllegalArgumentException(feature.featureName() + " could not be set to " + feature.featureLevel() + " because it depends on " + dependency.getKey() + " level " + dependency.getValue());
        }
    }

    public short defaultValue(MetadataVersion metadataVersion) {
        short level = 0;
        Iterator it = Arrays.stream(this.featureVersions).iterator();
        while (it.hasNext()) {
            FeatureVersion feature = (FeatureVersion)it.next();
            if (feature.bootstrapMetadataVersion().isLessThan(metadataVersion) || feature.bootstrapMetadataVersion().equals((Object)metadataVersion)) {
                level = feature.featureLevel();
                continue;
            }
            return level;
        }
        return level;
    }

    public static Map<String, Short> featureImplsToMap(List<FeatureVersion> features) {
        return features.stream().collect(Collectors.toMap(FeatureVersion::featureName, FeatureVersion::featureLevel));
    }

    static {
        Features[] enumValues = Features.values();
        FEATURES = Arrays.copyOf(enumValues, enumValues.length);
        PRODUCTION_FEATURES = Arrays.stream(FEATURES).filter(feature -> !feature.name.equals(TEST_VERSION.featureName())).collect(Collectors.toList());
        PRODUCTION_FEATURE_NAMES = PRODUCTION_FEATURES.stream().map(feature -> feature.name).collect(Collectors.toList());
    }
}

