/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.server.common.MetadataVersion;

public final class FinalizedFeatures {
    private final MetadataVersion metadataVersion;
    private final Map<String, Short> finalizedFeatures;
    private final long finalizedFeaturesEpoch;

    public static FinalizedFeatures fromKRaftVersion(MetadataVersion version) {
        return new FinalizedFeatures(version, Collections.emptyMap(), -1L, true);
    }

    public FinalizedFeatures(MetadataVersion metadataVersion, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch, boolean kraftMode) {
        this.metadataVersion = metadataVersion;
        this.finalizedFeatures = new HashMap<String, Short>(finalizedFeatures);
        this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
        if (kraftMode) {
            this.finalizedFeatures.put("confluent.metadata.version", metadataVersion.confluentFeatureLevel());
        } else {
            this.finalizedFeatures.remove("confluent.metadata.version");
        }
        this.finalizedFeatures.remove("metadata.version");
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public Map<String, Short> finalizedFeatures() {
        return this.finalizedFeatures;
    }

    public long finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(FinalizedFeatures.class)) {
            return false;
        }
        FinalizedFeatures other = (FinalizedFeatures)o;
        return this.metadataVersion == other.metadataVersion && this.finalizedFeatures.equals(other.finalizedFeatures) && this.finalizedFeaturesEpoch == other.finalizedFeaturesEpoch;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadataVersion, this.finalizedFeatures, this.finalizedFeaturesEpoch});
    }

    public String toString() {
        return "Features(metadataVersion=" + (Object)((Object)this.metadataVersion) + ", finalizedFeatures=" + this.finalizedFeatures + ", finalizedFeaturesEpoch=" + this.finalizedFeaturesEpoch + ")";
    }
}

