/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import com.google.common.collect.Lists;
import io.confluent.kafka.link.integration.TestRegionalMetadataClient;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.UserMetadata;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SaslAuthenticateRequestCallback;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.TestLogicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.TestPhysicalClusterMetadata;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import io.confluent.kafka.server.plugins.policy.CreateClusterLinkPolicy;
import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.utils.TestInfoUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateClusterLinksResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.datapolicy.DefaultDataPolicyStore;
import org.apache.kafka.server.interceptor.ConfluentCloudBrokerInterceptor;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:6"), @Tag(value="bazel:size:large")})
public class MultiTenantCLDefaultDataPolicyTest {
    public static final String SSL_KAFKA_CN = "kafka";
    private static final Logger log = LoggerFactory.getLogger(MultiTenantCLDefaultDataPolicyTest.class);
    private MultiTenantCluster sourceCluster;
    private MultiTenantCluster destCluster;
    private final String sourceLogicalCluster = "lkc-source";
    private final String destLogicalCluster = "lkc-dest";
    private final String linkName = "tenantLink";
    private final String topic = "linkedTopic";
    private int nextMessageIndex = 0;
    private final Map<String, String> sslConfigs = new HashMap<String, String>();

    public static Stream allCombinations() {
        return Stream.of(Arguments.of((Object[])new Object[]{"zk", "true"}), Arguments.of((Object[])new Object[]{"zk", "false"}), Arguments.of((Object[])new Object[]{"kraft", "true"}));
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.createSslStores("localhost", "required");
        this.sourceCluster = new MultiTenantCluster(testInfo, this.sslConfigs);
        this.destCluster = new MultiTenantCluster(testInfo, this.sslConfigs);
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.sourceCluster.shutdown();
            List<KafkaBroker> destBrokers = this.destCluster.physicalCluster.kafkaCluster().kafkaBrokers().stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.destCluster.shutdown();
            destBrokers.forEach(broker -> ((ClusterLinkManager)broker.clusterLinkManager()).ensureEmptyIfNoLinks());
        }
        finally {
            SecurityTestUtils.clearSecurityConfigs();
            KafkaTestUtils.verifyThreadCleanup();
        }
    }

    private void createSslStores(String certHostName, String sslClientAuth) throws Exception {
        CertStores certStores = new CertStores.Builder(true).cn(SSL_KAFKA_CN).addHostName(certHostName).build();
        Properties props = new Properties();
        BiConsumer<String, Object> copyEntry = (k, v) -> {
            if (v instanceof Password) {
                props.setProperty((String)k, ((Password)v).value());
            } else if (v instanceof List) {
                List listOfString = (List)v;
                props.setProperty((String)k, String.join((CharSequence)",", listOfString));
            } else if (v != null) {
                props.setProperty((String)k, (String)v);
            }
        };
        certStores.keyStoreProps().forEach(copyEntry);
        certStores.trustStoreProps().forEach(copyEntry);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.sslConfigs.put((String)k, (String)v)));
        this.sslConfigs.put("listener.name.external.ssl.client.auth", sslClientAuth);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDefaultDataPolicy(String quorum, boolean coordinator) throws Throwable {
        this.setUpClusters();
        this.destCluster.createDestClusterLinkResult(this.destCluster.admin, "tenantLink", this.sourceCluster, 1001).all().get();
        MultiTenantCLDefaultDataPolicyTest.waitFor(() -> this.destCluster.linkIdExists("tenantLink"), true, "Link was not created");
        this.testBasicMirroring();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDefaultDataPolicyDisabled(String quorum, boolean coordinator) throws Throwable {
        this.setUpClusters();
        this.sourceCluster.physicalCluster.brokerSessionUuids().forEach(brokerUuid -> DefaultDataPolicyStore.addPolicy((String)brokerUuid, (String)"env-test", (boolean)false));
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)this.destCluster.createDestClusterLinkResult(this.destCluster.admin, "tenantLink", this.sourceCluster, 1001).all().get();
        });
        Assertions.assertEquals(SaslAuthenticationException.class, e.getCause().getClass());
    }

    private Map<String, String> destBrokerProps() {
        HashMap<String, String> destBrokerOverrides = new HashMap<String, String>();
        destBrokerOverrides.put("confluent.traffic.network.id", "n-test-dest");
        destBrokerOverrides.put("confluent.regional.metadata.client.class", TestRegionalMetadataClient.class.getName());
        destBrokerOverrides.put("multitenant.metadata.class", TestPhysicalClusterMetadata.class.getName());
        destBrokerOverrides.put("confluent.cluster.link.intranet.connectivity.enable", Boolean.TRUE.toString());
        destBrokerOverrides.put(KafkaConfig.SaslEnabledMechanismsProp(), "PLAIN");
        destBrokerOverrides.put("confluent.ccloud.host.suffixes", "localhost");
        destBrokerOverrides.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.multitenant.integration.cluster.TestPlainLoginModule required;");
        return destBrokerOverrides;
    }

    private Map<String, String> srcBrokerProps() {
        HashMap<String, String> srcBrokerOverrides = new HashMap<String, String>();
        srcBrokerOverrides.put("confluent.traffic.network.id", "n-test-src");
        srcBrokerOverrides.put("multitenant.metadata.class", TestPhysicalClusterMetadata.class.getName());
        srcBrokerOverrides.put(KafkaConfig.SaslEnabledMechanismsProp(), "PLAIN");
        srcBrokerOverrides.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.multitenant.integration.cluster.TestPlainLoginModule required default_data_policy_validation_mode=\"strict\";");
        return srcBrokerOverrides;
    }

    private void setUpClusters() throws Exception {
        this.sourceCluster.startCluster(this.srcBrokerProps(), "lkc-source", 1);
        MultiTenantCLDefaultDataPolicyTest.addAcls((Admin)this.sourceCluster.admin, this.sourceCluster.user, new String[0]);
        this.destCluster.startCluster(this.destBrokerProps(), "lkc-dest", 11);
        MultiTenantCLDefaultDataPolicyTest.addAcls((Admin)this.destCluster.admin, this.destCluster.user, new String[0]);
    }

    private void testBasicMirroring() throws Throwable {
        NewTopic sourceTopic = new NewTopic("linkedTopic", Optional.empty(), Optional.of((short)1));
        this.sourceCluster.admin.createTopics(Collections.singleton(sourceTopic));
        MultiTenantCLDefaultDataPolicyTest.waitFor(() -> {
            try {
                return ((Map)this.sourceCluster.admin.listTopics().namesToListings().get()).containsKey("linkedTopic");
            }
            catch (Exception e) {
                return false;
            }
        }, true, "Failed to list topic");
        this.createMirrorTopicWaitForSuccess(this.destCluster.admin, "");
        int messageCount = 10;
        KafkaTestUtils.sendRecords(this.sourceCluster.getOrCreateProducerToInternalListener(), "lkc-source_linkedTopic", this.nextMessageIndex, messageCount);
        this.nextMessageIndex += messageCount;
        KafkaTestUtils.consumeRecords(this.destCluster.getOrCreateConsumerToExternalListener("destGroup"), "linkedTopic", 0, this.nextMessageIndex);
    }

    private void createMirrorTopicWaitForSuccess(ConfluentAdmin admin, String clusterLinkPrefix) throws Exception {
        NewTopic newTopic = new NewTopic(clusterLinkPrefix + "linkedTopic", Optional.empty(), Optional.of((short)1)).mirror(Optional.of(new NewMirrorTopic("tenantLink", "linkedTopic")));
        CreateTopicsOptions option = new CreateTopicsOptions().timeoutMs(Integer.valueOf(5000));
        TestUtils.waitForCondition(() -> {
            try {
                admin.createTopics(Collections.singleton(newTopic), option).all().get();
                return true;
            }
            catch (Throwable e) {
                log.error("Failed to create mirror topic {}", (Object)newTopic, (Object)e);
                return false;
            }
        }, (String)"Failed to create mirror");
    }

    private static Set<AclBinding> addAcls(Admin adminClient, LogicalClusterUser user, String ... prefixes) throws Exception {
        String principal = user.unprefixedKafkaPrincipal().toString();
        AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "linked", PatternType.PREFIXED), new AccessControlEntry(principal, "*", AclOperation.ALL, AclPermissionType.ALLOW));
        AclBinding topicAclWithPrefix = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "src_linked", PatternType.PREFIXED), new AccessControlEntry(principal, "*", AclOperation.ALL, AclPermissionType.ALLOW));
        AclBinding clusterAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding groupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.READ, AclPermissionType.ALLOW));
        Set acls = Utils.mkSet((Object[])new AclBinding[]{topicAcl, groupAcl, clusterAcl, topicAclWithPrefix});
        for (String prefix : prefixes) {
            acls.add(new AclBinding(new ResourcePattern(ResourceType.TOPIC, prefix, PatternType.PREFIXED), new AccessControlEntry(principal, "*", AclOperation.ALL, AclPermissionType.ALLOW)));
        }
        adminClient.createAcls((Collection)acls).all().get(15L, TimeUnit.SECONDS);
        return acls;
    }

    private static <T> void waitFor(Supplier<T> actual, T expected, String error) throws Exception {
        TestUtils.waitForCondition(() -> expected.equals(actual.get()), () -> error + " : expected=" + expected + ", actual=" + actual.get());
    }

    public static class MultiTenantCluster
    extends IntegrationTestHarness {
        private final Map<String, String> sslConfigs;
        private PhysicalCluster physicalCluster;
        private LogicalCluster logicalCluster;
        private LogicalClusterUser user;
        private LogicalClusterUser linkUser;
        private ConfluentAdmin admin;
        KafkaProducer<String, String> producerToInternalListener;
        KafkaConsumer<String, String> consumerToExternalListener;

        public MultiTenantCluster(TestInfo testInfo, Map<String, String> sslConfigs) {
            super(testInfo);
            this.sslConfigs = sslConfigs;
        }

        void startCluster(Map<String, String> brokerAndControllerOverrideProps, String logicalClusterId, int userId) {
            Properties brokerProps = this.brokerProps();
            brokerProps.putAll(this.sslConfigs);
            brokerProps.putAll(brokerAndControllerOverrideProps);
            brokerProps.setProperty("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:SASL_SSL");
            Properties controllerProps = this.brokerProps();
            controllerProps.putAll(brokerAndControllerOverrideProps);
            this.physicalCluster = this.start(brokerProps, controllerProps, true, Optional.of(Time.SYSTEM), cluster -> {});
            TestLogicalClusterMetadata testLkcMetadata = new TestLogicalClusterMetadata(logicalClusterId, "org-test", "env-test");
            this.physicalCluster.brokerSessionUuids().forEach(brokerUuid -> {
                TestPhysicalClusterMetadata pkcMetadata = (TestPhysicalClusterMetadata)TestPhysicalClusterMetadata.getInstance((String)brokerUuid);
                pkcMetadata.addLogicalCluster(testLkcMetadata);
            });
            this.physicalCluster.brokerSessionUuids().forEach(brokerUuid -> DefaultDataPolicyStore.addPolicy((String)brokerUuid, (String)"env-test", (boolean)true));
            this.logicalCluster = this.physicalCluster.createLogicalCluster(logicalClusterId, 100, userId);
            this.user = this.logicalCluster.user(userId);
            Properties clientProps = new Properties();
            clientProps.putAll(this.sslConfigs);
            DefaultDataPolicyContext policyContext = new DefaultDataPolicyContext.Builder("env-test", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build();
            SaslAuthenticateRequestCallback requestCallback = new SaslAuthenticateRequestCallback(policyContext);
            this.admin = (ConfluentAdmin)super.createAdminClient(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_SSL, "PLAIN", this.logicalCluster.adminUser().testPlainSaslJaasConfig(), clientProps, requestCallback, null);
        }

        private Properties brokerProps() {
            Properties props = new Properties();
            props.put("confluent.cluster.link.enable", "true");
            props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
            props.put("confluent.plugins.topic.policy.replication.factor", "1");
            props.put("auto.create.topics.enable", "false");
            props.put("client.quota.callback.class", TenantQuotaCallback.class.getName());
            props.put("password.encoder.secret", "multi-tenant-cluster-link-secret");
            props.put("create.topic.policy.class.name", CreateTopicPolicy.class.getName());
            props.put("alter.config.policy.class.name", AlterConfigPolicy.class.getName());
            props.put("create.cluster.link.policy.class.name", CreateClusterLinkPolicy.class.getName());
            props.put("listener.name.internal.broker.interceptor.class", ConfluentCloudBrokerInterceptor.class.getName());
            if (TestInfoUtils.isKRaft((TestInfo)this.testInfo)) {
                props.put("confluent.cluster.link.metadata.topic.enable", "true");
                props.put("confluent.cluster.link.metadata.topic.replication.factor", "1");
                props.put("confluent.cluster.link.metadata.topic.partitions", "3");
            }
            if (this.testRunsWithLinkCoordinator()) {
                props.put("confluent.cluster.link.metadata.topic.enable", "true");
                props.put("confluent.cluster.link.metadata.topic.partitions", "1");
                props.put("confluent.cluster.link.metadata.topic.replication.factor", "1");
                props.put("confluent.cluster.link.metadata.topic.min.isr", "1");
            }
            return props;
        }

        private boolean testRunsWithLinkCoordinator() {
            return this.testInfo.getDisplayName().contains("coordinator=true");
        }

        LogicalClusterUser createLinkUser(int newUserId) throws Exception {
            UserMetadata newUser = this.physicalCluster.getOrCreateUser(newUserId, false);
            LogicalClusterUser linkUser = this.logicalCluster.addUser(newUser);
            Set<AclBinding> acls = this.linkAcls(linkUser);
            this.addLinkAcls(acls);
            MultiTenantCluster.waitForAclsToExistOnAllBrokers(this.physicalCluster, acls, linkUser.tenantPrefix());
            return linkUser;
        }

        private static void waitForAclsToExistOnAllBrokers(PhysicalCluster cluster, Set<AclBinding> acls, String tenantPrefix) {
            kafka.utils.TestUtils.waitUntilTrue(() -> cluster.kafkaCluster().kafkaBrokers().stream().allMatch(b -> {
                if (b.authorizer().isEmpty()) {
                    return false;
                }
                Collection<AclBinding> currAcls = MultiTenantCluster.removeTenantPrefix(Lists.newArrayList((Iterable)((Authorizer)b.authorizer().get()).acls(AclBindingFilter.ANY)), tenantPrefix);
                return currAcls.containsAll(acls);
            }), () -> "Failed to validate all ACLs exist on all brokers", (long)15000L, (long)100L);
        }

        private static Collection<AclBinding> removeTenantPrefix(Collection<AclBinding> acls, String tenantPrefix) {
            return acls.stream().map(acl -> {
                AccessControlEntry currEntry = acl.entry();
                if (currEntry.principal().contains(tenantPrefix)) {
                    String principal = currEntry.principal().replaceFirst(tenantPrefix, "").replaceFirst("TenantUser", "User");
                    ResourcePattern currPattern = acl.pattern();
                    ResourcePattern mappedPattern = currPattern.name().equals(tenantPrefix) && currPattern.patternType().equals((Object)PatternType.PREFIXED) ? new ResourcePattern(currPattern.resourceType(), "*", PatternType.LITERAL) : new ResourcePattern(currPattern.resourceType(), currPattern.name().replaceFirst(tenantPrefix, ""), currPattern.patternType());
                    return new AclBinding(mappedPattern, new AccessControlEntry(principal, currEntry.host(), currEntry.operation(), currEntry.permissionType(), currEntry.clusterLinkIds()));
                }
                return new AclBinding(acl.pattern(), acl.entry());
            }).collect(Collectors.toList());
        }

        private Map<String, String> clientConfigsForExternalListener() {
            Properties props = KafkaTestUtils.securityProps(this.physicalCluster.kafkaCluster().bootstrapServers(), SecurityProtocol.SASL_SSL, "PLAIN", this.linkUser.saslJaasConfig());
            HashMap<String, String> clientConfigs = new HashMap<String, String>();
            props.stringPropertyNames().forEach(name -> clientConfigs.put((String)name, props.getProperty((String)name)));
            clientConfigs.putAll(this.sslConfigs);
            return clientConfigs;
        }

        CreateClusterLinksResult createDestClusterLinkResult(ConfluentAdmin admin, String linkName, MultiTenantCluster sourceCluster, int linkUserId) throws Throwable {
            HashMap<String, String> linkConfigs = new HashMap<String, String>();
            sourceCluster.linkUser = sourceCluster.createLinkUser(linkUserId);
            linkConfigs.putAll(sourceCluster.clientConfigsForExternalListener());
            linkConfigs.put("request.timeout.ms", "1000");
            linkConfigs.put(ClusterLinkConfig.TopicConfigSyncMsProp(), "1000");
            String sourceClusterId = sourceCluster.logicalCluster.logicalClusterId();
            NewClusterLink newClusterLink = new NewClusterLink(linkName, sourceClusterId, linkConfigs, null);
            CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(false).validateLink(true);
            return admin.createClusterLinks(Collections.singleton(newClusterLink), options);
        }

        KafkaProducer<String, String> getOrCreateProducerToInternalListener() {
            if (this.producerToInternalListener == null) {
                Properties clientProps = new Properties();
                clientProps.putAll(this.sslConfigs);
                this.producerToInternalListener = this.createProducer(SecurityProtocol.PLAINTEXT, "", "", Optional.of("INTERNAL"), clientProps);
            }
            return this.producerToInternalListener;
        }

        KafkaConsumer<String, String> getOrCreateConsumerToExternalListener(String groupId) {
            if (this.consumerToExternalListener == null) {
                Properties clientProps = new Properties();
                clientProps.putAll(this.sslConfigs);
                this.consumerToExternalListener = this.createConsumer(this.user, groupId, SecurityProtocol.SASL_SSL, "PLAIN", Optional.empty(), clientProps);
            }
            return this.consumerToExternalListener;
        }

        private void addLinkAcls(Set<AclBinding> acls) throws Exception {
            this.admin.createAcls(acls).all().get(15L, TimeUnit.SECONDS);
        }

        private Set<AclBinding> linkAcls(LogicalClusterUser user) {
            String principal = user.unprefixedKafkaPrincipal().toString();
            AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "linked", PatternType.PREFIXED), new AccessControlEntry(principal, "*", AclOperation.READ, AclPermissionType.ALLOW));
            AclBinding topicConfigAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "linked", PatternType.PREFIXED), new AccessControlEntry(principal, "*", AclOperation.DESCRIBE_CONFIGS, AclPermissionType.ALLOW));
            AclBinding clusterAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
            AclBinding clusterDescribeConfigsAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.DESCRIBE_CONFIGS, AclPermissionType.ALLOW));
            AclBinding groupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.READ, AclPermissionType.ALLOW));
            Set acls = Utils.mkSet((Object[])new AclBinding[]{topicAcl, topicConfigAcl, groupAcl, clusterAcl, clusterDescribeConfigsAcl});
            return acls;
        }

        ClusterLinkFactory.LinkManager linkManager() {
            return this.physicalCluster.kafkaCluster().kafkaBrokers().get(0).clusterLinkManager();
        }

        boolean linkIdExists(String linkName) {
            ClusterLinkFactory.LinkManager linkManager = this.linkManager();
            return linkManager.listClusterLinks().find(d -> d.linkName().equals(this.user.tenantPrefix() + linkName)).isDefined();
        }
    }
}

