/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.server.DataFlowPolicy;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.Subscription;
import kafka.server.Watch;
import scala.Option;
import scala.Some;

public class TestRegionalMetadataClient
implements RegionalMetadataClient {
    private static final Map<String, String> BOOTSTRAP_SERVERS_BY_LKC = new HashMap<String, String>();
    private static final Map<String, Boolean> OPT_IN_BY_LKC = new HashMap<String, Boolean>();
    private final String networkId = UUID.randomUUID().toString();

    static void seedBootstrapServers(String organizationId, String environmentId, String lkc, String bootstrapServers) {
        BOOTSTRAP_SERVERS_BY_LKC.put(String.format("%s/%s/%s", organizationId, environmentId, lkc), bootstrapServers);
    }

    static void clearBootstrapServers() {
        BOOTSTRAP_SERVERS_BY_LKC.clear();
    }

    static void seedOptIn(String organizationId, String environmentId, Boolean optIn) {
        OPT_IN_BY_LKC.put(String.format("%s/%s", organizationId, environmentId), optIn);
    }

    static void clearOptIn() {
        OPT_IN_BY_LKC.clear();
    }

    public CompletableFuture<Option<RegionalLkcMetadata>> getLkcMetadata(final String organizationId, final String environmentId, final String clusterId) {
        RegionalLkcMetadata metadata = new RegionalLkcMetadata(){

            public String organizationId() {
                return "";
            }

            public String environmentId() {
                return "";
            }

            public String networkId() {
                return TestRegionalMetadataClient.this.networkId;
            }

            public String intranetFqdn() {
                return (String)BOOTSTRAP_SERVERS_BY_LKC.get(String.format("%s/%s/%s", organizationId, environmentId, clusterId));
            }

            public boolean isActive() {
                return true;
            }

            public boolean isMultiTenant() {
                return true;
            }
        };
        return CompletableFuture.completedFuture(new Some((Object)metadata));
    }

    public CompletableFuture<Option<RegionalNetworkMetadata>> getNetworkMetadata(String organizationId, String environmentId, final String networkId) {
        RegionalNetworkMetadata metadata = new RegionalNetworkMetadata(){

            public String networkId() {
                return networkId;
            }

            public boolean isPrivate() {
                return true;
            }
        };
        return CompletableFuture.completedFuture(new Some((Object)metadata));
    }

    public CompletableFuture<Option<DataFlowPolicy>> getDataFlowPolicy(final String organizationId, final String environmentId) {
        DataFlowPolicy dataPolicy = new DataFlowPolicy(){

            public String environmentId() {
                return environmentId;
            }

            public boolean envWideBoundary() {
                return OPT_IN_BY_LKC.getOrDefault(String.format("%s/%s", organizationId, environmentId), true);
            }
        };
        return CompletableFuture.completedFuture(new Some((Object)dataPolicy));
    }

    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        return null;
    }

    public void close() throws IOException {
    }

    public void configure(Map<String, ?> configs) {
    }
}

