/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiTenantInterceptorTest {
    private void callOnApiVersionsRequest(MultiTenantInterceptor interceptor, String clientId, Metrics metrics) {
        ClientInformation clientInformation = new ClientInformation("software-name", "software-version");
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("user", "saslAuthenticationId", new TenantMetadata("tenantName", "clusterId", "organizationId", "environmentId", "userResourceID", true, true, true));
        interceptor.onApiVersionsRequest(clientInformation, clientId, (KafkaPrincipal)multiTenantPrincipal, metrics);
    }

    private Map<String, Object> defaultConfig() {
        return new HashMap<String, Object>(){
            {
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
                this.put("confluent.schema.validator.multitenant.enable", false);
                this.put("confluent.multitenant.interceptor.balancer.apis.enabled", false);
                this.put("confluent.multitenant.listener.hostname.subdomain.suffix.enable", ConfluentConfigs.MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT);
                this.put("confluent.valid.broker.rack.set", ConfluentConfigs.VALID_BROKER_RACK_SET_DEFAULT);
                this.put("confluent.subdomain.separator.map", ConfluentConfigs.SUBDOMAIN_SEPARATOR_MAP_DEFAULT);
                this.put("confluent.subdomain.separator.variable", "%sep");
                this.put("confluent.fetch.from.follower.require.leader.epoch.enable", false);
                this.put("confluent.broker.limit.producer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT);
                this.put("confluent.broker.limit.consumer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT);
                this.put("confluent.hot.partition.ratio", 0.8);
                this.put("group.coordinator.new.enable", false);
            }
        };
    }

    @Test
    public void testRecordApiVersionsRequests() {
        MultiTenantInterceptor interceptor = new MultiTenantInterceptor();
        Metrics metrics = new Metrics();
        Map<String, Object> disabledConfig = this.defaultConfig();
        disabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", false);
        interceptor.configure(disabledConfig);
        this.callOnApiVersionsRequest(interceptor, "should-not-be-logged", metrics);
        Assertions.assertTrue((boolean)metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when feature is gated");
        metrics.close();
        interceptor = new MultiTenantInterceptor();
        metrics = new Metrics();
        interceptor.configure(this.defaultConfig());
        this.callOnApiVersionsRequest(interceptor, "should-not-be-logged", metrics);
        Assertions.assertTrue((boolean)metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when the config value isn't specified (default is false)");
        interceptor = new MultiTenantInterceptor();
        metrics = new Metrics();
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        interceptor.configure(enabledConfig);
        this.callOnApiVersionsRequest(interceptor, "foobar", metrics);
        List matches = metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertTrue((matches.size() > 0 ? 1 : 0) != 0, (String)"Metric should be logged when config option is true");
        Assertions.assertTrue((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("foobar")), (String)"Can't find the logged client-id");
        metrics.close();
    }
}

