/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.UserTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Tag;
import net.jqwik.api.constraints.AlphaChars;
import net.jqwik.api.constraints.Chars;
import net.jqwik.api.constraints.NumericChars;
import net.jqwik.api.constraints.StringLength;
import net.jqwik.api.lifecycle.AfterContainer;
import net.jqwik.api.lifecycle.BeforeContainer;
import net.jqwik.api.lifecycle.BeforeProperty;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.ConfluentBrokenPrincipalData;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

@Tag(value="propertybased")
public class MultiTenantPrincipalBuilderTestPBT {
    private static final String BROKER_UUID = UUID.randomUUID().toString();
    private static final Map<String, Object> CONFIGS = new HashMap<String, Object>();
    public static final Path TEMP_DIR = TestUtils.tempDirectory().toPath();
    private static PhysicalClusterMetadata metadata;

    @BeforeContainer
    public static void setUp() throws Exception {
        MultiTenantPrincipalBuilderTestPBT.setUpPhysicalMetadata();
    }

    @AfterContainer
    public static void tearDown() throws Exception {
        metadata.close(BROKER_UUID);
    }

    @BeforeProperty
    public void clearConfig() {
        CONFIGS.remove("multitenant.oauth.superuser.disable");
        CONFIGS.remove("confluent.metadata.kafka.enable.dataplane.rbac");
    }

    private static void setUpPhysicalMetadata() throws IOException, InterruptedException {
        CONFIGS.put("principal.builder.class", MultiTenantPrincipalBuilder.class);
        CONFIGS.put("broker.session.uuid", BROKER_UUID);
        CONFIGS.put("multitenant.metadata.dir", TEMP_DIR.toRealPath(new LinkOption[0]));
        CONFIGS.put("node.id", "0");
        metadata = Utils.initiatePhysicalClusterMetadata(CONFIGS);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_1, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_HEALTHCHECK, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_LINK_HEALTHCHECK, TEMP_DIR);
        TestUtils.waitForCondition(() -> metadata.metadata(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
    }

    @Property(tries=5000)
    public void testBrokenSchemaFailsParsing(@ForAll @StringLength(min=1) @StringLength(min=1) String username, @ForAll @StringLength(min=1) @AlphaChars @NumericChars @Chars(value={46, 45}) @StringLength(min=1) @AlphaChars @NumericChars @Chars(value={46, 45}) String tenant, @ForAll @StringLength(min=1) @StringLength(min=1) String clusterId, @ForAll String saslAuthenticationId, @ForAll boolean isTokenAuthenticated, @ForAll String organizationId, @ForAll String environmentId, @ForAll String userResourceId, @ForAll boolean isServiceAccount, @ForAll boolean isApiKeyAuthenticated, @ForAll boolean isHealthcheckTenant) {
        ConfluentBrokenPrincipalData data = new ConfluentBrokenPrincipalData().setType("TenantUser").setName(username).setTokenAuthenticated(isTokenAuthenticated).setTenantName(tenant).setClusterId(clusterId).setOrganizationId(organizationId).setEnvironmentId(environmentId).setServiceAccount(isServiceAccount).setApiKeyAuthenticated(isApiKeyAuthenticated).setHealthcheckTenant(isHealthcheckTenant).setUserResourceId(userResourceId).setSaslAuthenticationId(saslAuthenticationId);
        byte[] principalBytes = MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
        UserTenantPrincipalBuilder builder = new UserTenantPrincipalBuilder();
        Assertions.assertThrows(SerializationException.class, () -> builder.deserialize(principalBytes));
    }
}

