/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Exit;

public class RestoreAclsForLkc {
    public static void main(String[] args) {
        if (args.length == 1 && (args[0].equals("--h") || args[0].equals("--help"))) {
            System.out.println("Pass BOOTSTRAP_SERVER_CONFIG as first argument\nPass LKC_ID as second argument");
            Exit.exit((int)0);
        }
        if (args.length < 2) {
            System.out.println("Pass atleast 2 arguments. Bootstrap and lkc-id");
            Exit.exit((int)0);
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", args[0]);
        String lkcid = args[1];
        System.out.println("ACLs will be restored for the following LKC : \n" + lkcid);
        try (AdminClient adminClient = AdminClient.create((Properties)props);){
            AclBindingFilter filter = RestoreAclsForLkc.getFilter(lkcid);
            Collection inactiveAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            adminClient.createAcls(inactiveAcls).all().get();
            ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), Collections.singletonList(filter), (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.DELETED).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AclBindingFilter getFilter(String lkcId) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, lkcId + "_", PatternType.CONFLUENT_ALL_TENANT_ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY));
    }
}

