/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.SpiffeIdPrincipalExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpiffeIdPrincipalExtractorTest {
    @Test
    public void testRules() {
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)$!$3!", 1);
        this.testValidRules("RULE:spiffe://   !  $1$2 !", 1);
        this.testValidRules("RULE:spiffe://   ! abc ! L", 1);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$3.$2!U", 1);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!abc!L", 1);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!!U", 0);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!!U,\nRULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!abc!L", 1);
        this.testValidRules("Rule:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)$!$3!", 0);
        this.testValidRules("RULE:spiffeid://(.*?)/v1/physical/k8s-(.*?)/(.*?)$!$3!", 0);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)$!$3", 0);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)$", 0);
        this.testValidRules("RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$2!U,\nRule:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)$", 1);
    }

    private void testValidRules(String rules, int rulesCount) {
        SpiffeIdPrincipalExtractor spiffeIdPrincipalExtractor = SpiffeIdPrincipalExtractor.fromRules((String)rules);
        Assertions.assertEquals((int)rulesCount, (int)spiffeIdPrincipalExtractor.principalExtractionRulesCount());
    }

    private void testRulesSplitting(String expected, String rules) {
        SpiffeIdPrincipalExtractor spiffeIdPrincipalExtractor = SpiffeIdPrincipalExtractor.fromRules((String)rules);
        Assertions.assertEquals((Object)String.format("SpiffeIdPrincipalExtractor(rules = %s)", expected), (Object)spiffeIdPrincipalExtractor.toString());
    }

    @Test
    public void testRulesSplitting() {
        this.testRulesSplitting("[]", "");
        this.testRulesSplitting("[]", ", ,, , ,,,");
        this.testRulesSplitting("[]", " , ,,RULE:spiffe://!!, ");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!]", " ,RULE:spiffe://abc!$1!, , ,");
        this.testRulesSplitting("[]", "RULE:spiffe://!!");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!]", "RULE:spiffe://!!, RULE:spiffe://abc!$1!");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!L]", "RULE:spiffe://!$2!, RULE:spiffe://abc!$1!L");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!L]", "RULE:spiffe://!$2!, , RULE:spiffe://abc!$1!L   , ,");
        this.testRulesSplitting("[]", "RULE:spiffe://abc!!");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!]", "RULE:spiffe://abc!!, RULE:spiffe://abc!$1!, rulE:spiff://!!");
        this.testRulesSplitting("[RULE:spiffe://abc!$1!U]", "RULE:spiffe://abc!!, RULE:spiffe://abc!$1!U");
        this.testRulesSplitting("[RULE:spiffe://\\/\\\\\\(\\*ab\\)\\n\\t/!\\$1\\*/!]", "RULE:spiffe://\\/\\\\\\(\\*ab\\)\\n\\t/!\\$1\\*/!");
        this.testRulesSplitting("[RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$3!, RULE:spiffe://(.*?)/v2/physical/k8s-(.*?)/pkc-(.*?)/(.*?)!$3.$4!L, RULE:spiffe://(.*?)/v3/physical/(k8s-.*?)/(pkc-.*?)/(.*?)!$2.$3.$4!U]", "RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$3!, \nRULE:spiffe://(.*?)/v2/physical/k8s-(.*?)/pkc-(.*?)/(.*?)!$3.$4!L, \nRULE:spiffe://(.*?)/v3/physical/(k8s-.*?)/(pkc-.*?)/(.*?)!$2.$3.$4!U");
        this.testRulesSplitting("[RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$3!, RULE:spiffe://(.*?)/v2/physical/k8s-(.*?)/pkc-(.*?)/(.*?)!$3.$4!L, RULE:spiffe://(.*?)/v3/physical/(k8s-.*?)/(pkc-.*?)/(.*?)!$2.$3.$4!U]", "RULE:spiffe://(.*?)/v1/physical/k8s-(.*?)/(.*?)!$3!, \nRule:spiffe://(.*?)/v3/physical/(k8s-.*?)/(pkc-.*?)/(.*?)!$4!L,  \nRULE:spiffe://(.*?)/v2/physical/k8s-(.*?)/pkc-(.*?)/(.*?)!$3.$4!L, \n  ,   \nRULE:spiffe://(.*?)/v3/physical/(k8s-.*?)/(pkc-.*?)/(.*?)!$2.$3.$4!U");
    }

    @Test
    public void testSpiffeIdPrincipalMapper() {
        String rules = String.join((CharSequence)", ", "RULE:spiffe://([^/]*?)/v1/physical/(k8s-[^/]*?)/([^/]*?)$!$3!", "RULE:spiffe://([^/]*?)/v2/physical/(k8s-[^/]*?)/(pkc-[^/]*?)/([^/]*?)$!$3.$4!L", "RULE:spiffe://([^/]*?)/v3/physical/(k8s-[^/]*?)/(pkc-[^/]*?)/([^/]*?)$!$2.$3.$4!U", "RULE:spiffe://([^/]*?)/v1/physical/(k8s-[^/]*?)/([^/]*?)$!$2_$3!");
        SpiffeIdPrincipalExtractor spiffeIdPrincipalExtractor = new SpiffeIdPrincipalExtractor(rules);
        Assertions.assertEquals((Object)"[sync-service, k8s-abcd_sync-service, spiffe://ex.trust.domain/v1/physical/k8s-abcd/sync-service]", (Object)spiffeIdPrincipalExtractor.extractPrincipals("spiffe://ex.trust.domain/v1/physical/k8s-abcd/sync-service").toString());
        Assertions.assertEquals((Object)"[pkc-def.audit-log-service, spiffe://ex.trust.domain/v2/physical/k8s-abcd/pkc-def/audit-log-service]", (Object)spiffeIdPrincipalExtractor.extractPrincipals("spiffe://ex.trust.domain/v2/physical/k8s-abcd/pkc-def/audit-log-service").toString());
        Assertions.assertEquals((Object)"[K8S-ABCD.PKC-DEF.AUDIT-LOG-SERVICE, spiffe://ex.trust.domain/v3/physical/k8s-abcd/pkc-def/audit-log-service]", (Object)spiffeIdPrincipalExtractor.extractPrincipals("spiffe://ex.trust.domain/v3/physical/k8s-abcd/pkc-def/audit-log-service").toString());
        Assertions.assertEquals((Object)"[spiffe://ex.trust.domain/v3/physical/k8s-abcd/audit-log-service/client-id-ds3]", (Object)spiffeIdPrincipalExtractor.extractPrincipals("spiffe://ex.trust.domain/v3/physical/k8s-abcd/audit-log-service/client-id-ds3").toString());
        Assertions.assertEquals((Object)"[spiffe://ex.trust.domain/v1/physical/k8s-abcd/pkc-def/audit-log-service]", (Object)spiffeIdPrincipalExtractor.extractPrincipals("spiffe://ex.trust.domain/v1/physical/k8s-abcd/pkc-def/audit-log-service").toString());
    }
}

