/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignor;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignorBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.assignor.ZkClusterDescriber;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.placement.CellDescriber;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.TenantDescriber;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;

public class TenantPartitionAssignorBuilderTest {
    Cluster cluster = new Cluster("", Collections.emptyList(), Collections.emptyList(), new HashSet(), new HashSet());
    CellDescriber cellDescriber = new CellDescriber(){};
    TenantDescriber tenantDescriber = new TenantDescriber(){};

    @Test
    public void testBuildAssignor() {
        MultiTenantPrincipal mtp = new MultiTenantPrincipal("tenant", new TenantMetadata("tenant1", "lkc-12345"));
        TenantPartitionAssignorBuilder builder = new TenantPartitionAssignorBuilder();
        builder.updateClusterDescriber(null);
        Optional assignorOptWithEmptyCluster = builder.maybeBuildAssignor(Optional.of(mtp), PartitionPlacementStrategy.CLUSTER_WIDE);
        Assertions.assertTrue((boolean)assignorOptWithEmptyCluster.isPresent(), (String)"expected the received replica assignor to be present");
        TenantPartitionAssignor assignor = (TenantPartitionAssignor)assignorOptWithEmptyCluster.get();
        Assertions.assertNotNull((Object)assignor, (String)"expected the received replica assignor to not be null");
        Assertions.assertNull((Object)assignor.cluster(), (String)"expected the assignor's cluster object to be null");
        ZkClusterDescriber clusterDescriber = new ZkClusterDescriber(this.cluster, this.cellDescriber, this.tenantDescriber);
        builder.updateClusterDescriber((ClusterDescriber)clusterDescriber);
        Optional assignorOpt = builder.maybeBuildAssignor(Optional.of(mtp), PartitionPlacementStrategy.CLUSTER_WIDE);
        Assertions.assertTrue((boolean)assignorOpt.isPresent(), (String)"expected to receive a non-empty optional with the assignor");
        assignor = (TenantPartitionAssignor)assignorOpt.get();
        Assertions.assertNotNull((Object)assignor, (String)"expected the received replica assignor to not be null");
        Assertions.assertTrue((clusterDescriber == assignor.cluster() ? 1 : 0) != 0);
    }

    @Test
    public void testBuildAssignorReturnsEmptyOptionalWhenNullOrNonMultiTenantPrincipalArgumentsGiven() {
        TenantPartitionAssignorBuilder builder = new TenantPartitionAssignorBuilder();
        Optional emptyPrincipalOpt = builder.maybeBuildAssignor(Optional.empty(), PartitionPlacementStrategy.CLUSTER_WIDE);
        Assertions.assertFalse((boolean)emptyPrincipalOpt.isPresent(), (String)"Expected an empty optional due to using an empty principal option");
        Optional kafkaPrincipalOpt = builder.maybeBuildAssignor(Optional.of(new KafkaPrincipal("principal", "user")), PartitionPlacementStrategy.CLUSTER_WIDE);
        Assertions.assertFalse((boolean)kafkaPrincipalOpt.isPresent(), (String)"Expected an empty optional due to not using a multi tenant principal");
    }

    @Test
    public void testConfigureAssignor() {
        Properties brokerProps = new Properties();
        brokerProps.put("zookeeper.connect", TestUtils.MockZkConnect());
        brokerProps.put("listeners", "PLAINTEXT://localhost:9092");
        brokerProps.put(KafkaConfig.ConfluentTopicReplicaAssignorBuilderProp(), TenantPartitionAssignorBuilder.class.getCanonicalName());
        Option builderOpt = new KafkaConfig((Map)brokerProps).topicReplicaAssignorBuilder();
        Assertions.assertTrue((boolean)builderOpt.isDefined(), (String)"Expected the assignor builder to be successfully loaded");
        Assertions.assertTrue((boolean)(builderOpt.get() instanceof TenantPartitionAssignorBuilder), (String)String.format("Expected the assignor builder to be of type %s", TenantPartitionAssignorBuilder.class.getName()));
    }
}

