/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSni;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithSniStartWithPKC;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:medium")})
public class BrokerDynamicHostnameGenerationTest {
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    protected PhysicalCluster physicalCluster;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final String path = JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/file_auth_test_apikeys.json").getPath();
    private Path tempDir;
    private TestInfo testInfo;
    private Map<String, Object> testCert;

    public void setUpCluster(Properties brokerProps) throws Exception {
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        Properties brokerOverrideProps = this.setUpMetadata(this.brokerProps(brokerProps));
        this.physicalCluster = this.testHarness.start(brokerOverrideProps, this.controllerProps());
        int serviceUserId = 1;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, serviceUserId);
        LogicalClusterUser testUser = logicalCluster.user(serviceUserId);
        this.testHarness.newAclCommand().addTopicAclArgs(testUser.prefixedKafkaPrincipal(), testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo = testInfo;
        this.tempDir = TestUtils.tempDirectory().toPath();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        configs.put("node.id", brokerProps.get("node.id"));
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps(Properties additionalBrokerProps) throws Exception {
        Properties props = this.nodeProps();
        props.putAll((Map<?, ?>)additionalBrokerProps);
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", (Object)true);
        props.put("listener.name.non_local_tenant_scoped.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.non_local_tenant_scoped.confluent.security.event.logger.authentication.enable", (Object)true);
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,EXTERNAL:SASL_SSL,NON_LOCAL_TENANT_SCOPED:SASL_SSL");
        CertStores certStores = new CertStores(true, LOCAL_HOST_IP, InetAddress.getByName(LOCAL_HOST_IP));
        this.testCert = certStores.keyStoreProps();
        this.testCert.putAll(certStores.trustStoreProps());
        props.put("listeners", "INTERNAL://127.0.0.1:0,REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0,NON_LOCAL_TENANT_SCOPED://127.0.0.1:0");
        props.put("inter.broker.listener.name", "REPLICATION");
        this.testCert.values().removeIf(Objects::isNull);
        props.putAll(this.testCert);
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.multitenant.parse.lkc.id.enable", (Object)true);
        props.put("listener.name.external.confluent.proxy.protocol.version", ProxyProtocol.NONE.name);
        props.put("listener.name.non_local_tenant_scoped.confluent.proxy.protocol.version", ProxyProtocol.NONE.name);
        props.setProperty("listener.name.non_local_tenant_scoped.broker.interceptor.class", MultiTenantInterceptor.class.getName());
        return props;
    }

    private Properties nodeProps() {
        Properties props = new Properties();
        props.put("node.id", "0");
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        return props;
    }

    private Properties controllerProps() {
        return this.nodeProps();
    }

    private String getBootStrapResolvableToLocalIp(String listenerName, String hostToBeReplaced) {
        String boostrapServers = this.physicalCluster.bootstrapServers(listenerName);
        return boostrapServers.replace(hostToBeReplaced, LOCAL_HOST_IP);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMultiListenersUseDynamicHostnameGeneration(String quorum) throws Exception {
        Properties brokerOverrideProps = new Properties();
        String hostTemplate = "-g001%sepusw2-az1%sep";
        brokerOverrideProps.put("advertised.listeners", String.format("INTERNAL://127.0.0.1:0,REPLICATION://127.0.0.1:0,EXTERNAL://%s:0,NON_LOCAL_TENANT_SCOPED://%s:0", hostTemplate, hostTemplate));
        brokerOverrideProps.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", "true");
        brokerOverrideProps.put("confluent.multitenant.parse.sni.host.name.enable", "true");
        brokerOverrideProps.put("confluent.multitenant.listener.hostname.subdomain.suffix.enable", "true");
        brokerOverrideProps.put("confluent.subdomain.separator.variable", "%sep");
        brokerOverrideProps.put("confluent.subdomain.prefix", "us-west-2");
        brokerOverrideProps.put("confluent.subdomain.separator.map", "us-west-2.aws.glb.confluent.cloud:-,default:.");
        brokerOverrideProps.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + SniValidationMode.STRICT.getText() + "\";");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.listener.hostname.cluster.prefix.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.parse.sni.host.name.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.listener.hostname.subdomain.suffix.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.prefix", "us-west-2.aws.glb.confluent.cloud");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.separator.map", "default:.");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.separator.variable", "%sep");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + SniValidationMode.STRICT.getText() + "\";");
        this.setUpCluster(brokerOverrideProps);
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName(), LocalHostResolver.class, new Properties(), this.getBootStrapResolvableToLocalIp("NON_LOCAL_TENANT_SCOPED", hostTemplate), null);
        DescribeClusterResult describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        Collection nodes = (Collection)describeClusterResult.nodes().get();
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"lkc-abc-g001.usw2-az1.us-west-2.aws.glb.confluent.cloud", (Object)((Node)nodes.iterator().next()).host());
        client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName(), LocalHostResolver.class, new Properties(), this.getBootStrapResolvableToLocalIp("EXTERNAL", hostTemplate), null);
        describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        nodes = (Collection)describeClusterResult.nodes().get();
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"lkc-abc-g001-usw2-az1-us-west-2.aws.glb.confluent.cloud", (Object)((Node)nodes.iterator().next()).host());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOneListenerGeneratesHostnamesDynamically_WhileOtherListenerDoesnt(String quorum) throws Exception {
        Properties brokerOverrideProps = new Properties();
        String hostTemplate = "-g001%sepusw2-az1%sep";
        brokerOverrideProps.put("advertised.listeners", String.format("INTERNAL://127.0.0.1:0,REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0,NON_LOCAL_TENANT_SCOPED://%s:0", hostTemplate));
        brokerOverrideProps.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", "false");
        brokerOverrideProps.put("confluent.multitenant.parse.sni.host.name.enable", "false");
        brokerOverrideProps.put("confluent.multitenant.listener.hostname.subdomain.suffix.enable", "false");
        brokerOverrideProps.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + SniValidationMode.OPTIONAL_VALIDATION.getText() + "\";");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.listener.hostname.cluster.prefix.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.parse.sni.host.name.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.multitenant.listener.hostname.subdomain.suffix.enable", "true");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.prefix", "us-west-2.aws.glb.confluent.cloud");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.separator.map", "default:.");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.confluent.subdomain.separator.variable", "%sep");
        brokerOverrideProps.put("listener.name.non_local_tenant_scoped.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + SniValidationMode.STRICT.getText() + "\";");
        this.setUpCluster(brokerOverrideProps);
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName(), LocalHostResolver.class, new Properties(), this.getBootStrapResolvableToLocalIp("NON_LOCAL_TENANT_SCOPED", hostTemplate), null);
        DescribeClusterResult describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        Collection nodes = (Collection)describeClusterResult.nodes().get();
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)"lkc-abc-g001.usw2-az1.us-west-2.aws.glb.confluent.cloud", (Object)((Node)nodes.iterator().next()).host());
        client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName(), LocalHostResolver.class, new Properties(), this.getBootStrapResolvableToLocalIp("EXTERNAL", hostTemplate), null);
        describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        nodes = (Collection)describeClusterResult.nodes().get();
        Assertions.assertEquals((int)1, (int)nodes.size());
        Assertions.assertEquals((Object)LOCAL_HOST_IP, (Object)((Node)nodes.iterator().next()).host());
    }

    public static class LocalHostResolver
    implements HostResolver {
        public InetAddress[] resolve(String host) throws UnknownHostException {
            return InetAddress.getAllByName(BrokerDynamicHostnameGenerationTest.LOCAL_HOST_IP);
        }
    }
}

