/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.security.authorizer.Scope;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class FileBasedPlainSaslAuthIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final int serviceUserId = 1;
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private final String path = JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/file_auth_test_apikeys.json").getPath();
    private final String newApiKeysPath = JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/changed_apikeys.json").getPath();
    private File apiKeysFile;
    private LogicalClusterUser testUser;
    private Path tempDir;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        this.apiKeysFile = TestUtils.tempFile();
        TestUtils.writeToFile((File)this.apiKeysFile, (String)org.apache.kafka.common.utils.Utils.readFileAsString((String)this.path));
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness(testInfo);
        PhysicalCluster physicalCluster = this.testHarness.start(this.setUpMetadata(this.nodeProps()), this.nodeProps());
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, 1);
        this.testUser = logicalCluster.user(1);
        this.testHarness.newAclCommand().addTopicAclArgs(this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    @AfterAll
    public static void verifyUnexpected() throws Exception {
        TestUtils.verifyNoUnexpectedThreads();
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.session.uuid", this.brokerUUID);
        brokerProps.put("broker.session.uuid", this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        configs.put("node.id", brokerProps.get("node.id"));
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties nodeProps() {
        Properties props = new Properties();
        props.put("node.id", "0");
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.apiKeysFile + "\" refresh_ms=\"1000\";");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthentication(String quorum) throws Exception {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        client.createTopics(this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent(), (String)"Authentication event should contain principal");
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        Assertions.assertEquals((Object)new Scope.Builder(new String[0]).addPath("organization=" + Utils.LC_META_ABC.organizationId()).addPath("environment=" + Utils.LC_META_ABC.environmentId()).addPath("cloud-cluster=" + Utils.LC_META_ABC.logicalClusterId()).withKafkaCluster(Utils.LC_META_ABC.logicalClusterId()).build(), (Object)authenticationEvent.getScope());
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidPassword(String quorum) throws InterruptedException {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "WrongPassword"));
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Bad password for user APIKEY1"));
        Assertions.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUnknownUser(String quorum) throws InterruptedException {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("UnknownUser", "WrongPassword"));
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((boolean)errorInfo.errorMessage().contains("Unknown user UnknownUser"));
        Assertions.assertEquals((Object)"UnknownUser", (Object)errorInfo.identifier());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testApiKeyDelete(String quorum) throws Exception {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        client.createTopics(this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get(15L, TimeUnit.SECONDS)).containsAll(expectedTopics)));
        TestUtils.waitForCondition(() -> {
            try {
                TestUtils.writeToFile((File)this.apiKeysFile, (String)org.apache.kafka.common.utils.Utils.readFileAsString((String)this.newApiKeysPath));
                try (AdminClient client2 = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
                    client2.listTopics().listings().get(15L, TimeUnit.SECONDS);
                }
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }, (String)"API keys not updated");
        TestUtils.waitForCondition(() -> {
            try {
                client.listTopics().listings().get(15L, TimeUnit.SECONDS);
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }, (String)"Connection for deleted API key not terminated");
    }
}

