/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantAuthorizerAclStateTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private final String apiKeysTopic = "_confluent-apikey";
    private final String adminUserAPIkey = "APIKEY1";
    private final String adminUserAPIkeyPassword = "pwd1";
    private final String serviceUserAPIkey2 = "APIKEY2";
    private final String serviceUserAPIkeyPassword2 = "pwd2";
    private final String testTopic = "topic1";
    private final String testTopic2 = "topic2";
    private final String userId2 = "2";

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        KafkaTestUtils.verifyThreadCleanup();
        int numBrokers = 3;
        this.testHarness = new IntegrationTestHarness(testInfo, numBrokers);
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(Arrays.asList("_confluent-apikey"), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs, "0"), this.controllerProps(topicLoadTimeoutMs, "0"), Optional.empty());
        int adminUserId = 1;
        int serviceUserId = 2;
        this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, adminUserId, serviceUserId);
        this.loadApiKeys(this.physicalCluster, "/file_auth_test_apikeys.json", "APIKEY1");
        this.loadApiKeys(this.physicalCluster, "/service_account_apikey_2.json", "APIKEY2");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        KafkaTestUtils.verifyThreadCleanup();
    }

    private Properties brokerProps(long topicLoadTimeoutMs, String brokerId) throws IOException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("broker.id", brokerId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties controllerProps(long topicLoadTimeoutMs, String nodeId) throws IOException {
        Properties props = new Properties();
        props.put("node.id", nodeId);
        props.putAll((Map<?, ?>)this.commonProps(topicLoadTimeoutMs));
        return props;
    }

    private Properties commonProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("password.encoder.secret", "link-secret");
        props.put("confluent.multitenant.authorizer.enable.acl.state", "true");
        props.put("confluent.max.acls.per.tenant", "100");
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testLifecycleAclState(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY2", "pwd2"));
            KafkaFuture future = client.createTopics(this.topicsList("topic1")).all();
            TestUtils.assertFutureError((Future)future, TopicAuthorizationException.class);
            AclBinding acl1 = this.topicAcl("2", "topic1");
            adminClient.createAcls(Collections.singleton(acl1)).all().get();
            TestUtils.retryOnExceptionWithTimeout(() -> client.createTopics(this.topicsList("topic1")).all().get());
            List expectedTopics = this.topicsList("topic1").stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
            List<AclBindingFilter> aclBindingFilters = Arrays.asList(this.topicFilter("2"));
            ((KafkaFuture)ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).values().get(this.topicFilter("2"))).get();
            TestUtils.retryOnExceptionWithTimeout(() -> TestUtils.assertFutureThrows((Future)client.deleteTopics(Arrays.asList("topic1")).all(), TopicAuthorizationException.class));
            Collection acls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)aclBindingFilters.get(0), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((Object)acls, Arrays.asList(acl1)));
            DeleteAclsResult.FilterResults softDeleteResult = (DeleteAclsResult.FilterResults)((KafkaFuture)ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).values().get(aclBindingFilters.get(0))).get();
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((int)softDeleteResult.values().size(), (int)0));
            DeleteAclsResult.FilterResults results = (DeleteAclsResult.FilterResults)((KafkaFuture)ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.DELETED).values().get(this.topicFilter("2"))).get();
            Assertions.assertEquals((int)results.values().size(), (int)1);
            Assertions.assertEquals((Object)((DeleteAclsResult.FilterResult)results.values().get(0)).binding(), (Object)acl1);
            Assertions.assertEquals((Object)((DeleteAclsResult.FilterResult)results.values().get(0)).exception(), null);
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection allAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)((AclBindingFilter)aclBindingFilters.get(0)), (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertEquals((int)allAcls.size(), (int)0);
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDeleteAcls(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            ArrayList<AclBinding> aclsToCreate = new ArrayList<AclBinding>();
            ArrayList<AclBinding> firstTwoAcls = new ArrayList<AclBinding>();
            ArrayList<AclBinding> lastSevenAcls = new ArrayList<AclBinding>();
            for (int i = 0; i < 10; ++i) {
                AclBinding acl = this.topicAcl("2", "topic1" + i);
                aclsToCreate.add(acl);
                if (i < 2) {
                    firstTwoAcls.add(acl);
                    continue;
                }
                if (i <= 2) continue;
                lastSevenAcls.add(acl);
            }
            adminClient.createAcls(aclsToCreate).all().get();
            AclBindingFilter filter = this.topicFilter("2");
            List<AclBindingFilter> aclBindingFilters = Arrays.asList(this.filterWithTopicName("2", "topic10"), this.filterWithTopicName("2", "topic11"));
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection aclsCreated = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertTrue((boolean)aclsCreated.containsAll(aclsToCreate));
                Assertions.assertEquals((int)aclsCreated.size(), (int)aclsToCreate.size());
            });
            Collection aclBindings = (Collection)ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.DELETED).all().get();
            Assertions.assertEquals((int)aclBindings.size(), (int)0);
            Map result = ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).values();
            ((KafkaFuture)result.get(aclBindingFilters.get(0))).get();
            ((KafkaFuture)result.get(aclBindingFilters.get(1))).get();
            Collection softAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
            Assertions.assertTrue((boolean)softAcls.containsAll(firstTwoAcls));
            Assertions.assertEquals((int)softAcls.size(), (int)2);
            Collection bindings = (Collection)ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).all().get();
            Assertions.assertEquals((int)bindings.size(), (int)0);
            List<AclBindingFilter> threeAclsFilter = Arrays.asList(this.filterWithTopicName("2", "topic10"), this.filterWithTopicName("2", "topic11"), this.filterWithTopicName("2", "topic12"));
            Map results = ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), threeAclsFilter, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ANY).values();
            Assertions.assertEquals((int)results.size(), (int)3);
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection allAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertEquals((int)allAcls.size(), (int)lastSevenAcls.size());
                Assertions.assertTrue((boolean)allAcls.containsAll(lastSevenAcls));
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testDescribeAcls(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            ArrayList<AclBinding> aclsToCreate = new ArrayList<AclBinding>();
            ArrayList<AclBinding> firstTwoAcls = new ArrayList<AclBinding>();
            ArrayList<AclBinding> remainingAcls = new ArrayList<AclBinding>();
            for (int i = 0; i < 10; ++i) {
                AclBinding acl = this.topicAcl("2", "topic1" + i);
                aclsToCreate.add(acl);
                if (i < 2) {
                    firstTwoAcls.add(acl);
                    continue;
                }
                remainingAcls.add(acl);
            }
            adminClient.createAcls(aclsToCreate).all().get();
            AclBindingFilter filter = this.topicFilter("2");
            List<AclBindingFilter> aclBindingFilters = Arrays.asList(this.filterWithTopicName("2", "topic10"), this.filterWithTopicName("2", "topic11"));
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection aclsCreated = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertTrue((boolean)aclsCreated.containsAll(aclsToCreate));
                Assertions.assertEquals((int)aclsCreated.size(), (int)aclsToCreate.size());
            });
            Map result = ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).values();
            ((KafkaFuture)result.get(aclBindingFilters.get(0))).get();
            ((KafkaFuture)result.get(aclBindingFilters.get(1))).get();
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection activeAcls = (Collection)adminClient.describeAcls(filter).values().get();
                Assertions.assertTrue((boolean)activeAcls.containsAll(remainingAcls));
                Assertions.assertEquals((int)activeAcls.size(), (int)remainingAcls.size());
            });
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection softAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.DELETED).values().get();
                Assertions.assertTrue((boolean)softAcls.containsAll(firstTwoAcls));
                Assertions.assertEquals((int)softAcls.size(), (int)2);
            });
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection allAcls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertEquals((int)allAcls.size(), (int)aclsToCreate.size());
                Assertions.assertTrue((boolean)allAcls.containsAll(aclsToCreate));
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testAclLimit(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            for (int i = 0; i < 100; ++i) {
                adminClient.createAcls(Collections.singleton(this.topicAcl("2", "topic1" + i))).all().get();
            }
            TestUtils.assertFutureThrows((Future)adminClient.createAcls(Collections.singleton(this.topicAcl("2", "topic2"))).all(), InvalidRequestException.class);
            List<AclBindingFilter> aclBindingFilters = Arrays.asList(this.filterWithTopicName("2", "topic10"), this.filterWithTopicName("2", "topic11"));
            ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), aclBindingFilters, (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).all().get();
            adminClient.createAcls(Arrays.asList(this.topicAcl("2", "topic21"), this.topicAcl("2", "topic22"))).all().get();
            TestUtils.assertFutureThrows((Future)adminClient.createAcls(Collections.singleton(this.topicAcl("2", "topic23"))).all(), InvalidRequestException.class);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testAclDeleteResponse(String quorum) throws Exception {
        try (AdminClient adminClient = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            adminClient.createAcls(Collections.singleton(this.topicAcl("2", "topic1"))).all().get();
            AclBindingFilter filter = this.topicFilter("2");
            ConfluentAdminUtils.deleteAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), Collections.singletonList(filter), (DeleteAclsOptions)new DeleteAclsOptions(), (AclState)AclState.ACTIVE).all().get();
            adminClient.createAcls(Collections.singleton(this.topicAcl("2", "topic12"))).all().get();
            DeleteAclsResult result = adminClient.deleteAcls(Collections.singletonList(filter));
            TestUtils.retryOnExceptionWithTimeout(() -> {
                Collection acls = (Collection)ConfluentAdminUtils.describeAcls((ConfluentAdmin)((ConfluentAdmin)adminClient), (AclBindingFilter)filter, (DescribeAclsOptions)new DescribeAclsOptions(), (AclState)AclState.ANY).values().get();
                Assertions.assertEquals((int)acls.size(), (int)0);
            });
            Assertions.assertEquals((int)((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(filter)).get()).values().size(), (int)1);
            Assertions.assertEquals((Object)((DeleteAclsResult.FilterResult)((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get(filter)).get()).values().get(0)).binding(), (Object)this.topicAcl("2", "topic12"));
        }
    }

    private AclBinding topicAcl(String principalName, String topicName) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, topicName, PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", principalName).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }

    private AclBindingFilter topicFilter(String principalName) {
        return this.topicFilter(principalName, "User");
    }

    private AclBindingFilter topicFilter(String principalName, String principalType) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(new KafkaPrincipal(principalType, principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }

    private AclBindingFilter filterWithTopicName(String principalName, String resourceName) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resourceName, PatternType.ANY), new AccessControlEntryFilter(new KafkaPrincipal("User", principalName).toString(), null, AclOperation.ANY, AclPermissionType.ANY));
    }

    private List<NewTopic> topicsList(String topicName) {
        return Collections.singletonList(new NewTopic(topicName, 3, 1));
    }

    private void loadApiKeys(PhysicalCluster cluster, String fileName, String apiKey) throws Exception {
        BufferedInputStream path;
        try {
            path = new BufferedInputStream(FileBasedPlainSaslAuthenticatorTest.class.getResourceAsStream(fileName));
        }
        catch (Exception e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = org.apache.kafka.common.utils.Utils.readFullyToString((InputStream)path);
        cluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKey, apiKeys, true);
    }
}

