/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Disabled(value="https://confluentinc.atlassian.net/browse/KCFUN-1099")
@Tag(value="integration")
class MultiTenantCellsCliIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private Integer exitCode;
    private String exitMessage;

    MultiTenantCellsCliIntegrationTest() {
    }

    @BeforeEach
    void setupExitProcedure() {
        this.exitCode = null;
        this.exitMessage = null;
        Exit.setExitProcedure((code, message) -> {
            if (this.exitCode == null) {
                this.exitCode = code;
                this.exitMessage = message;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
    }

    @Override
    protected void createPhysicalAndLogicalClusters() {
        super.createPhysicalAndLogicalClusters();
        this.awaitMetadataPropagation();
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAlterCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "alter-cell", "--cell-id", "0", "--state", CellState.QUARANTINED.name()};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.QUARANTINED.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully set cell 0 to cell state QUARANTINED", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAlterCellInvalidState(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "alter-cell", "--cell-id", "0", "--state", "NOT_A_STATE"};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Invalid cell state given. Must be one of EXCLUDED, QUARANTINED, READY", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAlterCellNonExitingCellId(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "alter-cell", "--cell-id", "9", "--state", CellState.READY.name()};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to alter cell: Cell 9 does not exist. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-cell", "--cell-id", "1", "--state", CellState.EXCLUDED.name()};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Collections.emptyList()).setState(CellState.EXCLUDED.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully created cell 1 with cell state EXCLUDED", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateCellInvalidState(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-cell", "--cell-id", "1", "--state", "NOT_A_STATE"};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Invalid cell state given. Must be one of EXCLUDED, QUARANTINED, READY", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateCellExistingCellId(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-cell", "--cell-id", "0", "--state", CellState.READY.name()};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to create cell: Cell 0 won't be created since it already exists. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testDeleteCell(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        this.physicalCluster.superConfluentAdmin().unassignBrokersFromCell(Arrays.asList(0, 1, 2)).value().get();
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "delete-cell", "--cell-id", "0"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals(Collections.emptyList(), (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully deleted cell 0", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testDeleteCellNonExistingCellId(String quorum) throws Exception {
        int brokerCount = 3;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "delete-cell", "--cell-id", "5"};
        CellsAdminCommand.main((String[])cmdArgs);
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        List<DescribeCellsResponseData.Cell> expectedCells = Collections.singletonList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)cells);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to delete cell: Did not delete cell 5 since it does not exist. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignBrokersToCell(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-brokers", "--cell-id", "1", "--broker-ids", "0,1,2"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()).setOpenForTenantAssignment(false), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully set brokers 0,1,2 to cell 1", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignBrokersToCellForce(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-brokers", "--cell-id", "1", "--broker-ids", "0,1", "--force"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.singletonList(2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(0, 1, 3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully set brokers 0,1 to cell 1", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignBrokersToCellForceFalse(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-brokers", "--cell-id", "1", "--broker-ids", "0,1"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to assign brokers to cell: Cell assignment and unassignment must be done in increments of cellSize 3, and the source brokerIds must be from one cell. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignBrokersToCellOverMaxCellSize(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.max.size", (Object)5);
        this.createPhysicalAndLogicalClusters(props);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-brokers", "--cell-id", "1", "--broker-ids", "0,1,2"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to assign brokers to cell: Cells' number of brokers cannot exceed maxSize. Attempted to set cell 1 with maxSize 5, 6 number of brokers. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testUnassignBrokersFromCell(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "unassign-brokers", "--broker-ids", "0,1,2"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Collections.emptyList()).setState(CellState.READY.code()).setOpenForTenantAssignment(false), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(6, 7, 8)).setState(CellState.READY.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully unassigned brokers 0,1,2", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignTenantsToCell(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-tenants", "--cell-id", "1", "--tenant-ids", this.logicalCluster1.logicalClusterId() + "," + this.logicalCluster2.logicalClusterId()};
        CellsAdminCommand.main((String[])cmdArgs);
        List tenants = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenants = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellId(1).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()), new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster2.logicalClusterId()).setCellId(1).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals(expectedTenants, (Object)tenants);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignTenantsToQuarantinedCell(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
        client.createTopics(topics).all().get();
        this.physicalCluster.superConfluentAdmin().assignTenantsToCell(Collections.singletonList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setCellId(0).setTenantId(this.logicalCluster1.logicalClusterId()))).value().get();
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED);
        String[] assignTenantToCell1 = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-tenants", "--cell-id", "1", "--tenant-ids", this.logicalCluster1.logicalClusterId()};
        CellsAdminCommand.main((String[])assignTenantToCell1);
        Assertions.assertEquals((Object)this.exitMessage, (Object)"Failed to set all tenants to cell");
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        this.exitMessage = null;
        this.exitCode = null;
        String[] assignTenantToCell1Force = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-tenants", "--cell-id", "1", "--force", "--tenant-ids", this.logicalCluster1.logicalClusterId()};
        CellsAdminCommand.main((String[])assignTenantToCell1Force);
        List tenants = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        List<DescribeTenantsResponseData.TenantDescription> expectedTenants = Arrays.asList(new DescribeTenantsResponseData.TenantDescription().setTenantId(this.logicalCluster1.logicalClusterId()).setCellId(1).setPartitionPlacementStrategy(PartitionPlacementStrategy.TENANT_IN_CELL.code().intValue()));
        Assertions.assertEquals((Object)("Successfully set tenants " + this.logicalCluster1.logicalClusterId() + " to cell 1"), (Object)this.exitMessage);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals(expectedTenants, (Object)tenants);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testAssignTenantsToCellInvalidRequest(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient firstTenantClient = this.testHarness.createAdminClient(this.logicalCluster1.user(9));
        AdminClient secondTenantClient = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        for (AdminClient client : Arrays.asList(firstTenantClient, secondTenantClient)) {
            String topicName = "testtopicname";
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 1, 3));
            client.createTopics(topics).all().get();
        }
        List originalTenants = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "assign-tenants", "--cell-id", "9", "--tenant-ids", this.logicalCluster1.logicalClusterId() + ",lkc-invalid"};
        CellsAdminCommand.main((String[])cmdArgs);
        List tenants = (List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get();
        Assertions.assertEquals((Object)originalTenants, (Object)tenants);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateQuarantinedCell(String quorum) throws Exception {
        int brokerCount = 18;
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.default.size", (Object)6);
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(props);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-quarantined-cell"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(6, 7, 8, 9, 10, 11)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(12, 13, 14, 15, 16, 17)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Arrays.asList(18, 19, 20)).setState(CellState.QUARANTINED.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Quarantined cell 3 successfully created. Please ensure the cluster has at least 21 pods", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateQuarantinedCellFromPartialLastCell(String quorum) throws Exception {
        int brokerCount = 15;
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)3);
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.cells.default.size", (Object)6);
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(props);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-quarantined-cell"};
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2, 3, 4, 5)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(6, 7, 8, 9, 10, 11)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(2).setBrokers(Arrays.asList(12, 13, 14)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(3).setBrokers(Arrays.asList(18, 19, 20)).setState(CellState.QUARANTINED.code()).setOpenForTenantAssignment(false));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Quarantined cell 3 successfully created. Please ensure the cluster has at least 21 pods", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateQuarantinedCellWithExistingQuarantinedCell(String quorum) throws Exception {
        int brokerCount = 5;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-quarantined-cell"};
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED).value().get();
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3, 4)).setState(CellState.QUARANTINED.code()).setOpenForTenantAssignment(true));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Quarantined cell already exists. Assign tenant to cell 1", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCreateQuarantinedCellWithInvalidQuarantinedCell(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.cellProps();
        props.put("confluent.cells.min.size", (Object)2);
        this.createPhysicalAndLogicalClusters(props);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "create-quarantined-cell"};
        this.physicalCluster.superConfluentAdmin().alterCell(1, CellState.QUARANTINED).value().get();
        CellsAdminCommand.main((String[])cmdArgs);
        List<DescribeCellsResponseData.Cell> expectedCells = Arrays.asList(new DescribeCellsResponseData.Cell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)).setState(CellState.READY.code()).setOpenForTenantAssignment(true), new DescribeCellsResponseData.Cell().setCellId(1).setBrokers(Arrays.asList(3)).setState(CellState.QUARANTINED.code()));
        Assertions.assertEquals(expectedCells, (Object)((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells());
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Quarantined cell 1 already exists. Broker size less than minimum cell requirement. Please contact KCFUN team.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCellStatus(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "status"};
        CellsAdminCommand.main((String[])cmdArgs);
        StringBuilder message = new StringBuilder();
        message.append("Cells enabled: true\n");
        message.append("Cell size: 3\n");
        message.append("Min cell size: 1\n");
        message.append("Max cell size: 6");
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)message.toString(), (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testCellStatusDisabled(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.nodeProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "status"};
        CellsAdminCommand.main((String[])cmdArgs);
        StringBuilder message = new StringBuilder();
        message.append("Cells enabled: false\n");
        message.append("Cell size: 15\n");
        message.append("Min cell size: 6\n");
        message.append("Max cell size: 15");
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)message.toString(), (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    void testCellStatusDynamicallyUpdated(String quorum) throws Exception {
        int brokerCount = 4;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "status"};
        this.physicalCluster.superConfluentAdmin().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry("confluent.cells.enable", "false"), AlterConfigOp.OpType.SET)))).all().get();
        TestUtils.waitForCondition(() -> {
            ConfigResource cluster = new ConfigResource(ConfigResource.Type.BROKER, "0");
            Map describedConfigs = (Map)this.physicalCluster.superConfluentAdmin().describeConfigs(Collections.singleton(cluster)).all().get();
            Config clusterConfig = (Config)describedConfigs.get(cluster);
            boolean cellsEnabled = Boolean.parseBoolean(clusterConfig.get("confluent.cells.enable").value());
            return !cellsEnabled;
        }, (String)"Unable to wait for cells to become disabled");
        CellsAdminCommand.main((String[])cmdArgs);
        StringBuilder message = new StringBuilder();
        message.append("Cells enabled: false\n");
        message.append("Cell size: 3\n");
        message.append("Min cell size: 1\n");
        message.append("Max cell size: 6");
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)message.toString(), (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testStartCellMigration(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "start-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully started cell migration", (Object)this.exitMessage);
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    void testStartCellMigrationZK(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "start-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to start cell migration: Cell migration state update not supported for ZooKeeper quorum. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testPauseCellMigration(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "pause-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully paused cell migration", (Object)this.exitMessage);
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"PAUSED", (Object)migrationState);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testStopCellMigration(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "stop-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Successfully stopped cell migration", (Object)this.exitMessage);
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        TestUtils.assertFutureThrows((Future)this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.PAUSED).value(), InvalidRequestException.class);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testDescribeCellMigration(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "describe-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)0, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Cells Migration state: INITIATED\n", (Object)this.exitMessage);
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    void testDescribeCellMigrationZK(String quorum) throws Exception {
        int brokerCount = 6;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "describe-migration"};
        CellsAdminCommand.main((String[])cmdArgs);
        Assertions.assertEquals((int)1, (Integer)this.exitCode);
        Assertions.assertEquals((Object)"Failed to fetch cell migration details: Cell migration status not supported for ZooKeeper quorum. Enable debug logging for additional detail.", (Object)this.exitMessage);
    }

    private Properties cellProps() {
        Properties props = this.nodeProps();
        props.put("confluent.cells.enable", (Object)true);
        props.put("confluent.cells.implicit.creation.enable", (Object)true);
        props.put("confluent.topic.partition.default.placement", PartitionPlacementStrategy.TENANT_IN_CELL.code().toString());
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.cells.default.size", (Object)3);
        props.put("confluent.cells.max.size", (Object)6);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)3);
        return props;
    }
}

