/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.DynamicQuotaChannelManager;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.collection.JavaConverters;

@Tag(value="integration")
public class MultiTenantQuotaIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private final double defaultControllerMutationRateQuota = 100.0;
    private final double defaultProducerIdRateQuota = 10.0;
    private final double defaultProduceQuotaMultiplier = 2.0;
    private final String topicName = "_confluent-logical_clusters";

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("client.quota.callback.class", TenantQuotaCallback.class.getName());
        return props;
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        brokerProperties.put("confluent.cluster.link.replication.quota.mode", ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND.name());
        this.physicalCluster = this.testHarness.start(brokerProperties, Time.SYSTEM);
        this.logicalCluster1 = this.physicalCluster.createLogicalCluster("lkc-tenant1", 100, 9, 11, 12);
        this.logicalCluster2 = this.physicalCluster.createLogicalCluster("lkc-tenant2", 200, 9, 21, 22);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDynamicTenantControllerQuota(String quorum) throws Exception {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(100.0));
        props.put("confluent.quota.tenant.produce.multiplier", String.valueOf(2.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic", Optional.of(5), Optional.empty()))).all().get();
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, 100.0);
        double updatedControllerMutationRateQuota = 200.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(updatedControllerMutationRateQuota)));
        this.verifyQuotaCallbackLimit(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, updatedControllerMutationRateQuota);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic2", Optional.of(5), Optional.empty()))).all().get();
        this.verifyQuota(ClientQuotaType.CONTROLLER_MUTATION, quotaTags, updatedControllerMutationRateQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDynamicTenantProducerIdQuota(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.producer.id.quota.manager.enable", String.valueOf(true));
        props.put("confluent.quota.tenant.default.producer.id.rate", String.valueOf(10.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "test_topic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, 10.0);
        double updatedProducerIdRateQuota = 20.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.default.producer.id.rate", String.valueOf(updatedProducerIdRateQuota)));
        this.verifyQuotaCallbackLimit(ClientQuotaType.PRODUCER_ID, quotaTags, updatedProducerIdRateQuota);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("test_topic2", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "test_topic2", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, updatedProducerIdRateQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicQuotaMultiplier(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.quota.tenant.default.controller.mutation.rate", String.valueOf(100.0));
        props.put("confluent.quota.tenant.produce.multiplier", String.valueOf(2.0));
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(Utils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        double expectedProduceQuota = 2.0 * (double)Utils.LC_META_1.producerByteRate().longValue() / 2.0;
        double expectedFetchQuota = (double)Utils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        double updatedFetchMultiplier = 3.0;
        double updatedProduceMultiplier = 1.0;
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.fetch.multiplier", String.valueOf(updatedFetchMultiplier)));
        this.updateBrokerConfig(new ConfigEntry("confluent.quota.tenant.produce.multiplier", String.valueOf(updatedProduceMultiplier)));
        double updatedProduceQuota = updatedProduceMultiplier * (double)Utils.LC_META_1.producerByteRate().longValue() / 2.0;
        double updatedFetchQuota = updatedFetchMultiplier * (double)Utils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuotaCallbackLimit(ClientQuotaType.PRODUCE, quotaTags, updatedProduceQuota);
        this.verifyQuotaCallbackLimit(ClientQuotaType.FETCH, quotaTags, updatedFetchQuota);
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, updatedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, updatedFetchQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicQuotaPipeline(String quorum) throws Throwable {
        this.setUp();
        Properties props = this.nodeProps();
        props.put(KafkaConfig.DynamicQuotaEnabledProp(), String.valueOf(true));
        props.put(KafkaConfig.QuotasTopicReplicationFactorProp(), (Object)2);
        props.put("confluent.quota.dynamic.reporting.interval.ms", (Object)1000);
        props.put("confluent.quota.dynamic.publishing.interval.ms", (Object)4000);
        props.put("confluent.quota.dynamic.reporting.min.usage", (Object)0);
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(Utils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(5), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        double expectedProduceQuota = (double)Utils.LC_META_1.producerByteRate().longValue() / 2.0;
        double expectedFetchQuota = (double)Utils.LC_META_1.consumerByteRate().longValue() / 2.0;
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, expectedFetchQuota);
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getReportRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should have received a Reporting request");
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().anyMatch(quotaCoordinator -> quotaCoordinator.quotaStateManager().getQuota(new QuotaEntity(this.toScalaMap(quotaTags))).nonEmpty()), (String)"Quota coordinator should have recomputed the quota");
        TestUtils.waitForCondition(() -> channelManagers.stream().anyMatch(channelManager -> channelManager.getPublishRequestThread().queuePerNode().nonEmpty()), (String)"Dynamic quota channel manager should send a Publishing request");
        this.verifyQuota(ClientQuotaType.PRODUCE, quotaTags, quota -> quota != expectedProduceQuota);
        this.verifyQuota(ClientQuotaType.FETCH, quotaTags, quota -> quota != expectedFetchQuota);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProducerIdThrottling(String quorum) throws Throwable {
        this.setUp(1, Collections.emptyList());
        Properties props = this.nodeProps();
        int producerIdQuotaRate = 1;
        props.put("confluent.producer.id.quota.manager.enable", String.valueOf(true));
        props.put(KafkaConfig.ProducerIdThrottleEnableProp(), String.valueOf(true));
        props.put(KafkaConfig.ProducerIdCacheLimitProp(), (Object)100);
        props.put(KafkaConfig.ProducerIdThrottleEnableThresholdPercentageProp(), (Object)0);
        props.put("confluent.quota.tenant.default.producer.id.rate", (Object)producerIdQuotaRate);
        this.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        Map<String, String> quotaTags = this.quotaTags(this.logicalCluster1);
        this.addLkcFileAndSyncMetadata(Utils.LC_META_1);
        tenantAdminClient.createTopics(Collections.singletonList(new NewTopic("testtopic", Optional.of(1), Optional.empty()))).all().get();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0, false);
        this.verifyQuota(ClientQuotaType.PRODUCER_ID, quotaTags, producerIdQuotaRate);
        int producersCreated = this.createProducersUntilProduceIdThrottled(this.logicalCluster1.user(12), "testtopic");
        this.verifyThrottle(ClientQuotaType.PRODUCER_ID, quotaTags, true);
        this.verifyCount(ClientQuotaType.PRODUCER_ID, quotaTags, producersCreated + 1);
    }

    protected void createPhysicalAndLogicalClustersWithTopic(Properties brokerProps, Properties controllerProps) throws ExecutionException, InterruptedException {
        long baseSequenceId = 1000L;
        this.physicalCluster = this.testHarness.startWithTopic("_confluent-logical_clusters", 1, 1, 15000L, brokerProps, controllerProps);
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = Utils.LC_META_ABC.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, lkcId, Utils.LC_META_ABC);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(lkcId) != null), (String)"Expected metadata to get consumed");
        String xyzId = Utils.LC_META_XYZ.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2L, xyzId, Utils.LC_META_XYZ);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.metadata(xyzId) != null), (String)"Expected metadata to get consumed");
    }

    protected void deleteLogicalClusters() throws InterruptedException {
        long baseSequenceId = 1100L;
        List<BasePhysicalClusterMetadata> instances = this.physicalCluster.clusterMetadataInstances();
        String lkcId = Utils.LC_META_ABC_DELETED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 1L, lkcId, Utils.LC_META_ABC_DELETED);
        String xyzId = Utils.LC_META_XYZ_DELETED.logicalClusterId();
        this.physicalCluster.kafkaCluster().produceLCMData("_confluent-logical_clusters", baseSequenceId + 2L, xyzId, Utils.LC_META_XYZ_DELETED);
    }

    public Map<String, Object> eckuNodeProps() {
        return Stream.of({"client.quota.callback.class", TenantQuotaCallback.class.getName()}, {"confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters"}, {"multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName()}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
    }

    public void eCkuSetup() throws Exception {
        Properties props = new Properties();
        props.put(KafkaConfig.DynamicQuotaEnabledProp(), String.valueOf(true));
        props.put(KafkaConfig.QuotasTopicReplicationFactorProp(), (Object)2);
        props.put(KafkaConfig.ElasticCkuEnabledProp(), (Object)true);
        props.put("confluent.quota.dynamic.reporting.interval.ms", (Object)1000);
        props.put("confluent.quota.dynamic.publishing.interval.ms", (Object)4000);
        props.put("confluent.quota.dynamic.reporting.min.usage", (Object)0);
        props.putAll(this.eckuNodeProps());
        Properties controllerProps = new Properties();
        controllerProps.putAll(this.eckuNodeProps());
        this.testHarness = new IntegrationTestHarness(this.testInfo, 3);
        this.createPhysicalAndLogicalClustersWithTopic(props, controllerProps);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testElasticCkuCount(String quorum) throws Throwable {
        this.eCkuSetup();
        List channelManagers = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (DynamicQuotaChannelManager)kafkaServer.dynamicQuotaChannelManager().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> channelManagers.stream().allMatch(channelManager -> channelManager.getPublishRequestThread().started() && channelManager.getReportRequestThread().started()), (String)"Dynamic quota channel manager should have been started");
        List quotaCoordinators = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(kafkaServer -> (QuotaCoordinator)kafkaServer.quotaCoordinatorOpt().get()).collect(Collectors.toList());
        TestUtils.waitForCondition(() -> quotaCoordinators.stream().allMatch(quotaCoordinator -> quotaCoordinator.isActive().get()), (String)"Quota coordinator should have been started");
        this.verifyElasticCkuMetric(Utils.LC_META_ABC.logicalClusterId());
        this.verifyElasticCkuMetric(Utils.LC_META_XYZ.logicalClusterId());
        this.deleteLogicalClusters();
        this.awaitMetadataPropagation();
        this.verifyElasticCkuMetricNotPresent(Utils.LC_META_ABC.logicalClusterId());
        this.verifyElasticCkuMetricNotPresent(Utils.LC_META_XYZ.logicalClusterId());
    }

    private void verifyElasticCkuMetricNotPresent(String lkcId) throws InterruptedException {
        String name = "ElasticCku";
        String type = "QuotaStateManager";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).count() == 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("E-CKU metric should not be present for " + lkcId));
    }

    private void verifyElasticCkuMetric(String lkcId) throws InterruptedException {
        String name = "ElasticCku";
        String type = "QuotaStateManager";
        Map metricsMap = KafkaYammerMetrics.defaultRegistry().allMetrics();
        TestCondition condition = () -> metricsMap.entrySet().stream().filter(e -> {
            MetricName metricName = (MetricName)e.getKey();
            return metricName.getName().equals(name) && metricName.getType().equals(type) && metricName.getMBeanName().contains(String.format("%s=%s", "tenant", lkcId));
        }).filter(e -> {
            Gauge metricValue = (Gauge)e.getValue();
            return metricValue != null && (Double)metricValue.value() >= 0.0;
        }).count() > 0L;
        TestUtils.waitForCondition((TestCondition)condition, (String)("E-CKU metric is not present for " + lkcId));
    }

    private int createProducersUntilProduceIdThrottled(LogicalClusterUser user, String topic) {
        boolean throttled;
        int numCreated = 0;
        do {
            try (KafkaProducer<String, String> producer = this.createProducer(user);){
                String payload = String.valueOf(++numCreated);
                Future future = producer.send(new ProducerRecord(topic, null, (Object)payload, (Object)payload), (Callback)new ErrorLoggingCallback(topic, null, null, true));
                do {
                    throttled = this.isProducerIdThrottled();
                } while (!future.isDone() && !throttled);
            }
        } while (!throttled);
        return numCreated;
    }

    private boolean isProducerIdThrottled() {
        Map<String, String> tags = this.quotaTags(this.logicalCluster1);
        Map<Integer, Metrics> metricsByNodeId = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().collect(Collectors.toMap(broker -> broker.config().brokerId(), broker -> broker.metrics()));
        Predicate<KafkaMetric> isThrottled = metric -> metric != null && (Double)metric.metricValue() > 0.0;
        Predicate<Map> predicate = d -> d.values().stream().anyMatch(isThrottled);
        TestCondition condition = () -> predicate.test(metricsByNodeId.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> this.quotaMetric((Metrics)entry.getValue(), "throttle-time", ClientQuotaType.PRODUCER_ID, tags))));
        try {
            return condition.conditionMet();
        }
        catch (Exception err) {
            return false;
        }
    }

    private KafkaProducer<String, String> createProducer(LogicalClusterUser logicalCluster) {
        Properties overrideProps = new Properties();
        overrideProps.put("client.id", logicalCluster.logicalClusterId);
        return KafkaTestUtils.createProducer(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, ScramMechanism.SCRAM_SHA_256.mechanismName(), logicalCluster.saslJaasConfig(), overrideProps);
    }

    private void updateBrokerConfig(ConfigEntry configToSet) throws Exception {
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        internalAdminClient.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(configToSet, AlterConfigOp.OpType.SET)))).all().get();
    }

    private Map<String, String> quotaTags(LogicalCluster logicalCluster) {
        return Collections.singletonMap("tenant", logicalCluster.logicalClusterId());
    }

    private <T> scala.collection.mutable.Map<T, T> toScalaMap(Map<T, T> map) {
        return (scala.collection.mutable.Map)JavaConverters.mapAsScalaMapConverter(map).asScala();
    }
}

