/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;

public class SaslAuthenticateRequestCallback
implements RequestCallback {
    AtomicInteger callCount = new AtomicInteger();
    private String networkId;
    private DefaultDataPolicyContext policyContext;

    public SaslAuthenticateRequestCallback(String networkId) {
        this.networkId = networkId;
        this.policyContext = null;
    }

    public SaslAuthenticateRequestCallback(DefaultDataPolicyContext policyContext) {
        this.networkId = null;
        this.policyContext = policyContext;
    }

    public void onRequest(KafkaPrincipal principal, AbstractRequest request, Optional<String> clientID, Optional<String> listenerName) {
        if (request instanceof SaslAuthenticateRequest) {
            if (this.networkId != null) {
                ((SaslAuthenticateRequest)request).data().setNetworkId(this.networkId);
            }
            if (this.policyContext != null && this.policyContext.environmentId.isPresent()) {
                ((SaslAuthenticateRequest)request).data().setEnvironmentId((String)this.policyContext.environmentId.get());
            }
            if (this.policyContext != null && this.policyContext.networkType.isPresent()) {
                ((SaslAuthenticateRequest)request).data().setNetworkType(((SaslInternalConfigs.NetworkType)this.policyContext.networkType.get()).getValue());
            }
            this.callCount.incrementAndGet();
        }
    }
}

