/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class SslCertificateIntegrationTest {
    private static final Long TEST_CACHE_RELOAD_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final String SSL_CERTS_DIR = "mnt/sslcerts/";
    private Path tempDir;
    private File validCertDir;
    private File invalidCertDir;
    private IntegrationTestHarness testHarness;
    private String brokerUUID;
    private LogicalCluster logicalCluster1;
    private LogicalCluster logicalCluster2;
    private Properties clientProps;
    protected Time time;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        MockAuditLogProvider.reset();
        this.validCertDir = TestUtils.tempDirectory((Path)this.tempDir, (String)"validCert");
        Map validSslConfigs = new TestSslUtils.SslConfigsBuilder(Mode.SERVER).useClientCert(false).createNewTrustStore(this.validCertDir).certAlias("kafka").cn("localhost.cpdev.cloud").usePem(true).ccloudSpecDir(this.validCertDir).tlsProtocol("TLSv1.2").certBuilder(new TestSslUtils.CertificateBuilder().sanDnsNames(new String[]{"localhost.cpdev.cloud"})).buildProperties();
        TestUtils.writeToFile((File)new File(this.validCertDir, "spec.json"), (String)"{\"ssl_certificate_encoding\":\"PKCS12\",\"ssl_keystore_password\":\"ServerPassword\",\"ssl_keystore_filename\":\"pkcs.p12\",\"secret_id\":1,\"ssl_pem_fullchain_filename\":\"fullchain.pem\",\"ssl_pem_privkey_filename\":\"privkey.pem\"}");
        TestUtils.writeToFile((File)new File(this.validCertDir, "truststore.pem"), (String)((String)validSslConfigs.get("ssl.truststore.certificates")));
        this.invalidCertDir = TestUtils.tempDirectory((Path)this.tempDir, (String)"invalidCert");
        Map invalidSslConfigs = new TestSslUtils.SslConfigsBuilder(Mode.SERVER).useClientCert(false).createNewTrustStore(this.invalidCertDir).certAlias("kafka").cn("localhost.bad.domain").usePem(true).ccloudSpecDir(this.invalidCertDir).tlsProtocol("TLSv1.2").certBuilder(new TestSslUtils.CertificateBuilder().sanDnsNames(new String[]{"localhost.bad.domain"})).buildProperties();
        TestUtils.writeToFile((File)new File(this.invalidCertDir, "spec.json"), (String)"{\"ssl_certificate_encoding\":\"PKCS12\",\"ssl_keystore_password\":\"ServerPassword\",\"ssl_keystore_filename\":\"pkcs.p12\",\"secret_id\":1,\"ssl_pem_fullchain_filename\":\"fullchain.pem\",\"ssl_pem_privkey_filename\":\"privkey.pem\"}");
        TestUtils.writeToFile((File)new File(this.invalidCertDir, "truststore.pem"), (String)((String)validSslConfigs.get("ssl.truststore.certificates")));
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        Utils.createLogicalClusterFile(Utils.LC_META_XYZ, this.tempDir);
        Utils.syncCerts(this.tempDir, this.validCertDir.toURI().toURL(), SSL_CERTS_DIR);
        this.testHarness = new IntegrationTestHarness(testInfo);
        HashMap<String, String> sslProps = new HashMap<String, String>();
        sslProps.put("ssl.truststore.certificates", (String)validSslConfigs.get("ssl.truststore.certificates"));
        sslProps.put("ssl.truststore.type", (String)validSslConfigs.get("ssl.truststore.type"));
        sslProps.put("confluent.require.compatible.keystore.updates", "false");
        boolean isKraft = TestInfoUtils.isKRaft((TestInfo)testInfo);
        PhysicalCluster physicalCluster = this.testHarness.start(this.brokerProps(sslProps, isKraft), this.controllerProps(sslProps));
        this.logicalCluster1 = physicalCluster.createLogicalCluster("tenantA", 100, 9, 11, 12);
        this.logicalCluster2 = physicalCluster.createLogicalCluster("tenantB", 200, 9, 21, 22);
        this.clientProps = new Properties();
        this.clientProps.put("ssl.truststore.certificates", validSslConfigs.get("ssl.truststore.certificates"));
        this.clientProps.put("ssl.truststore.type", validSslConfigs.get("ssl.truststore.type"));
        this.clientProps.put("ssl.trustmanager.algorithm", "ConfluentTls");
        this.clientProps.put("security.providers", "io.confluent.kafka.server.plugins.ssl.ConfluentTrustProviderCreator");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties brokerProps(Map<String, String> sslProps, boolean isKraft) throws IOException {
        this.brokerUUID = "uuid";
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerSessionUuidProp(), this.brokerUUID);
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.metadata.ssl.certs.path", this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "spec.json");
        props.put("listeners", "INTERNAL://localhost:0,SSL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0,SSL://localhost:0");
        props.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,CONTROLLER_SSL:SSL,INTERNAL:PLAINTEXT,SSL:SSL");
        if (isKraft) {
            props.put("controller.listener.names", "CONTROLLER_SSL,CONTROLLER");
        }
        props.put("ssl.keystore.location", this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/pkcs.p12");
        props.put("ssl.keystore.password", "ServerPassword");
        props.put("ssl.keystore.type", "PKCS12");
        props.put("ssl.endpoint.identification.algorithm", "");
        props.put("ssl.trustmanager.algorithm", "ConfluentTls");
        props.put("security.providers", "io.confluent.kafka.server.plugins.ssl.ConfluentTrustProviderCreator");
        props.put("ssl.protocol", "TLSv1.2");
        props.put("confluent.security.event.logger.authentication.enable", "true");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.putAll(sslProps);
        return props;
    }

    private Properties controllerProps(Map<String, String> sslProps) throws IOException {
        Properties props = new Properties();
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        props.put("multitenant.metadata.reload.delay.ms", TEST_CACHE_RELOAD_DELAY_MS);
        props.put("multitenant.metadata.ssl.certs.path", this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "spec.json");
        props.put("controller.listener.names", "CONTROLLER_SSL,CONTROLLER");
        props.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,CONTROLLER_SSL:SSL,INTERNAL:PLAINTEXT,SSL:SSL");
        props.put("listeners", "CONTROLLER_SSL://localhost:0,CONTROLLER://localhost:0");
        props.put("ssl.keystore.location", this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/pkcs.p12");
        props.put("ssl.keystore.password", "ServerPassword");
        props.put("ssl.keystore.type", "PKCS12");
        props.put("ssl.endpoint.identification.algorithm", "");
        props.put("ssl.trustmanager.algorithm", "ConfluentTls");
        props.put("security.providers", "io.confluent.kafka.server.plugins.ssl.ConfluentTrustProviderCreator");
        props.put("ssl.protocol", "TLSv1.2");
        props.putAll(sslProps);
        return props;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceConsumeFailsOnInvalidCertificateSync(String quorum) throws Throwable {
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster2.user(21), Collections.singletonList("testtopic1"), "group1", 0, SecurityProtocol.SSL, true, Optional.of("SSL"), this.clientProps);
        Utils.syncCerts(this.tempDir, this.invalidCertDir.toURI().toURL(), SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> {
            try {
                this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster2.user(21), Collections.singletonList("testtopic2"), "group2", 0, SecurityProtocol.SSL, false, Optional.of("SSL"), this.clientProps);
                return false;
            }
            catch (Throwable t) {
                System.out.println(t);
                Throwable cause = t;
                if (t instanceof ExecutionException) {
                    cause = t.getCause();
                }
                return cause instanceof SslAuthenticationException;
            }
        }, (long)30000L, (String)"Produce/consume invocation did not throw SslAuthenticationException");
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assertions.assertEquals((Object)AuditEventStatus.SSL_HANDSHAKE_FAILED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testControllerOperationFailsOnInvalidCertificateSync(String quorum) throws IOException, InterruptedException {
        try (Admin adminClient = this.testHarness.controllerAdminClient("ssl-cert-integration-test");){
            adminClient.describeCluster().clusterId().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Utils.syncCerts(this.tempDir, this.invalidCertDir.toURI().toURL(), SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> {
            try (Admin adminClient = this.testHarness.controllerAdminClient("ssl-cert-integration-test");){
                adminClient.describeCluster().clusterId().get();
                boolean throwable3 = false;
                return throwable3;
            }
            catch (Exception e) {
                Throwable cause = e;
                if (!(e instanceof ExecutionException)) return cause instanceof SslAuthenticationException;
                cause = e.getCause();
                return cause instanceof SslAuthenticationException;
            }
        }, (String)"Admin client invocation did not throw SslAuthenticationException");
    }
}

