/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.test.AbstractTopicBasedPlainSaslAuthIntegrationTest;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SaslAuthenticateRequestCallback;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.MockBasicAuthStore;
import io.confluent.kafka.server.plugins.auth.oauth.MockTrustCache;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandler;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import java.io.IOException;
import java.nio.file.Path;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.datapolicy.DefaultDataPolicyStore;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:2")})
public class TopicBasedDefaultDataPolicyAuthIntegrationTest
extends AbstractTopicBasedPlainSaslAuthIntegrationTest {
    public static final String TEST_WITH_PARAMETERIZED_NAMES = "{displayName}.validationMode={0}";
    public static final String TEST_WITH_PARAMETERIZED_VALIDATION_POLICY = "{displayName}.quorum={0},validationMode={1},policy={2}";
    public static final String TEST_WITH_PARAMETERIZED_VALIDATION_NETWORK = "{displayName}.quorum={0},validationMode={1},network={2}";
    private static final String NON_CONFLUENT_JWT_ISSUER = "non-confluent";
    private final String orgResourceId = Utils.LC_META_ABC.organizationId();
    private final Properties adminProperties = new Properties();
    private DefaultDataPolicyValidationMode validationMode;
    private boolean defaultDataPolicyEnabled;
    private OAuthUtils.JwsContainer jwsContainer;
    private MockBasicAuthStore authStore;
    private String brokerSessionUUID;
    private Properties serverCertStore;
    private SaslMechanism saslMechanism;

    public TopicBasedDefaultDataPolicyAuthIntegrationTest() {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.numBrokers = 1;
        this.brokerSessionUUID = UUID.randomUUID().toString();
        super.setUp(testInfo);
        this.validationMode = DefaultDataPolicyValidationMode.STRICT;
        this.defaultDataPolicyEnabled = true;
        this.authStore = MockBasicAuthStore.create((String)this.brokerSessionUUID);
        this.saslMechanism = SaslMechanism.PLAIN;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.authStore.close();
        MockAuditLogProvider.reset();
    }

    private void setUpOAuth() throws Exception {
        this.saslMechanism = SaslMechanism.OAUTHBEARER;
        int serviceUserId = 1;
        String subject = serviceUserId + "";
        this.jwsContainer = new OAuthUtils.Builder(100000, NON_CONFLUENT_JWT_ISSUER, subject, this.orgResourceId).jku("https://localhost/keys").withKid(true).build();
        MockTrustCache cache = (MockTrustCache)this.authStore.trustCache();
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        cache.put((AuthKey)new JwtIssuerKey(NON_CONFLUENT_JWT_ISSUER, null, ""), (AuthValue)new JwtIssuerValue(new JsonWebKeySet(new JsonWebKey[]{key})));
    }

    @Override
    protected List<String> getInitialTopics() {
        return Arrays.asList("_confluent-apikey", "_confluent-logical_clusters");
    }

    @Override
    protected void startWithTopic() throws Exception {
        super.startWithTopic(Optional.of(Time.SYSTEM), SecurityProtocol.SASL_SSL);
    }

    @Override
    protected Properties brokerProps(long topicLoadTimeoutMs, boolean enableLKCMetadata, SecurityProtocol externalListenerSecurityProtocol) throws Exception {
        Properties props = super.brokerProps(topicLoadTimeoutMs, enableLKCMetadata, externalListenerSecurityProtocol);
        props.put("broker.session.uuid", this.brokerSessionUUID);
        String defaultDataPolicyJassConfigEntry = "default_data_policy_validation_mode=\"" + this.validationMode.name() + "\"";
        if (this.saslMechanism == SaslMechanism.PLAIN) {
            props.put("listener.name.external.plain.sasl.jaas.config", String.format("io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required %s;", defaultDataPolicyJassConfigEntry));
        } else if (this.saslMechanism == SaslMechanism.OAUTHBEARER) {
            Path pathToConfigFile;
            props.putAll((Map<?, ?>)IntegrationTestHarness.defaultOAuthBrokerProps());
            try {
                pathToConfigFile = JarResourceLoader.loadFileFromResourceWithClassLoader(this.getClass(), (String)"AuthConfigEnhanced.yaml").toPath();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required " + defaultDataPolicyJassConfigEntry + " publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\"authenticator.jwt.config.url=\"" + pathToConfigFile + "\";");
            props.put("listener.name.external.oauthbearer.sasl.server.callback.handler.class", EnhancedOAuthBearerValidatorCallbackHandler.class.getName());
            props.put("listener.name.external.confluent.oauth.flat.networking.verification.enable", "true");
            props.put("listener.name.external.confluent.require.calling.resource.identity", "true");
        }
        this.serverCertStore = this.createSslStores();
        props.putAll((Map<?, ?>)this.serverCertStore);
        props.put("listener.name.external.ssl.client.auth", "requested");
        return props;
    }

    private Properties createSslStores() throws Exception {
        CertStores certStores = new CertStores.Builder(true).cn("kafka").addHostName("localhost").build();
        Properties props = new Properties();
        BiConsumer<String, Object> copyEntry = (k, v) -> {
            if (v instanceof Password) {
                props.setProperty((String)k, ((Password)v).value());
            } else if (v instanceof List) {
                List listOfString = (List)v;
                props.setProperty((String)k, String.join((CharSequence)",", listOfString));
            } else if (v != null) {
                props.setProperty((String)k, (String)v);
            }
        };
        certStores.keyStoreProps().forEach(copyEntry);
        certStores.trustStoreProps().forEach(copyEntry);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        return props;
    }

    private void setDefaultDataPolicy(boolean defaultDataPolicyEnabled) throws IOException {
        List<String> brokerSessionUuids = this.physicalCluster.brokerSessionUuids();
        for (String brokerSessionUuid : brokerSessionUuids) {
            DefaultDataPolicyStore.addPolicy((String)brokerSessionUuid, (String)this.environmentId, (boolean)defaultDataPolicyEnabled);
        }
    }

    @ParameterizedTest(name="{displayName}.validationMode={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyDefaultDataPolicyStore(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
    }

    @ParameterizedTest(name="{displayName}.validationMode={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyDefaultDataPolicyStoreOAuth(String quorum) throws Exception {
        this.setUpOAuth();
        this.testEmptyDefaultDataPolicyStore(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},policy={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testDisallowEnvironmentId(String quorum, String validationMode, boolean defaultDataPolicyEnabled) throws Exception {
        this.validationMode = DefaultDataPolicyValidationMode.fromString((String)validationMode);
        this.defaultDataPolicyEnabled = defaultDataPolicyEnabled;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.setDefaultDataPolicy(defaultDataPolicyEnabled);
        if (this.saslMechanism != SaslMechanism.OAUTHBEARER && this.validationMode == DefaultDataPolicyValidationMode.NONE) {
            this.assertAuthSuccess(new DefaultDataPolicyContext.Builder("env-disallow", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        } else {
            this.assertAuthFailure(new DefaultDataPolicyContext.Builder("env-disallow", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},policy={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testDisallowEnvironmentIdOAuth(String quorum, String validationMode, boolean defaultDataPolicyEnabled) throws Exception {
        this.setUpOAuth();
        this.testDisallowEnvironmentId(quorum, validationMode, defaultDataPolicyEnabled);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},network={2}")
    @CsvSource(value={"zk,strict,NOT_SET", "zk,strict,PUBLIC", "zk,strict,PRIVATE", "kraft,none,NOT_SET", "kraft,none,PUBLIC", "kraft,none,PRIVATE", "kraft,strict,NOT_SET", "kraft,strict,PUBLIC", "kraft,strict,PRIVATE"})
    public void testNetworkTypes(String quorum, String validationMode, String networkTypeStr) throws Exception {
        this.validationMode = DefaultDataPolicyValidationMode.fromString((String)validationMode);
        this.defaultDataPolicyEnabled = true;
        SaslInternalConfigs.NetworkType networkType = SaslInternalConfigs.NetworkType.fromString((String)networkTypeStr);
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.setDefaultDataPolicy(this.defaultDataPolicyEnabled);
        if (this.saslMechanism == SaslMechanism.OAUTHBEARER) {
            if (this.validationMode == DefaultDataPolicyValidationMode.NONE) {
                this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, networkType, Boolean.valueOf(true)).build());
            } else if (networkType == SaslInternalConfigs.NetworkType.PRIVATE) {
                this.assertAuthSuccess(new DefaultDataPolicyContext.Builder(this.environmentId, networkType, Boolean.valueOf(true)).build());
            } else {
                this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, networkType, Boolean.valueOf(true)).build());
            }
        } else if (this.validationMode == DefaultDataPolicyValidationMode.NONE || networkType == SaslInternalConfigs.NetworkType.PRIVATE) {
            this.assertAuthSuccess(new DefaultDataPolicyContext.Builder(this.environmentId, networkType, Boolean.valueOf(true)).build());
        } else {
            this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, networkType, Boolean.valueOf(true)).build());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},network={2}")
    @CsvSource(value={"zk,strict,NOT_SET", "zk,strict,PUBLIC", "zk,strict,PRIVATE", "kraft,none,NOT_SET", "kraft,none,PUBLIC", "kraft,none,PRIVATE", "kraft,strict,NOT_SET", "kraft,strict,PUBLIC", "kraft,strict,PRIVATE"})
    public void testNetworkTypesOAuth(String quorum, String validationMode, String networkTypeStr) throws Exception {
        this.setUpOAuth();
        this.testNetworkTypes(quorum, validationMode, networkTypeStr);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultDataPolicyChanges(String quorum) throws Exception {
        this.validationMode = DefaultDataPolicyValidationMode.STRICT;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.setDefaultDataPolicy(true);
        this.assertAuthSuccess(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd1", 3, 1));
        this.setDefaultDataPolicy(false);
        this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd2", 3, 1));
        this.setDefaultDataPolicy(true);
        this.assertAuthSuccess(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd3", 3, 1));
        this.setDefaultDataPolicy(false);
        this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultDataPolicyChangesOAuth(String quorum) throws Exception {
        this.setUpOAuth();
        this.testDefaultDataPolicyChanges(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClientCertificate(String quorum) throws Exception {
        this.validationMode = DefaultDataPolicyValidationMode.STRICT;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.setDefaultDataPolicy(true);
        this.assertAuthSuccess(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build());
        this.assertAuthFailure(new DefaultDataPolicyContext.Builder(this.environmentId, SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(false)).build());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClientCertificateOAuth(String quorum) throws Exception {
        this.setUpOAuth();
        this.testClientCertificate(quorum);
    }

    private void assertAuthSuccess(DefaultDataPolicyContext policyContext) throws Exception {
        SaslAuthenticateRequestCallback authenticateRequestCallback = new SaslAuthenticateRequestCallback(policyContext);
        try (AdminClient client = this.createSSLAuthAdminClient(authenticateRequestCallback, (Boolean)policyContext.hasSslPeerCertificate.get());){
            client.createTopics((Collection)this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
            Assertions.assertTrue((authenticateRequestCallback.callCount.get() > 0 ? 1 : 0) != 0);
            ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
            Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent());
            Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
            Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
            Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
            this.assertEventInfo(policyContext, authenticationEvent);
            SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
            Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
        }
    }

    private void assertEventInfo(DefaultDataPolicyContext expectedPolicyContext, ConfluentAuthenticationEvent authenticationEvent) {
        Optional hasSslPeerCertificate;
        Optional networkType;
        Optional environmentId;
        if (this.saslMechanism == SaslMechanism.PLAIN) {
            environmentId = ((MultiTenantSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).environmentId();
            networkType = ((MultiTenantSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).networkType();
            hasSslPeerCertificate = ((MultiTenantSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).hasSslPeerCertificate();
        } else {
            environmentId = ((OAuthBearerSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).environmentId();
            networkType = ((OAuthBearerSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).networkType();
            hasSslPeerCertificate = ((OAuthBearerSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).hasSslPeerCertificate();
        }
        Assertions.assertEquals((Object)expectedPolicyContext.environmentId, (Object)environmentId);
        Assertions.assertEquals((Object)expectedPolicyContext.networkType, (Object)networkType);
        Assertions.assertEquals((Object)expectedPolicyContext.hasSslPeerCertificate, (Object)hasSslPeerCertificate);
    }

    private void assertAuthFailure(DefaultDataPolicyContext expectedPolicyContext) throws Exception {
        SaslAuthenticateRequestCallback authenticateRequestCallback = new SaslAuthenticateRequestCallback(expectedPolicyContext);
        try (AdminClient client = this.createSSLAuthAdminClient(authenticateRequestCallback, (Boolean)expectedPolicyContext.hasSslPeerCertificate.get());){
            String expectedMessagePart;
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
            Assertions.assertTrue((authenticateRequestCallback.callCount.get() > 0 ? 1 : 0) != 0);
            ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
            Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
            if (this.saslMechanism == SaslMechanism.OAUTHBEARER && this.validationMode == DefaultDataPolicyValidationMode.NONE) {
                Assertions.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
                expectedMessagePart = "";
            } else {
                Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
                expectedMessagePart = "EnvironmentId: " + (String)expectedPolicyContext.environmentId.get() + ", NetworkType: " + ((SaslInternalConfigs.NetworkType)expectedPolicyContext.networkType.get()).name() + ", HasPeerCertificate: " + expectedPolicyContext.hasSslPeerCertificate.get() + " isn't allowed to communicate";
            }
            Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
            this.assertEventInfo(expectedPolicyContext, authenticationEvent);
            AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
            AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
            Assertions.assertTrue((boolean)errorInfo.errorMessage().contains(expectedMessagePart), (String)errorInfo.errorMessage());
        }
    }

    private AdminClient createSSLAuthAdminClient(SaslAuthenticateRequestCallback authenticateRequestCallback, boolean includeClientCertificate) {
        Properties clientCertStore = new Properties();
        if (includeClientCertificate) {
            clientCertStore.putAll((Map<?, ?>)this.serverCertStore);
        } else {
            clientCertStore.put("ssl.truststore.certificates", this.serverCertStore.get("ssl.truststore.certificates"));
            clientCertStore.put("ssl.truststore.type", this.serverCertStore.get("ssl.truststore.type"));
        }
        if (this.saslMechanism == SaslMechanism.PLAIN) {
            return this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), null, clientCertStore, authenticateRequestCallback);
        }
        Assertions.assertEquals((Object)((Object)SaslMechanism.OAUTHBEARER), (Object)((Object)this.saslMechanism));
        Properties clientProperties = new Properties();
        clientProperties.putAll((Map<?, ?>)this.adminProperties);
        clientProperties.putAll((Map<?, ?>)clientCertStore);
        return this.testHarness.createSSLOAuthAdminClient(IntegrationTestHarness.clientOAuthJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), clientProperties, authenticateRequestCallback, null);
    }

    private static enum SaslMechanism {
        PLAIN,
        OAUTHBEARER;

    }
}

