/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.test.AbstractTopicBasedPlainSaslAuthIntegrationTest;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SaslAuthenticateRequestCallback;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.MockBasicAuthStore;
import io.confluent.kafka.server.plugins.auth.oauth.MockTrustCache;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.traffic.TrafficNetworkIdAllowedRoutes;
import io.confluent.security.auth.provider.oauth.EnhancedOAuthBearerValidatorCallbackHandler;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.apache.kafka.test.TestUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:2")})
public class TopicBasedNetworkIdAuthIntegrationTest
extends AbstractTopicBasedPlainSaslAuthIntegrationTest {
    public static final String TEST_WITH_PARAMETERIZED_NAMES = "{displayName}.quorum={0},validationMode={1},routesEnabled={2}";
    private static Map<String, Object> pp2ValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PUBLIC_IP_NLB);
    private static Map<String, Object> pp2NoValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PRIVATE_LINK_NLB);
    private static final String CONFLUENT_JWT_ISSUER = "confluent";
    private final String orgResourceId = Utils.LC_META_ABC.organizationId();
    private final Properties adminProperties = new Properties();
    private static final String BROKER_NETWORK_ID = "NE-Broker";
    private static final String CLIENT_NETWORK_ID = "NE-Client";
    private final String networkIdTopic = "_confluent-network_id_routes";
    private ObjectMapper objectMapper;
    private boolean useProxyProtocol;
    private TrafficNetworkIdValidationMode validationMode;
    private boolean routesEnabled;
    private boolean createNetworkIdTopic;
    private String allowedNetworkId;
    private SaslMechanism saslMechanism;
    private OAuthUtils.JwsContainer jwsContainer;
    private MockBasicAuthStore authStore;
    private String brokerSessionUUID;

    public TopicBasedNetworkIdAuthIntegrationTest() {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        this.networkIdTopic = "_confluent-network_id_routes";
        this.createNetworkIdTopic = true;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.numBrokers = 1;
        this.brokerSessionUUID = UUID.randomUUID().toString();
        super.setUp(testInfo);
        this.useProxyProtocol = false;
        this.saslMechanism = SaslMechanism.PLAIN;
        this.allowedNetworkId = CLIENT_NETWORK_ID;
        this.objectMapper = new ObjectMapper();
        this.validationMode = TrafficNetworkIdValidationMode.STRICT;
        this.routesEnabled = true;
        int serviceUserId = 1;
        String subject = serviceUserId + "";
        this.jwsContainer = new OAuthUtils.Builder(100000, CONFLUENT_JWT_ISSUER, subject, this.orgResourceId).jku("https://localhost/keys").withKid(true).build();
        this.authStore = MockBasicAuthStore.create((String)this.brokerSessionUUID);
        MockTrustCache cache = (MockTrustCache)this.authStore.trustCache();
        RsaJsonWebKey key = new RsaJsonWebKey((RSAPublicKey)this.jwsContainer.verificationKey());
        key.setKeyId(this.jwsContainer.getKid());
        cache.put((AuthKey)new JwtIssuerKey(CONFLUENT_JWT_ISSUER, null, ""), (AuthValue)new JwtIssuerValue(new JsonWebKeySet(new JsonWebKey[]{key})));
    }

    private List<String> getAllowedNetworkIds() {
        return Arrays.asList("foo", this.allowedNetworkId, "bar");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.authStore.close();
        MockAuditLogProvider.reset();
    }

    @Override
    protected List<String> getInitialTopics() {
        if (this.createNetworkIdTopic) {
            return Arrays.asList("_confluent-apikey", "_confluent-logical_clusters", "_confluent-network_id_routes");
        }
        return Arrays.asList("_confluent-apikey", "_confluent-logical_clusters");
    }

    @Override
    protected void startWithTopic() throws Exception {
        super.startWithTopic(Optional.of(Time.SYSTEM), SecurityProtocol.SASL_PLAINTEXT);
    }

    @Override
    protected Properties brokerProps(long topicLoadTimeoutMs, boolean enableLKCMetadata, SecurityProtocol externalListenerSecurityProtocol) throws Exception {
        String networkIdValidationJassConfigEntry;
        Properties props = super.brokerProps(topicLoadTimeoutMs, enableLKCMetadata, externalListenerSecurityProtocol);
        props.put("broker.session.uuid", this.brokerSessionUUID);
        if (this.useProxyProtocol) {
            networkIdValidationJassConfigEntry = "";
            props.put("listener.name.external.confluent.proxy.protocol.version", ProxyProtocol.V2.name());
            props.put("listener.name.external.confluent.proxy.protocol.fallback.enabled", "true");
        } else {
            networkIdValidationJassConfigEntry = "traffic_network_id_validation_mode=\"" + this.validationMode.name() + "\"";
        }
        if (this.saslMechanism == SaslMechanism.OAUTHBEARER) {
            Path pathToConfigFile;
            props.putAll((Map<?, ?>)IntegrationTestHarness.defaultOAuthBrokerProps());
            try {
                pathToConfigFile = JarResourceLoader.loadFileFromResourceWithClassLoader(this.getClass(), (String)"AuthConfigEnhanced.yaml").toPath();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required " + networkIdValidationJassConfigEntry + " publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\"authenticator.jwt.config.url=\"" + pathToConfigFile + "\";");
            props.put("listener.name.external.oauthbearer.sasl.server.callback.handler.class", EnhancedOAuthBearerValidatorCallbackHandler.class.getName());
        } else {
            props.put("listener.name.external.plain.sasl.jaas.config", String.format("io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required %s;", networkIdValidationJassConfigEntry));
        }
        props.put("confluent.traffic.cdc.network.id.routes.enable", (Object)this.routesEnabled);
        props.put("confluent.traffic.cdc.network.id.routes.topic.name", "_confluent-network_id_routes");
        props.put("confluent.traffic.network.id", BROKER_NETWORK_ID);
        props.put("confluent.traffic.cdc.network.id.routes.periodic.start.task.ms", (Object)100);
        return props;
    }

    private String encodeValue(List<String> allowedNetworkIds) throws IOException {
        TrafficNetworkIdAllowedRoutes routes = new TrafficNetworkIdAllowedRoutes(allowedNetworkIds, null);
        StringWriter writer = new StringWriter();
        this.objectMapper.writeValue((Writer)writer, (Object)routes);
        return writer.toString();
    }

    private void loadAllowedNetworkIds(List<String> allowedNetworkIds) throws IOException {
        List<String> brokerSessionUuids = this.physicalCluster.brokerSessionUuids();
        this.physicalCluster.kafkaCluster().produceData("_confluent-network_id_routes", this.baseSequenceId++, this.getAllowedNetworkIdsKey(), this.encodeValue(allowedNetworkIds));
        allowedNetworkIds.forEach(nr -> {
            try {
                TestUtils.waitForCondition(() -> brokerSessionUuids.stream().allMatch(brokerSessionUuid -> TrafficNetworkIdRoutesStore.getRoutes((String)brokerSessionUuid) != null && TrafficNetworkIdRoutesStore.getRoutes((String)brokerSessionUuid).allows(nr)), (String)"Expected metadata to get consumed");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getAllowedNetworkIdsKey() {
        return "NE-Broker:pkc-foo";
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidNetworkIdWithMissingRoutesTopic(String quorum) throws Exception {
        this.validationMode = TrafficNetworkIdValidationMode.STRICT;
        this.routesEnabled = true;
        this.createNetworkIdTopic = false;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.assertAuthFailure(this.allowedNetworkId);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidNetworkIdWithMissingRoutesTopicOAuth(String quorum) throws Exception {
        this.saslMechanism = SaslMechanism.OAUTHBEARER;
        this.testValidNetworkIdWithMissingRoutesTopic(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testValidNetworkId(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.validationMode = TrafficNetworkIdValidationMode.fromString((String)validationMode);
        this.routesEnabled = routesEnabled;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        if (routesEnabled) {
            this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        }
        if (this.validationMode == TrafficNetworkIdValidationMode.STRICT && !routesEnabled) {
            this.assertAuthFailure(this.allowedNetworkId);
        } else {
            this.assertAuthSuccess(this.allowedNetworkId);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testValidNetworkIdPP2(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.useProxyProtocol = true;
        this.testValidNetworkId(quorum, validationMode, routesEnabled);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false"})
    public void testValidNetworkIdOAuth(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.saslMechanism = SaslMechanism.OAUTHBEARER;
        this.testValidNetworkId(quorum, validationMode, routesEnabled);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testValidNetworkIdOAuthPP2(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.saslMechanism = SaslMechanism.OAUTHBEARER;
        this.useProxyProtocol = true;
        this.testValidNetworkId(quorum, validationMode, routesEnabled);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testInvalidNetworkIdPP2(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.useProxyProtocol = true;
        this.testInvalidNetworkId(quorum, validationMode, routesEnabled);
    }

    @ParameterizedTest(name="{displayName}.quorum={0},validationMode={1},routesEnabled={2}")
    @CsvSource(value={"zk,strict,true", "zk,strict,false", "zk,none,true", "zk,none,false", "kraft,strict,true", "kraft,strict,false", "kraft,none,true", "kraft,none,false"})
    public void testInvalidNetworkId(String quorum, String validationMode, boolean routesEnabled) throws Exception {
        this.validationMode = TrafficNetworkIdValidationMode.fromString((String)validationMode);
        this.routesEnabled = routesEnabled;
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        if (routesEnabled) {
            this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        }
        String networkId = "InvalidNetworkIdFoo";
        if (this.validationMode == TrafficNetworkIdValidationMode.NONE) {
            this.assertAuthSuccess(networkId);
        } else {
            this.assertAuthFailure(networkId);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRouteChanges(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        this.assertAuthSuccess(this.allowedNetworkId);
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd1", 3, 1));
        this.loadAllowedNetworkIds(Arrays.asList("nr1", "nr2"));
        this.assertAuthFailure(this.allowedNetworkId);
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd2", 3, 1));
        this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        this.assertAuthSuccess(this.allowedNetworkId);
        this.resetAuditEvents();
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd3", 3, 1));
        this.loadAllowedNetworkIds(Collections.emptyList());
        this.assertAuthFailure(this.allowedNetworkId);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRouteChangesShouldForceDisconnectClientOAuth(String quorum) throws Exception {
        this.saslMechanism = SaslMechanism.OAUTHBEARER;
        this.testRouteChangesShouldForceDisconnectClient(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRouteChangesShouldForceDisconnectClient(String quorum) throws Exception {
        this.startWithTopic();
        this.loadApiKeys();
        this.loadLKCMetadata();
        this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        this.assertForceDisconnectOnDisallowNetwork(Collections.singletonList("nr1"));
        this.allowedNetworkId = "NE-Client-new";
        this.loadAllowedNetworkIds(this.getAllowedNetworkIds());
        this.sampleTopics = Collections.singletonList(new NewTopic("abcd1", 3, 1));
        this.assertForceDisconnectOnDisallowNetwork(Collections.emptyList());
    }

    private void assertForceDisconnectOnDisallowNetwork(List<String> newRoutes) throws InterruptedException, ExecutionException, IOException {
        SaslAuthenticateRequestCallback authenticateRequestCallback = new SaslAuthenticateRequestCallback(this.allowedNetworkId);
        try (AdminClient client = this.createAuthAdminClient(authenticateRequestCallback);){
            client.createTopics((Collection)this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.waitForCondition(() -> ((Set)client.listTopics().names().get()).containsAll(expectedTopics), (String)"Expected Topics should get created");
            Assertions.assertTrue((authenticateRequestCallback.callCount.get() > 0 ? 1 : 0) != 0);
            this.loadAllowedNetworkIds(newRoutes);
            TestUtils.waitForCondition(() -> TopicBasedNetworkIdAuthIntegrationTest.assertFutureError(client.listTopics().names(), SaslAuthenticationException.class), (String)"Client should be disconnected on disallow network");
        }
    }

    private static boolean assertFutureError(Future<?> future, Class<? extends Throwable> exceptionClass) throws InterruptedException {
        try {
            future.get();
            return false;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assertions.assertEquals(exceptionClass, cause.getClass(), (String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got " + cause.getClass().getSimpleName()));
            return true;
        }
    }

    private void assertAuthSuccess(String networkId) throws Exception {
        SaslAuthenticateRequestCallback authenticateRequestCallback = new SaslAuthenticateRequestCallback(networkId);
        try (AdminClient client = this.createAuthAdminClient(authenticateRequestCallback);){
            client.createTopics((Collection)this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
            Assertions.assertTrue((authenticateRequestCallback.callCount.get() > 0 ? 1 : 0) != 0);
            ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
            Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent());
            Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
            Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
            Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
            this.assertEventNetworkId(networkId, authenticationEvent);
            SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
            Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
        }
    }

    private void assertEventNetworkId(String expectedNetworkId, ConfluentAuthenticationEvent authenticationEvent) {
        Optional networkId = this.saslMechanism == SaslMechanism.OAUTHBEARER ? ((OAuthBearerSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).networkId() : ((MultiTenantSaslServer)((SaslAuthenticationContext)authenticationEvent.authenticationContext()).server()).networkId();
        Assertions.assertEquals(Optional.of(expectedNetworkId), (Object)networkId);
    }

    private ProxyProtocolEngineFactory proxyProtocolEngineFactory() {
        if (this.useProxyProtocol) {
            HashMap<String, Object> clientConfigs = new HashMap<String, Object>();
            clientConfigs.put("confluent.proxy.protocol.client.address", "1.1.1.1");
            clientConfigs.put("confluent.proxy.protocol.client.port", 1111);
            clientConfigs.put("confluent.proxy.protocol.client.mode", ConfluentConfigs.PROXY_PROTOCOL_CLIENT_MODE_DEFAULT);
            if (this.validationMode == TrafficNetworkIdValidationMode.STRICT) {
                clientConfigs.putAll(pp2ValidateTrafficHeader);
            } else {
                clientConfigs.putAll(pp2NoValidateTrafficHeader);
            }
            return new ProxyProtocolEngineFactory(ProxyProtocol.V2, clientConfigs, Mode.CLIENT, new LogContext());
        }
        return null;
    }

    private void assertAuthFailure(String networkId) throws Exception {
        String expectedMessagePart = this.routesEnabled && this.createNetworkIdTopic ? "NetworkId: " + networkId + " isn't allowed to communicate" : "NetworkId: " + networkId + " validation failed due to an internal error";
        SaslAuthenticateRequestCallback authenticateRequestCallback = new SaslAuthenticateRequestCallback(networkId);
        try (AdminClient client = this.createAuthAdminClient(authenticateRequestCallback);){
            KafkaFuture future = client.createTopics((Collection)this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
            Assertions.assertTrue((authenticateRequestCallback.callCount.get() > 0 ? 1 : 0) != 0);
            ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
            Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent());
            Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
            Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
            this.assertEventNetworkId(networkId, authenticationEvent);
            AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
            AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
            Assertions.assertTrue((boolean)errorInfo.errorMessage().contains(expectedMessagePart), (String)errorInfo.errorMessage());
        }
    }

    private AdminClient createAuthAdminClient(SaslAuthenticateRequestCallback authenticateRequestCallback) {
        if (this.saslMechanism == SaslMechanism.OAUTHBEARER) {
            return this.testHarness.createOAuthAdminClient(IntegrationTestHarness.clientOAuthJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, authenticateRequestCallback, this.proxyProtocolEngineFactory());
        }
        return this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), new Properties(), authenticateRequestCallback, this.proxyProtocolEngineFactory());
    }

    private static enum SaslMechanism {
        PLAIN,
        OAUTHBEARER;

    }
}

