/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class UserMetaDataStoreIntegrationTest {
    static final String KEY1 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r1\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE1 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u1\",", "  \"ActiveLkcIds\": [\"lkc1\", \"lkc2\"]", "}");
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r2\",", "  \"OrgResourceId\": \"org2\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u2\",", "  \"ActiveLkcIds\": [\"lkc3\", \"lkc4\"]", "}");
    static final String KEY3 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r3\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE3 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u3\",", "  \"ActiveLkcIds\": [\"lkc1\", \"lkc2\"]", "}");
    static final String INVALID_KEY1 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r3\",", "}");
    private final String userMetaDataTopic = "_confluent-user_metadata";
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private int numBrokers = 3;
    private final String apiKeysTopic = "_confluent-apikey";

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testHarness = new IntegrationTestHarness(testInfo, this.numBrokers);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    protected void startWithTopic() throws Exception {
        long topicCreateTimeout = 15000L;
        long topicLoadTimeoutMs = topicCreateTimeout + TimeUnit.SECONDS.toMillis(3L);
        this.physicalCluster = this.testHarness.startWithTopic(this.getInitialTopics(), 1, 1, topicCreateTimeout, this.brokerProps(topicLoadTimeoutMs), this.nodeProps(topicLoadTimeoutMs), Optional.empty());
    }

    protected Properties brokerProps(long topicLoadTimeoutMs) throws IOException, InterruptedException {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        props.putAll((Map<?, ?>)this.nodeProps(topicLoadTimeoutMs));
        return props;
    }

    protected Properties nodeProps(long topicLoadTimeoutMs) throws IOException {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.topic.load.timeout.ms", String.valueOf(topicLoadTimeoutMs));
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        props.put("sasl.server.max.receive.size", "1024");
        props.put("confluent.cdc.user.metadata.enable", "true");
        return props;
    }

    protected List<String> getInitialTopics() {
        return Arrays.asList("_confluent-apikey", "_confluent-user_metadata");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserMetaData(String quorum) throws Exception {
        this.startWithTopic();
        List<DefaultUserMetaDataStore> instances = this.physicalCluster.userMetaDataStoreInstances();
        List<String> userMetaDataKeys = Arrays.asList(KEY1, KEY2, KEY3, INVALID_KEY1);
        List<String> userMetaDataValues = Arrays.asList(VALUE1, VALUE2, VALUE3, VALUE3);
        for (int i = 0; i < userMetaDataKeys.size(); ++i) {
            this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", Long.valueOf(100L) + (long)i, userMetaDataKeys.get(i), userMetaDataValues.get(i));
        }
        this.physicalCluster.kafkaCluster().produceData("_confluent-user_metadata", 100L, KEY1, VALUE2);
        TestUtils.waitForCondition(() -> instances.stream().allMatch(i -> i.numOfMapping() == 3 && ((String)i.userIdToUserResourceId("u1").get()).equals("r1") && TestUtils.getMetricValue((Metrics)i.metrics(), (String)"user-metadata-event-rate") > 0.0 && TestUtils.getMetricValue((Metrics)i.metrics(), (String)"user-metadata-event-failure-rate") > 0.0 && TestUtils.getMetricValue((Metrics)i.metrics(), (String)"user-metadata-count") == 3.0), (String)"Expected user metadata stored correctly");
    }
}

