/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.schema.MultiTenantApis;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiTenantApisTest {
    private final Map<ApiKeys, Integer> maxVerifiedVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.PRODUCE, (Object)11), Utils.mkEntry((Object)ApiKeys.FETCH, (Object)16), Utils.mkEntry((Object)ApiKeys.LIST_OFFSETS, (Object)8), Utils.mkEntry((Object)ApiKeys.METADATA, (Object)12), Utils.mkEntry((Object)ApiKeys.OFFSET_COMMIT, (Object)9), Utils.mkEntry((Object)ApiKeys.OFFSET_FETCH, (Object)9), Utils.mkEntry((Object)ApiKeys.FIND_COORDINATOR, (Object)5), Utils.mkEntry((Object)ApiKeys.JOIN_GROUP, (Object)9), Utils.mkEntry((Object)ApiKeys.HEARTBEAT, (Object)4), Utils.mkEntry((Object)ApiKeys.LEAVE_GROUP, (Object)5), Utils.mkEntry((Object)ApiKeys.SYNC_GROUP, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_GROUPS, (Object)5), Utils.mkEntry((Object)ApiKeys.LIST_GROUPS, (Object)5), Utils.mkEntry((Object)ApiKeys.DELETE_GROUPS, (Object)2), Utils.mkEntry((Object)ApiKeys.SASL_HANDSHAKE, (Object)1), Utils.mkEntry((Object)ApiKeys.API_VERSIONS, (Object)3), Utils.mkEntry((Object)ApiKeys.CREATE_TOPICS, (Object)7), Utils.mkEntry((Object)ApiKeys.DELETE_TOPICS, (Object)6), Utils.mkEntry((Object)ApiKeys.DELETE_RECORDS, (Object)2), Utils.mkEntry((Object)ApiKeys.INIT_PRODUCER_ID, (Object)5), Utils.mkEntry((Object)ApiKeys.ADD_PARTITIONS_TO_TXN, (Object)3), Utils.mkEntry((Object)ApiKeys.ADD_OFFSETS_TO_TXN, (Object)4), Utils.mkEntry((Object)ApiKeys.END_TXN, (Object)4), Utils.mkEntry((Object)ApiKeys.TXN_OFFSET_COMMIT, (Object)4), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CONFIGS, (Object)4), Utils.mkEntry((Object)ApiKeys.ALTER_CONFIGS, (Object)2), Utils.mkEntry((Object)ApiKeys.INCREMENTAL_ALTER_CONFIGS, (Object)1), Utils.mkEntry((Object)ApiKeys.SASL_AUTHENTICATE, (Object)2), Utils.mkEntry((Object)ApiKeys.CREATE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.DESCRIBE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.DELETE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.CREATE_PARTITIONS, (Object)3), Utils.mkEntry((Object)ApiKeys.OFFSET_FOR_LEADER_EPOCH, (Object)4), Utils.mkEntry((Object)ApiKeys.REPLICA_STATUS, (Object)4), Utils.mkEntry((Object)ApiKeys.OFFSET_DELETE, (Object)0), Utils.mkEntry((Object)ApiKeys.CREATE_CLUSTER_LINKS, (Object)4), Utils.mkEntry((Object)ApiKeys.LIST_CLUSTER_LINKS, (Object)5), Utils.mkEntry((Object)ApiKeys.DELETE_CLUSTER_LINKS, (Object)2), Utils.mkEntry((Object)ApiKeys.ALTER_MIRRORS, (Object)9), Utils.mkEntry((Object)ApiKeys.LIST_MIRRORS, (Object)1), Utils.mkEntry((Object)ApiKeys.DESCRIBE_MIRRORS, (Object)8), Utils.mkEntry((Object)ApiKeys.INITIATE_REVERSE_CONNECTIONS, (Object)1), Utils.mkEntry((Object)ApiKeys.REVERSE_CONNECTION, (Object)1), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER, (Object)1), Utils.mkEntry((Object)ApiKeys.ALLOCATE_PRODUCER_IDS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER_LINKS, (Object)4), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_DESCRIBE, (Object)0), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_HEARTBEAT, (Object)0)});
    private final Map<ApiKeys, Integer> maxVerifiedSbcApiVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.REMOVE_BROKERS, (Object)1), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_REMOVALS, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_ADDITIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BALANCER_STATUS, (Object)1), Utils.mkEntry((Object)ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD, (Object)1), Utils.mkEntry((Object)ApiKeys.COMPUTE_EVEN_CLUSTER_LOAD_PLAN, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_EVEN_CLUSTER_LOAD_STATUS, (Object)1), Utils.mkEntry((Object)ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS, (Object)0), Utils.mkEntry((Object)ApiKeys.DESCRIBE_BROKER_REPLICA_EXCLUSIONS, (Object)0)});
    private final Set<ApiKeys> clusterLinkUpdateApis = Utils.mkSet((Object[])new ApiKeys[]{ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.DELETE_CLUSTER_LINKS, ApiKeys.ALTER_MIRRORS});

    @Test
    public void testIsApiAllowedHandlesAllApiVersions() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> unverifiedVersionApis = new HashSet<ApiKeys>();
        HashMap<ApiKeys, Integer> maxVersions = new HashMap<ApiKeys, Integer>(this.maxVerifiedVersions);
        for (boolean sbcApisEnabled : Arrays.asList(true, false)) {
            if (sbcApisEnabled) {
                maxVersions.putAll(this.maxVerifiedSbcApiVersions);
            }
            MultiTenantApis multiTenantApis = new MultiTenantApis(sbcApisEnabled);
            for (ApiKeys api : ApiKeys.zkBrokerApis()) {
                Iterator iterator = api.allVersions().iterator();
                while (iterator.hasNext()) {
                    short version = (Short)iterator.next();
                    try {
                        Optional maxValidatedVersion;
                        if (!multiTenantApis.isApiAllowed(api, version) || (maxValidatedVersion = Optional.ofNullable(maxVersions.get(api))).isPresent() && version <= (Integer)maxValidatedVersion.get()) continue;
                        unverifiedVersionApis.add(api);
                    }
                    catch (IllegalArgumentException e) {
                        unhandledApis.add(api);
                    }
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following APIs are not handled: " + unhandledApis));
        Assertions.assertEquals(Collections.emptySet(), unverifiedVersionApis, (String)("The following exposed APIs have unverified version bumps: " + unhandledApis));
    }

    @Test
    public void testSbcApisAreDisabledByDefault() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> allowedApis = new HashSet<ApiKeys>();
        Properties props = new Properties();
        props.put("zookeeper.connect", TestUtils.MockZkConnect());
        props.put("listeners", "PLAINTEXT://localhost:9092");
        MultiTenantInterceptorConfig config = new MultiTenantInterceptorConfig(new KafkaConfig((Map)props).valuesFromThisConfig());
        MultiTenantApis multiTenantApis = new MultiTenantApis(config.sbcApisEnabled());
        for (ApiKeys sbcApi : this.maxVerifiedSbcApiVersions.keySet()) {
            Iterator iterator = sbcApi.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    boolean isAllowed = multiTenantApis.isApiAllowed(sbcApi, version);
                    if (!isAllowed) continue;
                    allowedApis.add(sbcApi);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(sbcApi);
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following SBC APIs are not handled: " + unhandledApis));
        Assertions.assertEquals(Collections.emptySet(), allowedApis, (String)("The following SBC APIs were exposed when they shouldn't have been: " + allowedApis));
    }

    @Test
    public void testSbcApisAreAllowedWhenEnabled() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> notAllowed = new HashSet<ApiKeys>();
        Properties props = new Properties();
        props.put("zookeeper.connect", TestUtils.MockZkConnect());
        props.put("listeners", "PLAINTEXT://localhost:9092");
        props.put("confluent.multitenant.interceptor.balancer.apis.enabled", "true");
        MultiTenantInterceptorConfig config = new MultiTenantInterceptorConfig(new KafkaConfig((Map)props).valuesFromThisConfig());
        MultiTenantApis multiTenantApis = new MultiTenantApis(config.sbcApisEnabled());
        for (ApiKeys sbcApi : this.maxVerifiedSbcApiVersions.keySet()) {
            Iterator iterator = sbcApi.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    boolean isAllowed = multiTenantApis.isApiAllowed(sbcApi, version);
                    if (isAllowed) continue;
                    notAllowed.add(sbcApi);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(sbcApi);
                }
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following SBC APIs are not handled: " + unhandledApis));
        Assertions.assertEquals(Collections.emptySet(), notAllowed, (String)("The following SBC APIs were not exposed when they should have been: " + notAllowed));
    }

    @Test
    public void testClusterLinkUpdates() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> notAllowedApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> allowedApis = new HashSet<ApiKeys>();
        MultiTenantApis multiTenantApis = new MultiTenantApis(false);
        for (ApiKeys api : this.clusterLinkUpdateApis) {
            Iterator iterator = api.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                try {
                    if (multiTenantApis.isApiAllowed(api, version)) continue;
                    notAllowedApis.add(api);
                }
                catch (IllegalArgumentException e) {
                    unhandledApis.add(api);
                }
            }
            if (notAllowedApis.contains(api)) continue;
            allowedApis.add(api);
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis);
        Assertions.assertEquals(Collections.emptySet(), notAllowedApis);
        Assertions.assertEquals(this.clusterLinkUpdateApis, allowedApis);
    }
}

