/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authenticator;

import io.confluent.kafka.security.authenticator.OAuthKafkaPrincipalBuilder;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OAuthKafkaPrincipalBuilderTest {
    private static Stream<Arguments> principalClaimNameAndValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"alice", "sub"}), Arguments.of((Object[])new Object[]{"bob", "customSubClaim"}));
    }

    @Test
    public void testPrincipalBuilderOAuthBearer() throws Exception {
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createUnsecuredJws("Confluent", "alice", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @ParameterizedTest
    @MethodSource(value={"principalClaimNameAndValue"})
    public void testPrincipalBuilderOAuthBearerClientCredentials(String principalName, String principalClaimName) throws Exception {
        OAuthBearerToken oauthToken = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String customSubClaim = "bob";
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        String oauthTokenValue = this.createUnsecuredJws("issuer", "alice", principalClaimName, "roles", "bob", "g1", "g2").value();
        Mockito.when((Object)oauthToken.value()).thenReturn((Object)oauthTokenValue);
        Mockito.when((Object)oauthToken.principalName()).thenReturn((Object)principalName);
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)oauthToken);
        builder.configure((Map)ImmutableMap.singleton((Object)"confluent.oauth.groups.claim.name", (Object)"roles"));
        KafkaPrincipal oauthPrincipal = builder.build((AuthenticationContext)new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertTrue((boolean)(oauthPrincipal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)oauthPrincipal.getPrincipalType());
        Assertions.assertEquals((Object)principalName, (Object)oauthPrincipal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)oauthPrincipal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)oauthPrincipal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)oauthToken, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)oauthToken, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_ConfluentPrincipal() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        OAuthKafkaPrincipalBuilder cpBuilder = new OAuthKafkaPrincipalBuilder();
        KafkaPrincipal copy = cpBuilder.deserialize(cpBuilder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals((Object)p, (Object)copy);
        Assertions.assertTrue((boolean)(copy instanceof ConfluentPrincipal));
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)copy).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)copy).getGroups().containsAll(new HashSet<String>(Arrays.asList("g1", "g2"))));
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipal() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        OAuthKafkaPrincipalBuilder cpBuilder = new OAuthKafkaPrincipalBuilder();
        cpBuilder.configure(Collections.emptyMap());
        KafkaPrincipal copy = cpBuilder.deserialize(cpBuilder.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
    }

    @Test
    public void testDefaultKafkaPrincipalBuilderSerde_ConfluentPrincipal() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        DefaultKafkaPrincipalBuilder defaultBuilder = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal copy = defaultBuilder.deserialize(defaultBuilder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
        Assertions.assertEquals((Object)p.getPrincipalType(), (Object)copy.getPrincipalType());
        Assertions.assertEquals((Object)p.getName(), (Object)copy.getName());
        Assertions.assertEquals((Object)p.tokenAuthenticated(), (Object)copy.tokenAuthenticated());
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipalCompatibility() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        DefaultKafkaPrincipalBuilder defaultSerializer = new DefaultKafkaPrincipalBuilder(null, null);
        OAuthKafkaPrincipalBuilder cpDeserializer = new OAuthKafkaPrincipalBuilder();
        cpDeserializer.configure(Collections.emptyMap());
        KafkaPrincipal copy = cpDeserializer.deserialize(defaultSerializer.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
    }

    @Test
    public void testOAuthKafkaPrincipalBuilderSerde_KafkaPrincipalBuilderCompatibility() {
        ConfluentPrincipal p = new ConfluentPrincipal("User", "Alice", "Alice", Optional.empty(), false, new HashSet<String>(Arrays.asList("g1", "g2")));
        OAuthKafkaPrincipalBuilder cpSerializer = new OAuthKafkaPrincipalBuilder();
        DefaultKafkaPrincipalBuilder defaultDeserializer = new DefaultKafkaPrincipalBuilder(null, null);
        KafkaPrincipal copy = defaultDeserializer.deserialize(cpSerializer.serialize((KafkaPrincipal)p));
        Assertions.assertEquals(KafkaPrincipal.class, copy.getClass());
        Assertions.assertEquals((Object)p.getPrincipalType(), (Object)copy.getPrincipalType());
        Assertions.assertEquals((Object)p.getName(), (Object)copy.getName());
        Assertions.assertEquals((Object)p.tokenAuthenticated(), (Object)copy.tokenAuthenticated());
    }

    @Test
    public void testConfluentPrincipalBuilderWithSslPrincipalMapper() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Duke, OU=ServiceUsers, O=Org, C=US")).thenReturn((Object)new X500Principal("CN=Duke, OU=SME, O=mycp, L=Fulton, ST=MD, C=US")).thenReturn((Object)new X500Principal("CN=duke, OU=JavaSoft, O=Sun Microsystems")).thenReturn((Object)new X500Principal("OU=JavaSoft, O=Sun Microsystems, C=US"));
        String rules = String.join((CharSequence)", ", "RULE:^CN=(.*),OU=ServiceUsers.*$/$1/L", "RULE:^CN=(.*),OU=(.*),O=(.*),L=(.*),ST=(.*),C=(.*)$/$1@$2/L", "RULE:^.*[Cc][Nn]=([a-zA-Z0-9.]*).*$/$1/U", "DEFAULT");
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        builder.configure(Collections.singletonMap("ssl.principal.mapping.rules", rules));
        SslAuthenticationContext sslContext = new SslAuthenticationContext(session, InetAddress.getLocalHost(), SecurityProtocol.PLAINTEXT.name());
        KafkaPrincipal principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"duke", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"duke@sme", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"DUKE", (Object)principal.getName());
        principal = builder.build((AuthenticationContext)sslContext);
        Assertions.assertEquals((Object)"OU=JavaSoft,O=Sun Microsystems,C=US", (Object)principal.getName());
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)4))).getPeerPrincipal();
    }

    @Test
    public void testConfluentPrincipalBuilderGssapi() throws Exception {
        SaslServer server = (SaslServer)Mockito.mock(SaslServer.class);
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"GSSAPI");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"foo/host@REALM.COM");
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        builder.configure(Collections.singletonMap("sasl.kerberos.principal.to.local.rules", Collections.singletonList("RULE:[2:$1]")));
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext(server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"foo", (Object)principal.getName());
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((SaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getAuthorizationID();
    }

    @Test
    public void testImpersonatedTokenWithRequiredSSLSuccess() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "CN=Rp,OU=ServiceUsers,O=Org,C=US";
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Rp, OU=ServiceUsers, O=Org, C=US"));
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "CN=Rp,OU=ServiceUsers,O=Org,C=US", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        SaslAuthenticationContext context = new SaslAuthenticationContext(-1L, (SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name(), Optional.of(session), false);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        HashMap<String, String> configs = new HashMap<String, String>(){
            {
                this.put("ssl.client.auth", "required");
            }
        };
        builder.configure((Map)configs);
        KafkaPrincipal principal = builder.build((AuthenticationContext)context);
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.atLeastOnce())).getPeerPrincipal();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testImpersonatedTokenWithRequiredSSLPrincipalMismatch() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "someOtherUser";
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Rp, OU=ServiceUsers, O=Org, C=US"));
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "someOtherUser", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        SaslAuthenticationContext context = new SaslAuthenticationContext(-1L, (SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name(), Optional.of(session), false);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        HashMap<String, String> configs = new HashMap<String, String>(){
            {
                this.put("ssl.client.auth", "required");
            }
        };
        builder.configure((Map)configs);
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> builder.build((AuthenticationContext)context));
        Assertions.assertEquals((Object)"Impersonation identity mismatch for 'alice'", (Object)exception.getMessage());
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.atLeastOnce())).getPeerPrincipal();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testImpersonatedTokenWithoutSSL() throws Exception {
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "rp";
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "rp", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        KafkaPrincipal principal = builder.build((AuthenticationContext)new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_PLAINTEXT.name()));
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testImpersonatedTokenWithRequestedSSL() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "rp";
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=NOMATCH, OU=ServiceUsers, O=Org, C=US"));
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "rp", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        SaslAuthenticationContext context = new SaslAuthenticationContext(-1L, (SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name(), Optional.of(session), false);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        HashMap<String, String> configs = new HashMap<String, String>(){
            {
                this.put("ssl.client.auth", "requested");
            }
        };
        builder.configure((Map)configs);
        KafkaPrincipal principal = builder.build((AuthenticationContext)context);
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).getPeerPrincipal();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testImpersonatedTokenWithNoneSSL() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "rp";
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=NOMATCH, OU=ServiceUsers, O=Org, C=US"));
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "rp", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        SaslAuthenticationContext context = new SaslAuthenticationContext(-1L, (SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name(), Optional.of(session), false);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        HashMap<String, String> configs = new HashMap<String, String>(){
            {
                this.put("ssl.client.auth", "none");
            }
        };
        builder.configure((Map)configs);
        KafkaPrincipal principal = builder.build((AuthenticationContext)context);
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((SSLSession)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).getPeerPrincipal();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    @Test
    public void testImpersonatedTokenWithRequiredSSLButValidationSkip() throws Exception {
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        OAuthBearerToken token = (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class);
        OAuthBearerSaslServer server = (OAuthBearerSaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        String sub = "alice";
        String impersonatedBy = "something-wrong";
        Mockito.when((Object)session.getPeerPrincipal()).thenReturn((Object)new X500Principal("CN=Rp, OU=ServiceUsers, O=Org, C=US"));
        Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"OAUTHBEARER");
        Mockito.when((Object)server.getAuthorizationID()).thenReturn((Object)"alice");
        Mockito.when((Object)server.getNegotiatedProperty("OAUTHBEARER.token")).thenReturn((Object)token);
        Mockito.when((Object)token.principalName()).thenReturn((Object)"alice");
        String tokenValue = this.createImpersonatedUnsecuredJws("Confluent", "alice", "something-wrong", "sub", "groups", "abcde", "g1", "g2").value();
        Mockito.when((Object)token.value()).thenReturn((Object)tokenValue);
        SaslAuthenticationContext context = new SaslAuthenticationContext(-1L, (SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name(), Optional.of(session), false);
        OAuthKafkaPrincipalBuilder builder = new OAuthKafkaPrincipalBuilder();
        HashMap<String, String> configs = new HashMap<String, String>(){
            {
                this.put("ssl.client.auth", "required");
                this.put("token.impersonation.validation", "false");
            }
        };
        builder.configure((Map)configs);
        KafkaPrincipal principal = builder.build((AuthenticationContext)context);
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertTrue((boolean)(principal instanceof ConfluentPrincipal));
        Assertions.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assertions.assertEquals((Object)"alice", (Object)principal.getName());
        Assertions.assertEquals((int)2, (int)((ConfluentPrincipal)principal).getGroups().size());
        Assertions.assertTrue((boolean)((ConfluentPrincipal)principal).getGroups().containsAll(Arrays.asList("g1", "g2")));
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getMechanismName();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.never())).getAuthorizationID();
        ((OAuthBearerSaslServer)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeastOnce())).getNegotiatedProperty("OAUTHBEARER.token");
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).principalName();
        ((OAuthBearerToken)Mockito.verify((Object)token, (VerificationMode)Mockito.atLeastOnce())).value();
    }

    private OAuthBearerUnsecuredJws createImpersonatedUnsecuredJws(String issuer, String subject, String impersonatedBy, String principalClaimName, String groupsClaimName, String customSubClaim, String ... groups) {
        Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
        long tokenExp = System.currentTimeMillis() / 1000L + 50000L;
        String header = "{\"alg\":\"none\",\"typ\":\"JWT\"}";
        String payload = String.format("{\"iss\":\"%s\",\"sub\":\"%s\",\"customSubClaim\":\"%s\",\"%s\":[%s],\"%s\":\"%s\",\"exp\":%d}", issuer, subject, customSubClaim, groupsClaimName, Arrays.stream(groups).map(g -> "\"" + g + "\"").collect(Collectors.joining(",")), "cp_proxy", impersonatedBy, tokenExp);
        return new OAuthBearerUnsecuredJws(String.format("%s.%s.%s", urlEncoderNoPadding.encodeToString(header.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(payload.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString("".getBytes(StandardCharsets.UTF_8))), "sub", "scope");
    }

    private OAuthBearerUnsecuredJws createUnsecuredJws(String issuer, String subject, String principalClaimName, String groupsClaimName, String customSubClaim, String ... groups) {
        Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
        long tokenExp = System.currentTimeMillis() / 1000L + 50000L;
        String header = "{\"alg\":\"none\",\"typ\":\"JWT\"}";
        String payload = String.format("{\"iss\":\"%s\",\"sub\":\"%s\",\"customSubClaim\":\"%s\",\"%s\":[%s],\"exp\":%d}", issuer, subject, customSubClaim, groupsClaimName, Arrays.stream(groups).map(g -> "\"" + g + "\"").collect(Collectors.joining(",")), tokenExp);
        return new OAuthBearerUnsecuredJws(String.format("%s.%s.%s", urlEncoderNoPadding.encodeToString(header.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(payload.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString("".getBytes(StandardCharsets.UTF_8))), principalClaimName, "scope");
    }
}

