/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.test.TestUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jose4j.json.internal.json_simple.parser.JSONParser;
import org.jose4j.json.internal.json_simple.parser.ParseException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(OAuthUtils.class);

    static void writePemFile(File publicKeyFile, PublicKey publicKey) throws IOException {
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(publicKeyFile));
        pemWriter.writeObject((Object)publicKey);
        pemWriter.close();
    }

    static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    private static String sign(PrivateKey key, Integer expiration, String issuer, String subject, String[] audience, String orgResourceId, String uuid, String jku, String mayAct, String externalIdentityId, Map<String, String> additionalClaims) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(issuer);
            if (expiration != null) {
                NumericDate expirationTime = NumericDate.now();
                expirationTime.addSeconds((long)(expiration / 1000));
                claims.setExpirationTime(expirationTime);
            }
            claims.setGeneratedJwtId();
            claims.setIssuedAtToNow();
            claims.setNotBeforeMinutesInThePast(2.0f);
            claims.setStringClaim("orgResourceId", orgResourceId);
            if (subject != null) {
                claims.setSubject(subject);
            }
            if (mayAct != null) {
                JSONParser parser = new JSONParser();
                claims.setClaim("may_act", parser.parse(mayAct));
            }
            if (audience != null) {
                claims.setAudience(audience);
            }
            if (externalIdentityId != null) {
                claims.setStringClaim("externalIdentityId", externalIdentityId);
            }
            claims.setClaim("monitoring", (Object)true);
            claims.setClaim("userResourceId", (Object)("u-" + subject));
            for (Map.Entry entry : additionalClaims.entrySet()) {
                claims.setClaim((String)entry.getKey(), entry.getValue());
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)key);
            jws.setAlgorithmHeaderValue("RS256");
            if (uuid != null) {
                jws.setKeyIdHeaderValue(uuid);
            }
            if (jku != null) {
                jws.setHeader("jku", jku);
            }
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            log.error("Error creating JWS for test");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static class Builder {
        private final Integer expiration;
        private final String issuer;
        private final String subject;
        private final String orgResourceID;
        private String[] audience;
        private Integer[] userIds;
        private String jku;
        private Boolean withKid;
        private String mayAct;
        private String externalIdentityId;
        private Map<String, String> additionalClaims;

        public Builder(Integer expiration, String issuer, String subject, String orgResourceID) {
            this.expiration = expiration;
            this.issuer = issuer;
            this.subject = subject;
            this.orgResourceID = orgResourceID;
            this.audience = null;
            this.userIds = new Integer[0];
            this.jku = null;
            this.withKid = false;
            this.additionalClaims = new HashMap<String, String>();
        }

        public Builder audience(String audience) {
            if (audience != null) {
                return this.audience(new String[]{audience});
            }
            return this;
        }

        public Builder audience(String[] audience) {
            this.audience = audience;
            return this;
        }

        public Builder userIds(Integer[] userIds) {
            this.userIds = userIds;
            return this;
        }

        public Builder jku(String jku) {
            this.jku = jku;
            return this;
        }

        public Builder withKid(Boolean withKid) {
            this.withKid = withKid;
            return this;
        }

        public Builder mayAct(String mayAct) {
            this.mayAct = mayAct;
            return this;
        }

        public Builder externalIdentityId(String externalIdentityId) {
            this.externalIdentityId = externalIdentityId;
            return this;
        }

        public Builder additionalClaims(Map<String, String> additionalClaims) {
            if (additionalClaims != null) {
                this.additionalClaims.putAll(additionalClaims);
            }
            return this;
        }

        public JwsContainer build() throws Exception {
            KeyPair keyPair = OAuthUtils.generateKeyPair();
            File publicKeyFile = TestUtils.tempFile();
            OAuthUtils.writePemFile(publicKeyFile, keyPair.getPublic());
            String uuid = UUID.randomUUID().toString();
            String jws = OAuthUtils.sign(keyPair.getPrivate(), this.expiration, this.issuer, this.subject, this.audience, this.orgResourceID, this.withKid != false ? uuid : null, this.jku, this.mayAct, this.externalIdentityId, this.additionalClaims);
            HashMap<Integer, String> userTokens = new HashMap<Integer, String>();
            for (Integer userId : this.userIds) {
                String userJws = OAuthUtils.sign(keyPair.getPrivate(), this.expiration, this.issuer, userId + "", this.audience, this.orgResourceID, this.withKid != false ? uuid : null, this.jku, null, this.externalIdentityId, this.additionalClaims);
                userTokens.put(userId, userJws);
            }
            return new JwsContainer(jws, userTokens, publicKeyFile, keyPair.getPublic(), uuid);
        }
    }

    public static class JwsContainer {
        private final String jwsToken;
        private final File publicKeyFile;
        private final Map<Integer, String> userTokens;
        private PublicKey key;
        private String kid;

        public JwsContainer(String jwsToken, Map<Integer, String> userTokens, File publicKeyFile) {
            this(jwsToken, userTokens, publicKeyFile, null, null);
        }

        public JwsContainer(String jwsToken, Map<Integer, String> userTokens, File publicKeyFile, PublicKey key, String uuid) {
            this.jwsToken = jwsToken;
            this.userTokens = userTokens;
            this.publicKeyFile = publicKeyFile;
            this.key = key;
            this.kid = uuid;
        }

        public File getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public String getJwsToken() {
            return this.jwsToken;
        }

        public Map<Integer, String> userTokens() {
            return this.userTokens;
        }

        public PublicKey verificationKey() {
            return this.key;
        }

        public String getKid() {
            return this.kid;
        }
    }
}

