/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateTopicPolicyTest {
    static final Map<String, Integer> SAMPLE_TOPICS_TO_NUM_PARTITIONS = new HashMap<String, Integer>();
    static final Map<String, String> VALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> INVALID_SAMPLE_TOPIC_CONFIG;
    static final Map<String, String> SCHEMA_VALIDATION_TOPIC_CONFIG;

    @Test
    public void testEnsureValidPartitionCountTenantLimit() {
        CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)9, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidTenantPartitionCount((String)"foo", (int)10, (int)0, (int)11));
    }

    @Test
    public void testEnsureValidPartitionCountClusterLimit() {
        CreateTopicPolicy.ensureValidClusterPartitionCount((int)10, (int)1, (int)2);
        CreateTopicPolicy.ensureValidClusterPartitionCount((int)10, (int)9, (int)1);
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidClusterPartitionCount((int)0, (int)10, (int)2));
        Assertions.assertThrows(PolicyViolationException.class, () -> CreateTopicPolicy.ensureValidClusterPartitionCount((int)0, (int)10, (int)11));
    }

    @Test
    public void testFullUpdate() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap());
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)4, (Integer)ctx.metricValue("lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("lkc-fghij"));
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-klmno"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("lkc-klmno"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
        }
    }

    @Test
    public void testPartialUpdates() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), new HashMap());
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("lkc-abcde"));
            ctx.policy.partialUpdate("blah", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals((Integer)2, (Integer)ctx.metricValue("lkc-abcde"));
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), false);
            ctx.policy.partialUpdate("lkc-xyzab_", 2, -1, Collections.emptyMap(), Collections.emptyMap(), false);
            Assertions.assertEquals((int)0, (int)ctx.policy.numPartitions("lkc-abcde"));
            Assertions.assertEquals(null, (Integer)ctx.metricValue("lkc-abcde"));
            Assertions.assertEquals((int)1, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertEquals((Integer)1, (Integer)ctx.metricValue("lkc-fghij"));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap()));
            ctx.policy.partialUpdate("lkc-fghij_baz", 4, 1, Collections.emptyMap(), Collections.emptyMap(), false);
            Assertions.assertEquals((int)5, (int)ctx.policy.numPartitions("lkc-fghij"));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_blah", null, null, Collections.singletonMap(2, Arrays.asList(0, 1, 2)), Collections.emptyMap())));
        }
    }

    @Test
    public void testPendingUpdates() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.partialUpdate("lkc-abcde_foo", -2, -1, Collections.emptyMap(), Collections.emptyMap(), true);
            Assertions.assertEquals((int)2, (int)ctx.policy.numPartitions("lkc-abcde"));
            ctx.policy.partialUpdate("lkc-abcde_foo", 2, 1, Collections.emptyMap(), Collections.emptyMap(), true);
            Assertions.assertEquals((int)4, (int)ctx.policy.numPartitions("lkc-abcde"));
            ctx.policy.clearPending();
        }
    }

    @Test
    public void testTooManyTopics() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 5, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertEquals((Object)"You may not create more than the maximum number of partitions (5).", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"You may not create more than 1 new partitions. Adding the requested number of partitions will exceed 5 total partitions. Currently, there are 4 total topic partitions", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterTopics() {
        int maxTopicsPerCluster = 3;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, Integer.MAX_VALUE, maxTopicsPerCluster, false, Integer.MAX_VALUE, Integer.MAX_VALUE);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertEquals((Object)"The cluster has reached the maximum number of topics.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterPartitions() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, 10, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertEquals((Object)"You may not create more than 5 new partitions. Adding the requested number of partitions will exceed cluster limits.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(6), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testTooManyClusterPartitionsAlreadyCreated() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, 5, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertEquals((Object)"The cluster has reached the maximum number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testInvalidRequestMetadata() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Invalid topic name specified.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_::", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", Integer.valueOf(1), Short.valueOf((short)2), null, Collections.emptyMap())))).getMessage());
            Assertions.assertEquals((Object)"Must specify number of partitions.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, Collections.emptyMap(), Collections.emptyMap())))).getMessage());
            HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
            assignments.put(0, Arrays.asList(5, 6, 7, 8));
            assignments.put(1, Arrays.asList(8, 7, 6, 5));
            Assertions.assertEquals((Object)"Topic replication factor must be 3", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_foo", null, null, assignments, Collections.emptyMap())))).getMessage());
        }
    }

    @Test
    public void testSettingTopicConfigs() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG));
            Assertions.assertEquals((Object)"Altering config property 'foobar' is disallowed.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG)))).getMessage());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(3), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG)));
        }
    }

    @Test
    public void rejectsInvalidMinInSyncReplicasConfig() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '0' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "0"))))).getMessage());
            Assertions.assertEquals((Object)"Config property 'min.insync.replicas' with value '4' must be greater or equal to 1 and less than 3, or left empty.", (Object)((PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("min.insync.replicas", "4"))))).getMessage());
        }
    }

    @Test
    public void rejectsDeleteRetentionMsToHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("delete.retention.ms", "60566400001"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "52428799"))));
        }
    }

    @Test
    public void rejectsSegmentBytesTooHigh() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.bytes", "1073741825"))));
        }
    }

    @Test
    public void rejectSegmentMsTooLow() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, Collections.singletonMap("segment.ms", "500000"))));
        }
    }

    @Test
    public void testNonTenantTopicsAreExempt() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("not-a-tenant-topic", Integer.valueOf(1000), Short.valueOf((short)30), null, Collections.emptyMap()));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("blah_abc", Integer.valueOf(100), Short.valueOf((short)3), null, INVALID_SAMPLE_TOPIC_CONFIG));
        }
    }

    @Test
    public void rejectsWhenTopicMetadataNotSet() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2, Integer.MAX_VALUE, false);){
            Assertions.assertThrows(NotControllerException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-fghij_quux", Integer.valueOf(1), Short.valueOf((short)3), null, VALID_SAMPLE_TOPIC_CONFIG)));
        }
    }

    @Test
    public void acceptSchemaValidationPropertiesWhenFeatureEnabled() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 7, Integer.MAX_VALUE, true);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(2), Short.valueOf((short)3), null, SCHEMA_VALIDATION_TOPIC_CONFIG));
        }
    }

    @Test
    public void rejectRequestWithTooManyPartitions() {
        int maxPartitionsPerTenant = 1000;
        int maxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, maxPartitionsPerRequest, Integer.MAX_VALUE);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(maxPartitionsPerRequest), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(maxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void acceptInternalTopicRequestWithTooManyPartitions() {
        int maxPartitionsPerTenant = 1000;
        int maxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, maxPartitionsPerRequest, Integer.MAX_VALUE);){
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("__consumer_offsets", Integer.valueOf(maxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap()));
        }
    }

    @Test
    public void testReconfigureMaxPartitionsPerRequest() {
        int maxPartitionsPerTenant = 1000;
        int initialMaxPartitionsPerRequest = 100;
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, maxPartitionsPerTenant, Integer.MAX_VALUE, Integer.MAX_VALUE, false, initialMaxPartitionsPerRequest, Integer.MAX_VALUE);){
            Assertions.assertTrue((boolean)ctx.policy.reconfigurableConfigs().contains("confluent.multitenant.max.partitions.per.request"));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(initialMaxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
            int updateMaxPartitionsPerRequest = 200;
            HashMap<String, String> newConfigs = new HashMap<String, String>(ctx.configs);
            newConfigs.put("confluent.multitenant.max.partitions.per.request", String.valueOf(updateMaxPartitionsPerRequest));
            ctx.policy.reconfigure(newConfigs);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(updateMaxPartitionsPerRequest), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(updateMaxPartitionsPerRequest + 1), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void testFullUpdateWithDeletedTenant() {
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, 2048, 1000, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE);){
            HashMap<String, Integer> tenantOnePartitions = new HashMap<String, Integer>();
            tenantOnePartitions.put("lkc-tenant1_foo", 1000);
            ctx.policy.fullUpdate(tenantOnePartitions.entrySet().iterator(), new HashMap());
            HashMap<String, Integer> tenantTwoPartitions = new HashMap<String, Integer>();
            tenantTwoPartitions.put("lkc-tenant2_bar", 500);
            ctx.policy.fullUpdate(tenantTwoPartitions.entrySet().iterator(), new HashMap());
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-tenant3_quux", Integer.valueOf(500), Short.valueOf((short)3), null, Collections.emptyMap()));
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-tenant3_quux", Integer.valueOf(501), Short.valueOf((short)3), null, Collections.emptyMap())));
        }
    }

    @Test
    public void testMaxReplicasPerBroker() {
        int maxReplicasPerBroker = 1000;
        HashMap<Integer, Integer> replicasPerBrokerAtCapacity = new HashMap<Integer, Integer>();
        replicasPerBrokerAtCapacity.put(0, maxReplicasPerBroker);
        replicasPerBrokerAtCapacity.put(1, 6);
        HashMap<Integer, Integer> replicasPerBrokerAtUnderCapacity = new HashMap<Integer, Integer>();
        replicasPerBrokerAtUnderCapacity.put(0, maxReplicasPerBroker - 1);
        HashMap<Integer, ArrayList<Integer>> replicaAssignment = new HashMap<Integer, ArrayList<Integer>>();
        replicaAssignment.put(0, new ArrayList<Integer>(Arrays.asList(0, 1, 2)));
        HashMap<Integer, List<Integer>> overReplicasPerBrokerAssignment = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < maxReplicasPerBroker + 1; ++i) {
            overReplicasPerBrokerAssignment.put(i, Arrays.asList(0, 1, 2));
        }
        HashMap<Integer, List<Integer>> underReplicasPerBrokerAssignment = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < maxReplicasPerBroker; ++i) {
            underReplicasPerBrokerAssignment.put(i, Arrays.asList(0, 1, 2));
        }
        try (CreateTopicPolicyTestContext ctx = new CreateTopicPolicyTestContext(3, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, false, Integer.MAX_VALUE, maxReplicasPerBroker);){
            Assertions.assertTrue((boolean)ctx.policy.reconfigurableConfigs().contains("confluent.plugins.topic.policy.max.replicas.per.broker"));
            ctx.policy.fullUpdate(Collections.emptyIterator(), Collections.emptyMap());
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), overReplicasPerBrokerAssignment, Collections.emptyMap())));
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), underReplicasPerBrokerAssignment, Collections.emptyMap()));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), replicasPerBrokerAtUnderCapacity);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            ctx.policy.fullUpdate(SAMPLE_TOPICS_TO_NUM_PARTITIONS.entrySet().iterator(), replicasPerBrokerAtCapacity);
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap())));
            int additionalReplicasPerBrokerCapacity = 2;
            HashMap<String, String> newConfigs = new HashMap<String, String>(ctx.configs);
            newConfigs.put("confluent.plugins.topic.policy.max.replicas.per.broker", String.valueOf(maxReplicasPerBroker + additionalReplicasPerBrokerCapacity));
            ctx.policy.reconfigure(newConfigs);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            HashMap<Integer, ArrayList<Integer>> partitionIdToReplicasAdded = new HashMap<Integer, ArrayList<Integer>>();
            partitionIdToReplicasAdded.put(0, new ArrayList<Integer>(Collections.singletonList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, partitionIdToReplicasAdded, new HashMap(), false);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
            partitionIdToReplicasAdded = new HashMap();
            partitionIdToReplicasAdded.put(1, new ArrayList<Integer>(Arrays.asList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, partitionIdToReplicasAdded, new HashMap(), false);
            Assertions.assertThrows(PolicyViolationException.class, () -> ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap())));
            HashMap<Integer, ArrayList<Integer>> partitionIdToReplicasRemoved = new HashMap<Integer, ArrayList<Integer>>();
            partitionIdToReplicasRemoved.put(0, new ArrayList<Integer>(Arrays.asList(0)));
            partitionIdToReplicasRemoved.put(1, new ArrayList<Integer>(Arrays.asList(0)));
            ctx.policy.partialUpdate("lkc-abcde_quux", 1, 1, new HashMap(), partitionIdToReplicasRemoved, false);
            ctx.policy.validate(new CreateTopicPolicy.RequestMetadata("lkc-abcde_quux", Integer.valueOf(1), Short.valueOf((short)3), replicaAssignment, Collections.emptyMap()));
        }
    }

    static {
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-abcde_foo", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-abcde_bar", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("baz", 2);
        SAMPLE_TOPICS_TO_NUM_PARTITIONS.put("lkc-fghij_bar", 1);
        VALID_SAMPLE_TOPIC_CONFIG = new HashMap<String, String>();
        VALID_SAMPLE_TOPIC_CONFIG.put("max.message.bytes", "10000");
        VALID_SAMPLE_TOPIC_CONFIG.put("retention.ms", Integer.toString(Integer.MAX_VALUE));
        VALID_SAMPLE_TOPIC_CONFIG.put("min.insync.replicas", "2");
        INVALID_SAMPLE_TOPIC_CONFIG = new HashMap<String, String>();
        INVALID_SAMPLE_TOPIC_CONFIG.put("max.message.bytes", "10000");
        INVALID_SAMPLE_TOPIC_CONFIG.put("foobar", "baz");
        SCHEMA_VALIDATION_TOPIC_CONFIG = new HashMap<String, String>();
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.key.schema.validation", "true");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.value.schema.validation", "false");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        SCHEMA_VALIDATION_TOPIC_CONFIG.put("confluent.context.name", ".customContext");
    }

    static class CreateTopicPolicyTestContext
    implements AutoCloseable {
        final CreateTopicPolicy policy = new CreateTopicPolicy();
        final Metrics metrics;
        final Map<String, String> configs = new HashMap<String, String>();

        CreateTopicPolicyTestContext(int replicationFactor, int maxPartitionsPerTenant, int maxPartitionsPerCluster, boolean schemaValidationEnabled) {
            this(replicationFactor, maxPartitionsPerTenant, maxPartitionsPerCluster, Integer.MAX_VALUE, schemaValidationEnabled, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        CreateTopicPolicyTestContext(int replicationFactor, int maxPartitionsPerTenant, int maxPartitionsPerCluster, int maxTopicsPerCluster, boolean schemaValidationEnabled, int maxPartitionsPerRequest, int maxReplicasPerBroker) {
            this.configs.put("confluent.plugins.topic.policy.replication.factor", String.valueOf(replicationFactor));
            this.configs.put("confluent.plugins.topic.policy.max.partitions.per.tenant", String.valueOf(maxPartitionsPerTenant));
            this.configs.put("confluent.multitenant.max.partitions.per.request", String.valueOf(maxPartitionsPerRequest));
            this.configs.put("confluent.plugins.topic.policy.max.partitions.per.cluster", String.valueOf(maxPartitionsPerCluster));
            this.configs.put("confluent.plugins.topic.policy.max.topics.per.cluster", String.valueOf(maxTopicsPerCluster));
            this.configs.put("confluent.plugins.topic.policy.max.replicas.per.broker", String.valueOf(maxReplicasPerBroker));
            if (schemaValidationEnabled) {
                this.configs.put("confluent.schema.validator.multitenant.enable", "true");
            }
            this.policy.configure(this.configs);
            this.metrics = new Metrics();
            this.policy.registerMetrics(this.metrics);
        }

        Integer metricValue(String tenant) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("tenant", tenant);
            MetricName name = this.metrics.metricName("partitions", "tenant-metrics", "", tags);
            KafkaMetric metric = this.metrics.metric(name);
            if (metric != null) {
                return (Integer)metric.metricValue();
            }
            return null;
        }

        @Override
        public void close() {
            this.policy.close();
            this.metrics.close();
        }
    }
}

