/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Config {
    public static final String OAUTH_CONNECT_TIMEOUT_SECONDS = "oauth.connect.timeout.seconds";
    public static final String OAUTH_READ_TIMEOUT_SECONDS = "oauth.read.timeout.seconds";
    private Map<String, ?> defaults;
    Config delegate;

    public Config() {
    }

    public Config(Properties p) {
        this.defaults = p.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (v1, v2) -> v2, HashMap::new));
    }

    public Config(Config delegate) {
        this.delegate = delegate;
    }

    public Config(Map<String, ?> p) {
        this.defaults = Collections.unmodifiableMap(p);
    }

    public void validate() {
    }

    public String getValue(String key, String fallback) {
        if (this.delegate != null) {
            return this.delegate.getValue(key, fallback);
        }
        String result = System.getProperty(key, null);
        if (result != null) {
            return result;
        }
        result = System.getenv(Config.toEnvName(key));
        if (result != null) {
            return result;
        }
        result = System.getenv(key);
        if (result != null) {
            return result;
        }
        if (this.defaults != null) {
            Object val = this.defaults.get(key);
            result = val != null ? String.valueOf(val) : null;
        }
        return result != null ? result : fallback;
    }

    public final String getValue(String key) {
        return this.getValue(key, null);
    }

    public final int getValueAsInt(String key, int fallback) {
        String result = this.getValue(key);
        return result != null ? Integer.parseInt(result) : fallback;
    }

    public static String toEnvName(String key) {
        return key.toUpperCase(Locale.ENGLISH).replace('-', '_').replace('.', '_');
    }
}

